<?php
/**
 * Register navigation menus for Appearance > Menus.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'register_nav_menu' ) ) {
	return;
}

/**
 * Add navigation menus to WP admin.
 */
function add_theme_menus() {
	// Theme main navigation used with wp_nav_menu().
	register_nav_menu(
		'main-nav',
		esc_html__( 'Main Menu', 'developry-lite' )
	);

	// Theme social navigation used with wp_nav_menu().
	register_nav_menu(
		'social-nav',
		esc_html__( 'Social Menu', 'developry-lite' )
	);
}

add_action( 'after_setup_theme', __NAMESPACE__ . '\add_theme_menus' );
