<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure sidebar visibility option in WP Customizer > Theme Options.
 */
function add_sidebar( $wp_customize ) {
	/**
	 * Theme sidebar option added to WP Customizer > Theme Options
	 */
	class Sidebar extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {

			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="d-none" <?php echo ( 'd-none' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'No Sidebar  (default)', 'developry-lite' ); ?>
					</option>
					<option value="order-last" <?php echo ( 'order-last' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Sidebar Right', 'developry-lite' ); ?>
					</option>
					<option value="order-first" <?php echo ( 'order-first' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Left Sidebar', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_sidebar' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[sidebar]',
		array(
			'default'           => 'd-none',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Sidebar(
			$wp_customize,
			'developry_lite_theme[sidebar]',
			array(
				'label'       => esc_html__( 'Sidebar', 'developry-lite' ),
				'description' => esc_html__( 'Change the placement and visibility of your posts and static pages (if applicable) sidebar with widgets.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[sidebar]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_sidebar' );
