<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure search form display options in WP Customizer > Theme Options.
 */
function add_search_form( $wp_customize ) {
	/**
	 * Theme search form display options added to WP Customizer > Theme Options
	 */
	class Search_Form extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="d-block" <?php echo ( '' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Show (default)', 'developry-lite' ); ?>
					</option>
					<option value="d-none" <?php echo ( 'hide' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Hide', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_search_form' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[search_form]',
		array(
			'default'           => 'd-block',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Search_Form(
			$wp_customize,
			'developry_lite_theme[search_form]',
			array(
				'label'       => esc_html__( 'Search Form', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the search form located in the navbar.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[search_form]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_search_form' );
