<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure site identify visibility default options in WP Customizer > Site Identity.
 */
function add_site_identify( $wp_customize ) {
	/**
	 * Theme site identify visibility default options added to WP Customizer > Site Identity
	 */

	// Blog website name.
	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->selective_refresh->add_partial(
		'blogname',
		array(
			// Remember to add the class name to navbar.php
			'selector'        => '.site-title',
			'render_callback' => function() {
				bloginfo( 'name' );
			},
		)
	);

	// Blog description.
	// $wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
	// $wp_customize->selective_refresh->add_partial(
	// 	'blogdescription',
	// 	array(
	// 		'selector'        => '.site-description',
	// 		'render_callback' => function() {
	// 			get_bloginfo( 'description' );
	// 		},
	// 	)
	// );

	// Default header image inside the page cover.
	$wp_customize->get_setting( 'header_image' )->transport = 'postMessage';
	$wp_customize->selective_refresh->add_partial(
		'header_image',
		array(
			'selector'        => '.cover-img',
			'render_callback' => function() {
				if ( has_post_thumbnail() ) {
					the_post_thumbnail_url();
				} else {
					header_image();
				}
			},
		)
	);

	// Sidebar widgets for copyright widget.
	$wp_customize->selective_refresh->add_partial(
		'sidebars_widgets[copyright-1]',
		array(
			// Remember to add the class name to footer-copyright.php
			'selector'        => '.footer-copyright',
			'render_callback' => function() {
				dynamic_sidebar( 'copyright-1' );
			},
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_site_identify' );
