<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure page cover visibility options in WP Customizer > Theme Options.
 */
function add_page_cover( $wp_customize ) {
	/**
	 * Theme page cover visibility options added to WP Customizer > Theme Options
	 */
	class Page_Cover extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="d-block" <?php echo ( 'show' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Show (default)', 'developry-lite' ); ?>
					</option>
					<option value="d-none" <?php echo ( 'hide' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Hide', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_page_cover' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[page_cover]',
		array(
			'default'           => 'd-block',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Page_Cover(
			$wp_customize,
			'developry_lite_theme[page_cover]',
			array(
				'label'       => esc_html__( 'Page Cover', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the page cover at top of posts and pages. A placeholder header image will be displayed in case of missing featured image which can be customized in Theme Options > Header Image', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[page_cover]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_page_cover' );
