<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure navbar text color options in WP Customizer > Theme Options.
 */
function add_navbar_text_color( $wp_customize ) {
	/**
	 * Theme body navbar text color options added to WP Customizer > Theme Options
	 */
	class Navbar_Text_Color extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="navbar-dark" <?php echo ( 'navbar-dark' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Light (default)', 'developry-lite' ); ?>
					</option>
					<option value="" <?php echo ( '' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Dark', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_optionsnavbar_text_color' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[navbar_text_color]',
		array(
			'default'           => 'navbar-dark',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Navbar_Text_Color(
			$wp_customize,
			'developry_lite_theme_options[navbar_text_color]',
			array(
				'label'       => esc_html__( 'Navbar Text', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the text color for the navbar element between light/dark.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[navbar_text_color]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_navbar_text_color' );
