<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure navbar background color options in WP Customizer > Theme Options.
 */
function add_navbar_background_color( $wp_customize ) {
	/**
	 * Theme navbar background color options added to WP Customizer > Theme Options
	 */
	class Navbar_Background_Color extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="bg-primary" <?php echo ( 'bg-primary' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Primary (default)', 'developry-lite' ); ?>
					</option>
					<option value="bg-secondary" <?php echo ( 'bg-secondary' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Secondary', 'developry-lite' ); ?>
					</option>
					<option value="bg-dark" <?php echo ( 'bg-dark' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Dark', 'developry-lite' ); ?>
					</option>
					<option value="bg-light" <?php echo ( 'bg-light' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Light', 'developry-lite' ); ?>
					</option>
					<option value="bg-black" <?php echo ( 'bg-black' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Black', 'developry-lite' ); ?>
					</option>
					<option value="bg-white" <?php echo ( 'bg-white' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'White', 'developry-lite' ); ?>
					</option>
					<option value="bg-transparent" <?php echo ( 'bg-transparent' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Transparent', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_navbar_background_color' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[navbar_background_color]',
		array(
			'default'           => 'bg-primary',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Navbar_Background_Color(
			$wp_customize,
			'developry_lite_theme[navbar_background_color]',
			array(
				'label'       => esc_html__( 'Navbar', 'developry-lite' ),
				'description' => esc_html__( 'Change the background color for the navbar element.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[navbar_background_color]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_navbar_background_color' );
