<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure header position options in WP Customizer > Theme Options.
 */
function add_header_position( $wp_customize ) {
	/**
	 * Theme header position options added to WP Customizer > Theme Options
	 */
	class Header_Position extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="position-static" <?php echo ( 'position-static' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Static (default)', 'developry-lite' ); ?>
					</option>
					<option value="position-fixed" <?php echo ( 'position-fixed' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Fixed', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_header_position' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[header_position]',
		array(
			'default'           => 'position-static',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Header_Position(
			$wp_customize,
			'developry_lite_theme[header_position]',
			array(
				'label'       => esc_html__( 'Header Position', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the header (inluding the navbar) position between static/fixed.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[header_position]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_header_position' );
