<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure container width options in WP Customizer > Theme Options.
 */
function add_container_width( $wp_customize ) {
	/**
	 * Theme container width options added to WP Customizer > Theme Options
	 */
	class Container_Width extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="" <?php echo ( '' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Fixed (default)', 'developry-lite' ); ?>
					</option>
					<option value="-fluid" <?php echo ( '-fluid' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Fluid', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_container_width' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[container_width]',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Container_Width(
			$wp_customize,
			'developry_lite_theme[container_width]',
			array(
				'label'       => esc_html__( 'Container Width', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the container width between fixed/fluid.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[container_width]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_container_width' );
