<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure Bootswatch stylesheets option in WP Customizer > Theme Options.
 */
function add_bootswatch( $wp_customize ) {
	/**
	 * Theme Bootswatch option added to WP Customizer > Theme Options
	 */
	class Bootswatch extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();

			?>
			<label class="customize-control-title">
				<?php echo esc_html( $this->label ); ?>
			</label>
			<select class="customize-control" <?php $this->link(); ?>>
				<option value="zephyr" <?php echo ( 'zephyr' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Zephyr  (default)', 'developry-lite' ); ?>
				</option>
				<option value="zephyr">--</option>
				<option value="base" <?php echo ( 'base' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Base', 'developry-lite' ); ?>
				</option>
				<option value="cerulean" <?php echo ( 'cerulean' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Cerulean', 'developry-lite' ); ?>
				</option>
				<option value="cosmo" <?php echo ( 'cosmo' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Cosmo', 'developry-lite' ); ?>
				</option>
				<option value="cyborg" <?php echo ( 'cyborg' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Cyborg', 'developry-lite' ); ?>
				</option>
				<option value="darkly" <?php echo ( 'darkly' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Darkly', 'developry-lite' ); ?>
				</option>
				<option value="flatly" <?php echo ( 'flatly' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Flatly', 'developry-lite' ); ?>
				</option>
				<option value="journal" <?php echo ( 'journal' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Journal', 'developry-lite' ); ?>
				</option>
				<option value="litera" <?php echo ( 'litera' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Litera', 'developry-lite' ); ?>
				</option>
				<option value="lumen" <?php echo ( 'lumen' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Lumen', 'developry-lite' ); ?>
				</option>
				<option value="lux" <?php echo ( 'lux' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Lux', 'developry-lite' ); ?>
				</option>
				<option value="materia" <?php echo ( 'materia' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Materia', 'developry-lite' ); ?>
				</option>
				<option value="minty" <?php echo ( 'minty' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Minty', 'developry-lite' ); ?>
				</option>
				<option value="morph" <?php echo ( 'morph' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Morph', 'developry-lite' ); ?>
				</option>
				<option value="pulse" <?php echo ( 'pulse' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Pulse', 'developry-lite' ); ?>
				</option>
				<option value="quartz" <?php echo ( 'quartz' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Quartz', 'developry-lite' ); ?>
				</option>
				<option value="sandstone" <?php echo ( 'sandstone' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Sandstone', 'developry-lite' ); ?>
				</option>
				<option value="simplex" <?php echo ( 'simplex' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Simplex', 'developry-lite' ); ?>
				</option>
				<option value="sketchy" <?php echo ( 'sketchy' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Sketchy', 'developry-lite' ); ?>
				</option>
				<option value="slate" <?php echo ( 'slate' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Slate', 'developry-lite' ); ?>
				</option>
				<option value="solar" <?php echo ( 'solar' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Solar', 'developry-lite' ); ?>
				</option>
				<option value="spacelab" <?php echo ( 'spacelab' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Spacelab', 'developry-lite' ); ?>
				</option>
				<option value="superhero" <?php echo ( 'superhero' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Superhero', 'developry-lite' ); ?>
				</option>
				<option value="united" <?php echo ( 'united' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'United', 'developry-lite' ); ?>
				</option>
				<option value="vapor" <?php echo ( 'vapor' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Vapor', 'developry-lite' ); ?>
				</option>
				<option value="yeti" <?php echo ( 'yeti' === $option ) ? 'selected' : ''; ?>>
					<?php echo esc_html__( 'Yeti', 'developry-lite' ); ?>
				</option>
			</select>
			<br clear="all" />
			<p class="customize-control-description developry-lite-customizer-control-description">
				<?php echo esc_html( $this->description ); ?>
			</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_options_bootswatch_theme' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[bootswatch_theme]',
		array(
			'default'           => 'zephyr',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Bootswatch(
			$wp_customize,
			'developry_lite_theme[bootswatch_theme]',
			array(
				'label'       => esc_html__( 'Theme', 'developry-lite' ),
				'description' => esc_html__( 'Change the look of your website by selecting one of the themes below. (special thanks to Bootswatch).', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[bootswatch_theme]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_bootswatch' );
