<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure ALL body text color options in WP Customizer > Theme Options.
 */
function add_body_text_color( $wp_customize ) {
	/**
	 * Theme ALL body text color options added to WP Customizer > Theme Options
	 */
	class Body_Text_Color extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'select';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			$option = $this->value();
			?>
				<label class="customize-control-title">
					<?php echo esc_html( $this->label ); ?>
				</label>
				<select class="customize-control" <?php $this->link(); ?>>
					<option value="body-black-text" <?php echo ( 'body-black-text' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'Black (default)', 'developry-lite' ); ?>
					</option>
					<option value="body-white-text" <?php echo ( 'body-white-text' === $option ) ? 'selected' : ''; ?>>
						<?php echo esc_html__( 'White', 'developry-lite' ); ?>
					</option>
				</select>
				<br clear="all" />
				<p class="customize-control-description developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->selective_refresh->add_partial( 'developry_lite_theme_optionsbody_text_color' );

	$wp_customize->add_setting(
		'developry_lite_theme_options[body_text_color]',
		array(
			'default'           => 'body-black-text',
			'sanitize_callback' => 'esc_attr',
			'transport'         => 'postMessage',
			'capability'        => 'edit_theme_options',
		)
	);

	$wp_customize->add_control(
		new Body_Text_Color(
			$wp_customize,
			'developry_lite_theme_options[body_text_color]',
			array(
				'label'       => esc_html__( 'Body Text', 'developry-lite' ),
				'description' => esc_html__( 'Toggle the text color for ALL body elements between black and white. This will give you the text contrast if you choose to have darker colors as background colors.', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'settings'    => 'developry_lite_theme_options[body_text_color]',
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_body_text_color' );
