<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( class_exists( 'WP_Customize_Section' ) ) {
	/**
	 * Customizer Developry documentation link.
	 */
	class Documentation_Section extends \WP_Customize_Section {
		/**
		 * The type of customize section being rendered.
		 */
		public $type = 'developry_lite_docs'; // Cannot use '-' for spacing.
		/**
		 * Custom button text to output.
		 */
		public $text = '';
		/**
		 * Custom pro button URL.
		 */
		public $url = '';

		/**
		 * Add custom parameters to pass to the JS via JSON.
		 */
		public function json() {
			$json         = parent::json();
			$json['text'] = esc_html( $this->text );
			$json['url']  = esc_url( $this->url );
			return $json;
		}

		/**
		 * Outputs the Underscore.js template.
		 */
		protected function render_template() {
			?>
			<li id="accordion-section-{{ data.id }}" class="accordion-section control-section control-section-{{ data.type }} cannot-expand">
				<h3 class="accordion-section-title">
					{{ data.title }}
					<# if ( data.text && data.url ) { #>
						<a href="{{ data.url }}" class="button button-primary button-large alignright" target="_blank">{{ data.text }}</a>
					<# } #>
				</h3>
			</li>
			<?php
		}
	}
}

/**
 * Singleton class for handling the theme's customizer integration for our Documentaion panel link.
 */
final class Documentation_Customize {
	/**
	 * Singleton class instance.
	 */
	public static function get_instance() {
		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor.
	 */
	private function __construct() {}

	/**
	 * Attach JS control scripts and stylsheeets for our Documentaion panel link.
	 */
	private function setup_actions() {
		add_action( 'customize_register', array( $this, 'sections' ) );
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ) );
	}

	/**
	 * Configure WP Customizer for our Documentaion panel link.
	 */
	public function sections( $wp_customize ) {
		$wp_customize->register_section_type( __NAMESPACE__ . '\Documentation_Section' );

		$wp_customize->add_section(
			new Documentation_Section(
				$wp_customize,
				'developry_lite_docs', // Cannot use '-' for spacing.
				array(
					'title'    => esc_html__( 'Developry Lite', 'developry-lite' ),
					'text'     => esc_html__( 'Get Help', 'developry-lite' ),
					'url'      => esc_url( DEVELOPRY_LITE_DOCS_URL ),
					'priority' => 182,
				)
			)
		);
	}

	/**
	 * Load WP Customizer JS scripts and stylesheets for our Documentaion panel link.
	 */
	public function enqueue_control_scripts() {
		wp_enqueue_script(
			'developry-lite-customizer-controls',
			DEVELOPRY_LITE_THEME_URI . '/assets/dist/js/customizer-controls.min.js',
			array( 'jquery', 'customize-controls' ),
			null,
			true
		);

		wp_enqueue_style(
			'developry-lite-customizer-controls',
			DEVELOPRY_LITE_THEME_URI . '/assets/dist/css/customizer-controls.min.css'
		);
	}
}

// Execute.
Documentation_Customize::get_instance();
