<?php
/**
 * [Short description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Attach/configure colors static text in WP Customizer > Theme Options.
 */
function add_colors_static_text( $wp_customize ) {
	/**
	 * Theme colors static text added to WP Customizer > Theme Options
	 */
	class Colors_Static_Text extends \WP_Customize_Control {
		/**
		 * WP Customizer field type.
		 */
		public $type = 'heading_with_description';

		/**
		 * Print out the custom option HTML structure.
		 */
		public function render_content() {
			?>
				<hr />
				<h2 class="developry-lite-customizer-control-title">
					<?php echo esc_html( $this->label ); ?>
				</h2>
				<p class="developry-lite-customizer-control-description">
					<?php echo esc_html( $this->description ); ?>
				</p>
			<?php
		}
	}

	$wp_customize->add_setting(
		'developry_lite_theme_options[colors_static_text]',
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_attr',
			'transport'         => '',
			'capability'        => '',
		)
	);

	$wp_customize->add_control(
		new Colors_Static_Text(
			$wp_customize,
			'developry_lite_theme_options[colors_static_text]',
			array(
				'label'       => esc_html__( 'Color Controls', 'developry-lite' ),
				'section'     => 'developry_lite_theme_options',
				'description' => esc_html__( 'Use the options below to additionally customize each custom theme major sections background and text colors to contol dark/light themes. Hint: Use the transparent option for overlapping elements.', 'developry-lite' ),
			)
		)
	);
}

add_action( 'customize_register', __NAMESPACE__ . '\add_colors_static_text' );
