<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

$body_classes = ( 'd-none' === $theme_options['page_cover'] ) ? 'pt-5' : '';
$body_classes = ( 'd-none' === $theme_options['page_cover'] && 'position-fixed' === $theme_options['header_position'] ) ? 'pt-10' : '';

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
	<link rel="profile" href="http://gmpg.org/xfn/11" />

	<?php wp_head(); ?>

	<?php if ( get_header_textcolor() ) : ?>
		<style type="text/css">
			#header, #header a { color: #<?php echo esc_attr( get_header_textcolor() ); ?>; }
		</style>
	<?php endif; ?>
</head>

<body <?php echo esc_html( body_class( $theme_options['body_background_color'] . ' ' . $theme_options['body_text_color'] ) ); ?>>
	<?php wp_body_open(); ?>

	<header id="header" class="header <?php echo $theme_options['header_position']; ?> <?php echo $theme_options['header_background_color']; ?>">
		<a class="skip-link screen-reader-text" href="#body">
			<?php echo esc_html__( 'Skip to content', 'developry-lite' ); ?>
		</a>

		<?php get_template_part( 'template-parts/header/navbar' ); ?>
	</header>

	<?php
	if ( is_page() || is_front_page() ) {
		if ( 'd-block' === $theme_options['page_cover'] ) {
			get_template_part( 'template-parts/header/page', 'cover' );
		}
	}
	?>

	<div id="body" class="body <?php echo $theme_options['content_background_color']; ?> <?php echo $body_classes; ?>">
		<div class="container<?php echo $theme_options['container_width']; ?>">
			<div class="row">
				<?php if ( is_page( get_option( 'page_for_posts' ) ) || is_home() || is_single() ) : ?>
					<div class="col-12 <?php echo ( 'd-none' !== $theme_options['sidebar'] ) ? 'col-lg-8' : ''; ?>">
				<?php else : ?>
					<div class="col-12">
				<?php endif; ?>
					<main class="page-content">
