<?php
/**
 * Theme functions/classes with support to basic and custom WordPress components.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

/**
 * Define some global URLs used within the theme files.
 */
define( 'DEVELOPRY_LITE_THEME_URI', get_template_directory_uri() );
define( 'DEVELOPRY_LITE_DOCS_URL', 'https://krasenslavov.com/themes/developry-lite' );
define( 'DEVELOPRY_LITE_RATE_URL', 'https://wordpress.org/support/theme/developry-lite/reviews/' );
define( 'DEVELOPRY_LITE_SUPPORT_URL', 'https://wordpress.org/support/theme/developry-lite/' );

/**
 * Get theme options and esc or set defaults if empty. No need for prefix since DB is `theme_mods_developry-lite`.
 */
$theme_options = ( get_theme_mod( 'developry_lite_theme_options' ) )
	? array_map( 'esc_attr', get_theme_mod( 'developry_lite_theme_options' ) )
	: array();

define(
	'DEVELOPRY_LITE_THEME_OPTIONS',
	json_encode(
		array(
			'bootswatch_theme'         => ( array_key_exists( 'bootswatch_theme', $theme_options ) ) ? $theme_options['bootswatch_theme'] : 'zephyr',
			'header_position'          => ( array_key_exists( 'header_position', $theme_options ) ) ? $theme_options['header_position'] : '',
			'container_width'          => ( array_key_exists( 'container_width', $theme_options ) ) ? $theme_options['container_width'] : '',
			'page_cover'               => ( array_key_exists( 'page_cover', $theme_options ) ) ? $theme_options['page_cover'] : 'd-block',
			'page_title'               => ( array_key_exists( 'page_title', $theme_options ) ) ? $theme_options['page_title'] : '',
			'sidebar'                  => ( array_key_exists( 'sidebar', $theme_options ) ) ? $theme_options['sidebar'] : 'd-none',
			'search_form'              => ( array_key_exists( 'search_form', $theme_options ) ) ? $theme_options['search_form'] : 'd-block',
			// Text and background colors.
			'body_background_color'    => ( array_key_exists( 'body_background_color', $theme_options ) ) ? $theme_options['body_background_color'] : 'bg-light',
			'body_text_color'          => ( array_key_exists( 'body_text_color', $theme_options ) ) ? $theme_options['body_text_color'] : 'body-black-text',
			'header_background_color'  => ( array_key_exists( 'header_background_color', $theme_options ) ) ? $theme_options['header_background_color'] : 'bg-light',
			'navbar_background_color'  => ( array_key_exists( 'navbar_background_color', $theme_options ) ) ? $theme_options['navbar_background_color'] : 'bg-primary',
			'navbar_text_color'        => ( array_key_exists( 'navbar_text_color', $theme_options ) ) ? $theme_options['navbar_text_color'] : 'navbar-dark',
			'content_background_color' => ( array_key_exists( 'content_background_color', $theme_options ) ) ? $theme_options['content_background_color'] : 'bg-white',
			'sidebar_background_color' => ( array_key_exists( 'sidebar_background_color', $theme_options ) ) ? $theme_options['sidebar_background_color'] : 'bg-light',
			'footer_background_color'  => ( array_key_exists( 'footer_background_color', $theme_options ) ) ? $theme_options['footer_background_color'] : 'bg-light',
		),
	)
);

/**
 * This is the global used inside the all the files (for scoping need to the save if needed within any function).
 */
$theme_options = (array) json_decode( DEVELOPRY_LITE_THEME_OPTIONS );

/**
 * Theme features files are included bellow.
 */
require_once get_template_directory() . '/inc/plugins/tgm-plugin-activation.php';
require_once get_template_directory() . '/inc/menus.php';
require_once get_template_directory() . '/inc/scripts.php';
require_once get_template_directory() . '/inc/sidebars.php';
require_once get_template_directory() . '/inc/styles.php';
require_once get_template_directory() . '/inc/theme-functions.php';
require_once get_template_directory() . '/inc/theme-options.php';
require_once get_template_directory() . '/inc/theme-plugins.php';
require_once get_template_directory() . '/inc/theme-starter.php';
require_once get_template_directory() . '/inc/theme-support.php';
