<?php
/**
 * Template (part) displaying posts/pages comments with form.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

if ( post_password_required() ) {
	return;
}

?>
<?php if ( have_comments() ) : ?>
	<header class="comment-header">
		<?php if ( '0' === get_comments_number() ) : ?>
			<h2 class="comment-title">
				<?php echo esc_html__( 'No thoughts yet. Be the first to leave a comment and start a discussion.', 'developry-lite' ); ?>
			</h2>
		<?php elseif ( '1' === get_comments_number() ) : ?>
			<h2 class="comment-title">
				<?php
					echo esc_html__( 'One thought on &ldquo;', 'developry-lite' );
					echo esc_html( get_the_title() ) . '&rdquo;';
				?>
			</h2>
		<?php else : ?>
			<h2 class="comment-title">
				<?php
					echo esc_html( get_comments_number() );
					echo esc_html__( ' thoughts on &ldquo;', 'developry-lite' );
					echo esc_html( get_the_title() ) . '&rdquo;';
				?>
			</h2>
		<?php endif; ?>
	</header>

	<main class="comment-main">
		<ol class="comment-list">
			<?php
				wp_list_comments(
					array(
						'style'      => 'ol',
						'short_ping' => true,
						'reply_text' => esc_html__( 'REPLY...', 'developry-lite' ),
					)
				);
			?>
		</ol>

		<?php
			the_comments_pagination(
				array(
					'prev_text' => '<i class="dashicons dashicons-arrow-left-alt2"></i> &nbsp; ' . esc_html__( 'Previous Comments', 'developry-lite' ),
					'next_text' => esc_html__( 'Next Comments', 'developry-lite' ) . ' &nbsp; <i class="dashicons dashicons-arrow-right-alt2"></i>',
				)
			);
		?>
	</main>

	<?php if ( ! comments_open() ) : ?>
		<section class="comment-more">
			<p class="lead">
				<?php echo esc_html__( 'Comments are closed.', 'developry-lite' ); ?>
			</p>
		</section>
	<?php endif; ?>
<?php endif; ?>

<?php comment_form(); ?>
