/**
 * Add bootstrap classes with jQuery for quick customization.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */

'use strict';

jQuery.noConflict();

( function( $ ) {
	 // Scroll top toggler.
	 $( window ).scroll( function() {
    var top = $( window ).scrollTop();
    $( '.scrolltop' ).toggle( top > 360 );
  });

  // Initial animation
  $( 'body' ).animate( { opacity: 1 }, 100 );

  // Sub sub nav menu.
  $( document ).on( 'click focus', '.navbar-nav .menu-item-has-children > a ', function( event ) {
    event.preventDefault();
		event.stopPropagation();

    var $submenu = $( this ).next( '.sub-menu' );

		$( this ).closest( '.menu-item-has-children' ).siblings().find( '.sub-menu' ).hide();

		$submenu.show();

    return false;
  } );

	$( document ).on('focus', '.menu-item', function( event ) {
    $( this ).siblings().find( '.sub-menu' ).hide();
  } );

  // Scrolling.
  $( document ).on( 'click', 'a[href="#scrolltop"]', function( event ) {
    $( 'html, body' ).animate( { scrollTop: 0 }, 600);
    return false;
  } );

  $( document ).on( 'click', 'a[href="#scrolldown"]', function( event ) {
    $( 'html, body' ).animate( { scrollTop: $( '#body' ).offset().top }, 600 );
    return false;
  } );

	// Navbar.
	$( '.navbar-collapse div:first-child' ).addClass( 'navbar-nav mr-auto' );
	$( '.main-nav-menu, .main-nav-menu > ul' ).addClass( 'navbar-nav' );
	$( '.main-nav-menu ul > li, .main-nav-menu > li' ).addClass( 'nav-item' );
	$( '.main-nav-menu ul > li a, .main-nav-menu > li a' ).addClass( 'nav-link' );
	$( '.menu-item-has-children, .page_item_has_children' ).addClass( 'dropdown' );
	$( '.menu-item-has-children > a, .page_item_has_children > a' ).attr( 'aria-labelledby', $( '.menu-item-has-children' ).attr( 'id' ) );
	$( '.menu-item-has-children > a, .page_item_has_children > a' ).addClass( 'dropdown-toggle' );
	$( '.menu-item-has-children > a, .page_item_has_children > a' ).attr( 'href', '' );
	$( '.menu-item-has-children > a, .page_item_has_children > a' ).attr( 'data-toggle', 'dropdown' );
	$( '.sub-menu, .children' ).addClass( 'collapse dropdown-menu rounded-0 p' );
	$( '.sub-menu li, .children li' ).addClass( 'm-2' );
	$( '.sub-menu a, .children a' ).addClass( 'dropdown-item' );

	// Forms.
	$( 'select' ).addClass( 'custom-select' );
	$( 'input[type=text], input[type=search], input[type=email], input[type=url], textarea' ).addClass( 'form-control' );
	$( 'button, input[type=submit]' ).addClass( 'btn btn-dark' );

	// Gloabl.
	$( 'table' ).addClass( 'table table-striped table-light' );
	$( 'dl' ).addClass( 'row' );
	$( 'dt' ).addClass( '.col-12 col-sm-3' );
	$( 'dd' ).addClass( '.col-12 col-sm-9' );

	// Other, miscellaneous, etc.
	$( '.nav-links' ).addClass( 'pagination mb-3' );
	$( '.nav-links .page-numbers' ).addClass( 'd-flex page-item page-link text-center w-100 align-items-center justify-content-center' );
} )( jQuery );
