/**
 * WP Customizer live preview area action.
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */

( function( $, api ) {
	// Bootswatch themes.
	api( 'developry_lite_theme_options[bootswatch_theme]', function( setting ) {
		setting.bind( function( optionValue ) {
			$( '#developry-lite-bootswatch-css' ).attr(
				'href',
				`${devrylite.theme_directory}/assets/dist/css/themes/${optionValue}.min.css`
			);
		} );
	} );

	// Header positon.
	api( 'developry_lite_theme_options[header_position]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem      = $( '#header' );
			$body      = $( '#body' );
			$pageCover = $( '#cover' );

			// Toggle header position options.
			if ( 'position-static' === optionValue ) {
				$elem.removeClass( 'position-fixed' );

				if ( ! $pageCover.length ) {
					$body.removeClass( 'pt-10' );
				}
			} else {
				$elem.addClass( 'position-fixed' );

				if ( ! $pageCover.length ) {
					$body.addClass( 'pt-10' );
				}
			}
		} );
	} );

	// Container width.
	api( 'developry_lite_theme_options[container_width]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( '#body > div, #navbar > div, #footer > div' );

			// Toggle containers width options.
			if ( '' === optionValue ) {
				$elem.attr( 'class', '' )
					.addClass( 'container' );
			} else {
				$elem.attr( 'class', '' )
					.addClass( 'container' + optionValue );
			}
		} );
	} );

	// Sidebar.
	api( 'developry_lite_theme_options[sidebar]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( '#sidebar' );

			// Toggle sidebar options and re-order.
			if ( 'd-none' === optionValue ) {
				$elem.addClass( 'd-none' );
				$elem.hide()
					.prev()
					.removeClass( 'col-lg-8' )
					.addClass( 'col-12' );
			} else {
				$elem.removeClass( 'd-none' );				
				$elem.prev().addClass( 'col-12 col-lg-8' );

				if ( 'order-first' === optionValue ) {
					$elem.removeClass( 'order-last' )
						.addClass( 'order-first' );
				} else {
					$elem.removeClass( 'order-first' )
						.addClass( 'order-last' );
				}
			}
		} );
	} );

	// Page cover.
	api( 'developry_lite_theme_options[page_cover]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( '#cover' );

			// Toggle page cover options.
			if ( 'd-none' === optionValue ) {
				$elem.hide();
			} else {
				$elem.show();
			}
		} );
	} );

	// Page title.
	api( 'developry_lite_theme_options[page_title]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( '#content-header' );

			// Toggle page title options.
			if ( 'd-none' === optionValue ) {
				$elem.addClass( 'd-none' );
			} else {
				$elem.removeClass( 'd-none' );
			}
		} );
	} );

	// Search form.
	api( 'developry_lite_theme_options[search_form]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem   = $( '#navbar .search-form' );
			$navbar = $elem.closest( '#navbar-collapse' );

			// Toggle navbar search from.
			if ( 'd-none' === optionValue ) {
				$elem.addClass( 'd-none' );
				$navbar.addClass( 'justify-content-end' )
					.removeClass( 'justify-content-space-between' );
			} else {
				$elem.removeClass( 'd-none' );
				$navbar.removeClass( 'justify-content-end' )
					.addClass( 'justify-content-space-between' );
			}
		} );
	} );

	// Body background color.
	api( 'developry_lite_theme_options[body_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( 'body' ), optionValue );
		} );
	} );

	// Body text color.
	api( 'developry_lite_theme_options[body_text_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( 'body' );

			// Toggle black and white text for the ALL body elements.
			if ( 'body-white-text' === optionValue ) {
				$elem.addClass( 'body-white-text' );
			} else {
				$elem.removeClass( 'body-white-text' );
			}
		} );
	} );

	// Header background color.
	api( 'developry_lite_theme_options[header_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( '#header' ), optionValue );
		} );
	} );

	// Navbar background color.
	api( 'developry_lite_theme_options[navbar_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( '#navbar' ), optionValue );
		} );
	} );

	// Navbar text color.
	api( 'developry_lite_theme_options[navbar_text_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			$elem = $( '#navbar' );

			// Toggle light or dark text for the navbar.
			if ( 'navbar-dark-text' === optionValue ) {
				$elem.addClass( 'navbar-dark-text' );
			} else {
				$elem.removeClass( 'navbar-dark-text' );
			}
		} );
	} );

	// Content background color.
	api( 'developry_lite_theme_options[content_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( '#body' ), optionValue );
		} );
	} );

	// Sidebar background color.
	api( 'developry_lite_theme_options[sidebar_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( '#sidebar' ), optionValue );
		} );
	} );

	// Footer background color.
	api( 'developry_lite_theme_options[footer_background_color]', function( setting ) {
		setting.bind( function( optionValue ) {
			apply_background_color( $( '#footer' ), optionValue );
		} );
	} );

	/**
	 * Helper functions.
	 */
	var apply_background_color =function ( $elem, optionValue ) {
		if ( ! $elem.length || ! optionValue ) {
			return;
		}

		// Remove all `bg-` classes in the element.
		$.each(  $elem.attr( 'class' ).split( ' ' ), function( _, className ) {
			if ( className.indexOf('bg-') === 0 ) {
				$elem.removeClass( className );
			}
		} );

		// Apply newly selected option.
		switch ( optionValue ) {
			case 'bg-primary':
				$elem.addClass( 'bg-primary' );
				break;
			case 'bg-secondary':
				$elem.addClass( 'bg-secondary' );
				break;
			case 'bg-dark':
				$elem.addClass( 'bg-dark' );
				break;
			case 'bg-light':
				$elem.addClass( 'bg-light' );
				break;
			case 'bg-black':
				$elem.addClass( 'bg-black' );
				break;
			case 'bg-white':
				$elem.addClass( 'bg-white' );
				break;
			default:
				$elem.addClass( 'bg-transparent' );
				break;
		}
	};
}) ( jQuery, wp.customize );
