<?php
/**
 * [Short Description]
 *
 * @package DEVRY
 * @subpackage DEVELOPRY_LITE
 * @since 1.0
 */
namespace DEVRY\DEVELOPRY_LITE;

! defined( ABSPATH ) || exit; // Exit if accessed directly.

$body_classes = ( 'd-none' === $theme_options['page_cover'] ) ? 'mt-5' : '';
$body_classes = ( 'd-none' === $theme_options['page_cover'] && 'position-fixed' === $theme_options['header_position'] ) ? 'mt-5 pt-5' : '';

get_header();

?>
	<header id="content-header" class="content-header">
		<?php if ( is_author() ) : ?>
			<aside class="content-aside">
				<img
					src="<?php echo esc_url( get_avatar_url( get_the_author_meta( 'ID' ) ) ); ?>"
					alt="<?php echo esc_html( get_the_author_meta( 'display_name' ) ); ?>" class="img-fluid" 
				/>
				<div class="content-author">
					<h1 id="content-title" class="content-title">
						<?php echo esc_html__( 'Author', 'developry-lite' ) . ' : ' . esc_html( get_the_author_meta( 'display_name' ) ); ?>
					</h1>
					<p class="lead">
							<?php echo esc_html( get_the_author_meta( 'description' ) ); ?>
					</p>
				</div>
			</aside>
		<?php elseif ( is_category() || is_tag() || is_day() || is_month() || is_year() ) : ?>
			<?php
			display_archive_title_and_description();

			if ( is_day() ) :
				echo '<p class="lead">' . esc_html__( 'Below are all the posts archived for the day.', 'developry-lite' ) . '</p>';
			elseif ( is_month() ) :
				echo '<p class="lead">' . esc_html__( 'Below are all the posts archived for the month.', 'developry-lite' ) . '</p>';
			elseif ( is_year() ) :
				echo '<p class="lead">' . esc_html__( 'Below are all the posts archived for the year.', 'developry-lite' ) . '</p>';
			endif;
			?>
		<?php endif; ?>
	</header>

	<main id="content-main" class="content-main">
		<?php
			get_template_part( 'template-parts/content/content' );
			get_template_part( 'template-parts/content/pagination' );
		?>
	</main>
<?php

get_footer();
