<?php
/**
 * Template Name: Custom Home
 */

get_header(); ?>

<main id="skip-content" role="main">

	<?php do_action( 'designer_boutique_above_slider' ); ?>

	<?php if( get_theme_mod('designer_boutique_slider_hide_show') != ''){ ?>
		<section id="slider">
			<div class="main-slider-inn">
			<div id="carouselExampleIndicators" class="carousel slide" data-ride="carousel">
			    <?php $designer_boutique_slider_pages = array();
			    for ( $count = 1; $count <= 4; $count++ ) {
			        $mod = intval( get_theme_mod( 'designer_boutique_slider'. $count ));
			        if ( 'page-none-selected' != $mod ) {
			          $designer_boutique_slider_pages[] = $mod;
			        }
			    }
		      	if( !empty($designer_boutique_slider_pages) ) :
			        $args = array(
			          	'post_type' => 'page',
			          	'post__in' => $designer_boutique_slider_pages,
			          	'orderby' => 'post__in'
			        );
		        	$query = new WP_Query( $args );
		        if ( $query->have_posts() ) :
		          	$i = 1;
		    	?>     
				    <div class="carousel-inner" role="listbox">
				      	<?php  while ( $query->have_posts() ) : $query->the_post(); ?>
					        <div <?php if($i == 1){echo 'class="carousel-item fade-in-image active"';} else{ echo 'class="carousel-item fade-in-image"';}?>>
					        	<div class="row"> 
					        		<div class="col-lg-7 col-md-6">
						        		<div class="inner-carousel">
										<?php
											$designer_boutique_slider_effect = get_theme_mod('designer_boutique_slider_effect', '') 
										?>						        			
						        			<div class="slider_content <?php echo ($designer_boutique_slider_effect); ?>">
							            	<!-- <div class="contenbx"></div> -->
								              	<a href="<?php the_permalink(); ?>"><h2><?php the_title(); ?></h2></a>
												  <p><?php $designer_boutique_excerpt = get_the_excerpt(); echo esc_html( designer_boutique_string_limit_words( $designer_boutique_excerpt, esc_attr(get_theme_mod('designer_boutique_slider_excerpt_length','15') ) )); ?></p>
								              	<a href="<?php the_permalink(); ?>" class="read-btn"><span><?php esc_html_e('Contact Us','designer-boutique'); ?></span></a>
						            		</div>
						            	</div>
					            	</div>
					        		<div class="col-lg-5 col-md-6 slider-rightb ">	
					        			<div class="slider-image">	
					            			<img class="slide-mainimg" src="<?php esc_url(the_post_thumbnail_url('full')); ?>" alt="<?php the_title_attribute(); ?> "/>
										   	<div class="callus">
										   		<div class="slider-callhead"><?php echo esc_html(get_theme_mod('designer_boutique_slidercallustext')); ?></div>
			                                    <div class="slider-callno">
			                                        <a href="tel:<?php echo esc_html(get_theme_mod('designer_boutique_slidercallusnumber')); ?>"><?php echo esc_html(get_theme_mod('designer_boutique_slidercallusnumber')); ?></a>
			                                    </div>
											</div>
											<div class="slider-ovly"></div>
											
										</div>
					        		</div> 
					        		
					        	 </div> 
					        </div>
				      	<?php $i++; endwhile; 
				      	wp_reset_postdata();?>
				    </div>
			    <?php else : ?>
			    	<div class="no-postfound"></div>
	      		<?php endif;
			    endif;?>
			    <div class="slider-arrow">
					<a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
						<span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-angle-left"></i></span>
						<!-- <span class="screen-reader-text"></?php esc_html_e( 'Prev','designer-boutique' );?></span> -->
					</a>
					<a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
						<span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-angle-right"></i></span>
						<!-- <span class="screen-reader-text"></?php esc_html_e( 'Next','designer-boutique' );?></span> -->
					</a>
				</div>
			</div>
			
		  	<div class="clearfix"></div>
		  	</div>
		</section>
	<?php }?>

	<?php do_action('designer_boutique_below_slider'); ?>

	<?php if(get_theme_mod('designer_boutique_section_titleservice') != '' || get_theme_mod('designer_boutique_category_settingfeature') != ''){?>

	<section id="feature-section">
		<div class="container"> 
			<div class="feature-head ">
				
				<?php if(get_theme_mod('designer_boutique_section_titleservice') != ''){?>
					<h3><span><?php echo esc_html(get_theme_mod('designer_boutique_section_titleservice')); ?></span></h3>
				<?php }?>
			</div>

			<div class="row">
				<?php $designer_boutique_catData1 = get_theme_mod('designer_boutique_category_settingfeature');
				if($designer_boutique_catData1){ 
					$args = array(
						'post_type' => 'post',
						'category_name' => $designer_boutique_catData1,
						'posts_per_page' => get_theme_mod('designer_boutique_features_number',4)
					);
					$i=1; ?>
					<?php $query = new WP_Query( $args );
					if ( $query->have_posts() ) :
						while( $query->have_posts() ) : $query->the_post(); ?>
							<div class="col-lg-3 col-md-4 col-sm-6 featuresbx">
								<div class="feature-box mb-4">
									<div class="feature-icon">
										<i class="<?php echo esc_attr(get_theme_mod('designer_boutique_feature_icon' . $i, 'fas fa-chart-line')); ?>"></i>
									</div>
									<div class="feature-img">
										<?php the_post_thumbnail(); ?>
										<div class="feature-content">
											<a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>
											<p><?php $designer_boutique_excerpt = get_the_excerpt(); echo esc_html( designer_boutique_string_limit_words( $designer_boutique_excerpt,15 ) ); ?></p>
											<!-- <div class="feature-btn ">
												<a href="</?php the_permalink(); ?>" class="read-btn"><span><?php esc_html_e('Read More','designer-boutique'); ?></span><div class="icn"><i class="fa fa-angle-double-right"></i></div></a>
											</div> -->
											
										</div>
									</div>
									
								</div>
							</div>
						<?php $i++; endwhile; 
						wp_reset_postdata(); ?>
					<?php else : ?>
						<div class="no-postfound"></div>
					<?php endif; ?>
				<?php }?>
			</div>
		</div>
	</section>

	<?php }?>

	<?php do_action('designer_boutique_below_feature_section'); ?>
	

	<?php if(get_theme_mod('designer_boutique_section_title') != '' || get_theme_mod('designer_boutique_category_setting') != ''){?>

		<section id="service-section">
			<div class="container"> 
	        	<div class="service-head ">
					
					<?php if(get_theme_mod('designer_boutique_section_title') != ''){?>
			      		<h3><span><?php echo esc_html(get_theme_mod('designer_boutique_section_title')); ?></span></h3>
			      	<?php }?>
		       	</div>
		       	<div class="row">
			       	<?php $designer_boutique_catData1 = get_theme_mod('designer_boutique_category_setting');
					if($designer_boutique_catData1){ 
						$args = array(
							'post_type' => 'post',
							'category_name' => $designer_boutique_catData1,
				        );
				        $i=1; ?>
			    		<?php $query = new WP_Query( $args );
			          	if ( $query->have_posts() ) :
			        		while( $query->have_posts() ) : $query->the_post(); ?>
			        			<div class="col-lg-4 col-md-4">
				      				<div class="service-box mb-4">
				      					<div class="service-img">
				      						<?php the_post_thumbnail(); ?>
				      						<div class="s-icon">
				      							<i class="fa fa fa-user"></i>
				      						</div>
				      					</div>
			  							<div class="service-content">
				            				<a href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4></a>
							              	<p><?php $designer_boutique_excerpt = get_the_excerpt(); echo esc_html( designer_boutique_string_limit_words( $designer_boutique_excerpt,15 ) ); ?></p>
							              	<div class="service-btn ">
							              		<a href="<?php the_permalink(); ?>" class="read-btn"><!--<span></?php esc_html_e('Contact Us','designer-boutique'); ?></span>--> 
							              			<i class="fa fa-arrow-right"></i>
							              			<div class="clearfix"></div>
							              		</a>
							              	</div>
							              	<div class="clearfix"></div>
			            				</div>
				      				</div>
				      			</div>
			          		<?php $i++; endwhile; 
			          		wp_reset_postdata(); ?>
			          	<?php else : ?>
			              	<div class="no-postfound"></div>
			            <?php endif; ?>
			  		<?php }?>
			  	</div>
			</div>
		</section>

	<?php }?>

	<?php do_action('designer_boutique_below_service_section'); ?>

	<!-- <div class="container">
	  	<//?php while ( have_posts() ) : the_post(); ?>
	  		<div class="lz-content py-5">
	        	<//?php the_content(); ?>
	        </div>
	    <//?php endwhile; // end of the loop. ?>
	</div> -->
</main>

<?php get_footer(); ?>