<?php 

	$designer_boutique_custom_style = '';

	// Logo Size
	$designer_boutique_logo_top_padding = get_theme_mod('designer_boutique_logo_top_padding');
	$designer_boutique_logo_bottom_padding = get_theme_mod('designer_boutique_logo_bottom_padding');
	$designer_boutique_logo_left_padding = get_theme_mod('designer_boutique_logo_left_padding');
	$designer_boutique_logo_right_padding = get_theme_mod('designer_boutique_logo_right_padding');

	if( $designer_boutique_logo_top_padding != '' || $designer_boutique_logo_bottom_padding != '' || $designer_boutique_logo_left_padding != '' || $designer_boutique_logo_right_padding != ''){
		$designer_boutique_custom_style .=' .logo {';
			$designer_boutique_custom_style .=' padding-top: '.esc_attr($designer_boutique_logo_top_padding).'px; padding-bottom: '.esc_attr($designer_boutique_logo_bottom_padding).'px; padding-left: '.esc_attr($designer_boutique_logo_left_padding).'px; padding-right: '.esc_attr($designer_boutique_logo_right_padding).'px;';
		$designer_boutique_custom_style .=' }';
	}

	$designer_boutique_logo_size = get_theme_mod('designer_boutique_logo_size');
	if( $designer_boutique_logo_size != '' ) {
		if($designer_boutique_logo_size >= 0 && $designer_boutique_logo_size <= 100) {
			$calculated_width = $designer_boutique_logo_size * 3.5;
			$designer_boutique_custom_style .= ' .custom-logo-link img {';
			$designer_boutique_custom_style .= ' width: ' . esc_attr($calculated_width) . 'px;';
			$designer_boutique_custom_style .= ' }';
		}
	}

//Site title tagline color
$designer_boutique_site_title_color = get_theme_mod('designer_boutique_site_title_color');
if ( $designer_boutique_site_title_color != '') {
	$designer_boutique_custom_style .=' h1.site-title a, p.site-title a {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_site_title_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_site_tagline_color = get_theme_mod('designer_boutique_site_tagline_color');
if ( $designer_boutique_site_tagline_color != '') {
	$designer_boutique_custom_style .=' p.site-description {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_site_tagline_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_menu_color = get_theme_mod('designer_boutique_menu_color');
if ( $designer_boutique_menu_color != '') {
	$designer_boutique_custom_style .=' .nav-menu ul li a {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_menu_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_hdrbtn_color = get_theme_mod('designer_boutique_hdrbtn_color');
$designer_boutique_hdrbtnbg_color = get_theme_mod('designer_boutique_hdrbtnbg_color');
if ( $designer_boutique_hdrbtn_color != '') {
	$designer_boutique_custom_style .=' #header .contact-btn a {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_hdrbtn_color).'; background-color:'.esc_attr($designer_boutique_hdrbtnbg_color).';';
	$designer_boutique_custom_style .=' }';
}

//layout width
$designer_boutique_boxfull_width = get_theme_mod('designer_boutique_boxfull_width');
if ($designer_boutique_boxfull_width !== '') {
	switch ($designer_boutique_boxfull_width) {
		case 'container':
			$designer_boutique_custom_style .= ' body, #header, .bottom-header {
				max-width: 1140px;
				width: 100%;
				padding-right: 15px;
				padding-left: 15px;
				margin-right: auto;
				margin-left: auto;
				}';
			break;
		case 'container-fluid':
			$designer_boutique_custom_style .= ' body, #header, .bottom-header { 
				width: 100%;
				padding-right: 15px;
				padding-left: 15px;
				margin-right: auto;
				margin-left: auto;
				}';
			break;
		case 'none':
			// No specific width specified, so no additional style needed.
			break;
		default:
			// Handle unexpected values.
			break;
	}
}

//Menu animation
$designer_boutique_dropdown_anim = get_theme_mod('designer_boutique_dropdown_anim');

if ( $designer_boutique_dropdown_anim != '') {
	$designer_boutique_custom_style .=' .nav-menu ul ul {';
		$designer_boutique_custom_style .=' animation:'.esc_attr($designer_boutique_dropdown_anim).' 1s ease;';
	$designer_boutique_custom_style .=' }';
}

//slider color
$designer_boutique_slider_font_size = get_theme_mod('designer_boutique_slider_font_size');
if ( $designer_boutique_slider_font_size != '') {
	$designer_boutique_custom_style .=' #slider h2 {';
		$designer_boutique_custom_style .=' font-size:'.esc_attr($designer_boutique_slider_font_size).'px;';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_text_font_size = get_theme_mod('designer_boutique_slider_text_font_size');
if ( $designer_boutique_slider_text_font_size != '') {
	$designer_boutique_custom_style .=' #slider p {';
		$designer_boutique_custom_style .=' font-size:'.esc_attr($designer_boutique_slider_text_font_size).'px;';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_title_color = get_theme_mod('designer_boutique_slider_title_color');
if ( $designer_boutique_slider_title_color != '') {
	$designer_boutique_custom_style .=' #slider h2 {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_slider_title_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_text_color = get_theme_mod('designer_boutique_slider_text_color');
if ( $designer_boutique_slider_text_color != '') {
	$designer_boutique_custom_style .=' #slider p {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_slider_text_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_btn_color = get_theme_mod('designer_boutique_slider_btn_color');
$designer_boutique_slider_btnbg_color = get_theme_mod('designer_boutique_slider_btnbg_color');
if ( $designer_boutique_slider_btn_color != '') {
	$designer_boutique_custom_style .=' #slider a.read-btn {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_slider_btn_color).'; background-color:'.esc_attr($designer_boutique_slider_btnbg_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_calltext_color = get_theme_mod('designer_boutique_slider_calltext_color');
if ( $designer_boutique_slider_calltext_color != '') {
	$designer_boutique_custom_style .=' #slider .slider-callhead {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_slider_calltext_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_callno_color = get_theme_mod('designer_boutique_slider_callno_color');
if ( $designer_boutique_slider_callno_color != '') {
	$designer_boutique_custom_style .=' #slider .slider-callno a {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_slider_callno_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_slider_callbg_color = get_theme_mod('designer_boutique_slider_callbg_color');
if ( $designer_boutique_slider_callbg_color != '') {
	$designer_boutique_custom_style .=' #slider .callus {';
		$designer_boutique_custom_style .=' background-color:'.esc_attr($designer_boutique_slider_callbg_color).';';
	$designer_boutique_custom_style .=' }';
}

//Feature Section css
$designer_boutique_section_titleservice_font_size = get_theme_mod('designer_boutique_section_titleservice_font_size');
if ( $designer_boutique_section_titleservice_font_size != '') {
	$designer_boutique_custom_style .=' #feature-section .feature-head h3 {';
		$designer_boutique_custom_style .=' font-size:'.esc_attr($designer_boutique_section_titleservice_font_size).'px;';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_section_titleservice_color = get_theme_mod('designer_boutique_section_titleservice_color');
if ( $designer_boutique_section_titleservice_color != '') {
	$designer_boutique_custom_style .=' #feature-section .feature-head h3, #feature-section .feature-head h3 span:after, #feature-section .feature-head h3 span {';
		$designer_boutique_custom_style .=' color:'.esc_attr($designer_boutique_section_titleservice_color).'; border-top-color:'.esc_attr($designer_boutique_section_titleservice_color).'; border-bottom-color:'.esc_attr($designer_boutique_section_titleservice_color).';';
	$designer_boutique_custom_style .=' }';
}

$designer_boutique_section_titleservicebg_color = get_theme_mod('designer_boutique_section_titleservicebg_color');
if ( $designer_boutique_section_titleservicebg_color != '') {
	$designer_boutique_custom_style .=' #feature-section .feature-head h3 span {';
		$designer_boutique_custom_style .=' background-color:'.esc_attr($designer_boutique_section_titleservicebg_color).';';
	$designer_boutique_custom_style .=' }';
}