<?php
/**
 * Designer Boutique: Customizer
 *
 * @subpackage Designer Boutique
 * @since 1.0
 */

use WPTRT\Customize\Section\Designer_Boutique_Button;

add_action( 'customize_register', function( $manager ) {

	$manager->register_section_type( Designer_Boutique_Button::class );

	$manager->add_section(
		new Designer_Boutique_Button( $manager, 'designer_boutique_pro', [
			'title' => __( 'Insurance Agency Pro', 'designer-boutique' ),
			'priority' => 0,
			'button_text' => __( 'Go Pro', 'designer-boutique' ),
			'button_url'  => esc_url( 'https://www.luzuk.com/products/fashion-designer-wordpress-theme', 'designer-boutique')
		] )
	);

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

	$version = wp_get_theme()->get( 'Version' );

	wp_enqueue_script(
		'designer-boutique-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
		[ 'customize-controls' ],
		$version,
		true
	);

	wp_enqueue_style(
		'designer-boutique-customize-section-button',
		get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
		[ 'customize-controls' ],
 		$version
	);

} );

function designer_boutique_customize_register( $wp_customize ) {

	$wp_customize->add_setting('designer_boutique_logo_size',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_logo_size',array(
		'type' => 'range',
		'description' => __('Logo Size (0-100%)','designer-boutique'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('designer_boutique_logo_padding',array(
		'sanitize_callback'	=> 'esc_html'
	));
	$wp_customize->add_control('designer_boutique_logo_padding',array(
		'label' => __('Logo Margin','designer-boutique'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting('designer_boutique_logo_top_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_logo_top_padding',array(
		'type' => 'number',
		'description' => __('Top','designer-boutique'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('designer_boutique_logo_bottom_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_logo_bottom_padding',array(
		'type' => 'number',
		'description' => __('Bottom','designer-boutique'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('designer_boutique_logo_left_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_logo_left_padding',array(
		'type' => 'number',
		'description' => __('Left','designer-boutique'),
		'section' => 'title_tagline',
	));

	$wp_customize->add_setting('designer_boutique_logo_right_padding',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
 	));
 	$wp_customize->add_control('designer_boutique_logo_right_padding',array(
		'type' => 'number',
		'description' => __('Right','designer-boutique'),
		'section' => 'title_tagline',
    ));

	$wp_customize->add_setting('designer_boutique_show_site_title',array(
		'default' => true,
		'sanitize_callback'	=> 'designer_boutique_sanitize_checkbox'
	));
	$wp_customize->add_control('designer_boutique_show_site_title',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Title','designer-boutique'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'designer_boutique_site_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_site_title_color', array(
		'label' => 'Title Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_setting('designer_boutique_show_tagline',array(
		'default' => true,
		'sanitize_callback'	=> 'designer_boutique_sanitize_checkbox'
	));
	$wp_customize->add_control('designer_boutique_show_tagline',array(
		'type' => 'checkbox',
		'label' => __('Show / Hide Site Tagline','designer-boutique'),
		'section' => 'title_tagline'
	));

	$wp_customize->add_setting( 'designer_boutique_site_tagline_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_site_tagline_color', array(
		'label' => 'Tagline Color',
		'section' => 'title_tagline',
	)));

	$wp_customize->add_panel( 'designer_boutique_panel_id', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __( 'Theme Settings', 'designer-boutique' ),
		'description' => __( 'Description of what this panel does.', 'designer-boutique' ),
	) );

	$wp_customize->add_section( 'designer_boutique_theme_options_section', array(
    	'title'      => __( 'General Settings', 'designer-boutique' ),
		'priority'   => 30,
		'panel' => 'designer_boutique_panel_id'
	) );

	$wp_customize->add_setting('designer_boutique_theme_options',array(
		'default' => 'One Column',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control('designer_boutique_theme_options',array(
		'type' => 'select',
		'label' => __('Blog Page Sidebar Layout','designer-boutique'),
		'section' => 'designer_boutique_theme_options_section',
		'choices' => array(
		   'Left Sidebar' => __('Left Sidebar','designer-boutique'),
		   'Right Sidebar' => __('Right Sidebar','designer-boutique'),
		   'One Column' => __('One Column','designer-boutique'),
		   'Grid Layout' => __('Grid Layout','designer-boutique')
		),
	));

	$wp_customize->add_setting('designer_boutique_single_post_sidebar',array(
		'default' => 'Right Sidebar',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control('designer_boutique_single_post_sidebar',array(
        'type' => 'select',
        'label' => __('Single Post Sidebar Layout','designer-boutique'),
        'section' => 'designer_boutique_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','designer-boutique'),
            'Right Sidebar' => __('Right Sidebar','designer-boutique'),
            'One Column' => __('One Column','designer-boutique')
        ),
	));

	$wp_customize->add_setting('designer_boutique_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control('designer_boutique_page_sidebar',array(
        'type' => 'select',
        'label' => __('Page Sidebar Layout','designer-boutique'),
        'section' => 'designer_boutique_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','designer-boutique'),
            'Right Sidebar' => __('Right Sidebar','designer-boutique'),
            'One Column' => __('One Column','designer-boutique')
        ),
	));

	$wp_customize->add_setting('designer_boutique_archive_page_sidebar',array(
		'default' => 'One Column',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control('designer_boutique_archive_page_sidebar',array(
        'type' => 'select',
        'label' => __('Archive & Search Page Sidebar Layout','designer-boutique'),
        'section' => 'designer_boutique_theme_options_section',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','designer-boutique'),
            'Right Sidebar' => __('Right Sidebar','designer-boutique'),
            'One Column' => __('One Column','designer-boutique'),
            'Grid Layout' => __('Grid Layout','designer-boutique')
        ),
	));

	$wp_customize->add_setting( 'designer_boutique_boxfull_width', array(
		'default'           => '',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	
	$wp_customize->add_control( 'designer_boutique_boxfull_width', array(
		'label'    => __( 'Section Width', 'designer-boutique' ),
		'section'  => 'designer_boutique_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'container'  => __('Box Width', 'designer-boutique'),
			'container-fluid' => __('Full Width', 'designer-boutique'),
			'none' => __('None', 'designer-boutique')
		),
	));

	$wp_customize->add_setting( 'designer_boutique_dropdown_anim', array(
		'default'           => 'None',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control( 'designer_boutique_dropdown_anim', array(
		'label'    => __( 'Menu Dropdown Animations', 'designer-boutique' ),
		'section'  => 'designer_boutique_theme_options_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInUp'  => __('bounceInUp', 'designer-boutique'),
			'fadeInUp' => __('fadeInUp', 'designer-boutique'),
			'zoomIn'    => __('zoomIn', 'designer-boutique'),
			'None'    => __('None', 'designer-boutique')
		),
	));

	//home page header
	$wp_customize->add_section( 'designer_boutique_header_section' , array(
    	'title'    => __( 'Header Settings', 'designer-boutique' ),
		'priority' => null,
		'panel' => 'designer_boutique_panel_id'
	) );

    $wp_customize->add_setting('designer_boutique_contact_btn_text',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_contact_btn_text',array(
		'label'	=> __('Button Text','designer-boutique'),
		'section' => 'designer_boutique_header_section',
		'type' => 'text'
	));

    $wp_customize->add_setting('designer_boutique_contact_btn_url',array(
		'default' => '',
		'sanitize_callback'	=> 'esc_url_raw'
	));	
	$wp_customize->add_control('designer_boutique_contact_btn_url',array(
		'label'	=> __('Button URL','designer-boutique'),
		'section' => 'designer_boutique_header_section',
		'type' => 'url'
	));
	
	$wp_customize->add_setting( 'designer_boutique_hdrbtn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_hdrbtn_color', array(
		'label' => 'Button Text Color',
		'section' => 'designer_boutique_header_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_hdrbtnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_hdrbtnbg_color', array(
		'label' => 'Button Bg Color',
		'section' => 'designer_boutique_header_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_menu_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_menu_color', array(
		'label' => 'Menu Color',
		'section' => 'designer_boutique_header_section',
	)));

	//home page slider
	$wp_customize->add_section( 'designer_boutique_slider_section' , array(
    	'title'    => __( 'Slider Settings', 'designer-boutique' ),
		'priority' => null,
		'panel' => 'designer_boutique_panel_id'
	) );

	$wp_customize->add_setting('designer_boutique_slider_hide_show',array(
    	'default' => false,
    	'sanitize_callback'	=> 'designer_boutique_sanitize_checkbox'
	));
	$wp_customize->add_control('designer_boutique_slider_hide_show',array(
	   	'type' => 'checkbox',
	   	'label' => __('Show / Hide Slider','designer-boutique'),
	   	'section' => 'designer_boutique_slider_section',
	));

	$wp_customize->add_setting( 'designer_boutique_slider_effect', array(
		'default'           => '',
		'sanitize_callback' => 'designer_boutique_sanitize_choices'
	));
	$wp_customize->add_control( 'designer_boutique_slider_effect', array(
		'label'    => __( 'Onload Transactions Effects', 'designer-boutique' ),
		'section'  => 'designer_boutique_slider_section',
		'type'     => 'select',
		'choices'  => array(
			'bounceInLeft'  => __('bounceInLeft', 'designer-boutique'),
			'bounceInRight' => __('bounceInRight', 'designer-boutique'),
			'bounceInUp'    => __('bounceInUp', 'designer-boutique'),
			'bounceInDown'    => __('bounceInDown', 'designer-boutique'),
			'zoomIn'  => __('zoomIn', 'designer-boutique'),
			'zoomOut' => __('zoomOut', 'designer-boutique'),
			'fadeInDown'    => __('fadeInDown', 'designer-boutique'),
			'fadeInUp'    => __('fadeInUp', 'designer-boutique'),
			'fadeInLeft'  => __('fadeInLeft', 'designer-boutique'),
			'fadeInRight' => __('fadeInRight', 'designer-boutique'),
			'flip-up'    => __('flip-up', 'designer-boutique'),
			'none'    => __('none', 'designer-boutique')
		),
	));

	for ( $count = 1; $count <= 4; $count++ ) {
		$wp_customize->add_setting( 'designer_boutique_slider' . $count, array(
			'default'           => '',
			'sanitize_callback' => 'designer_boutique_sanitize_dropdown_pages'
		));
		$wp_customize->add_control( 'designer_boutique_slider' . $count, array(
			'label' => __('Select Slider Image Page', 'designer-boutique' ),
			'description' => __('Image Size ( 600 x 650 )', 'designer-boutique' ),
			'section' => 'designer_boutique_slider_section',
			'type' => 'dropdown-pages'
		));
	}

	$wp_customize->add_setting('designer_boutique_slider_excerpt_length',array(
		'default' => '15',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_slider_excerpt_length',array(
		'type' => 'number',
		'label' => __('Slider Excerpt Length','designer-boutique'),
		'section' => 'designer_boutique_slider_section',
	));

	$wp_customize->add_setting('designer_boutique_slider_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_slider_font_size',array(
		'type' => 'number',
		'label' => __('Title Font Size','designer-boutique'),
		'section' => 'designer_boutique_slider_section',
	));

	$wp_customize->add_setting('designer_boutique_slider_text_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_slider_text_font_size',array(
		'type' => 'number',
		'label' => __('Text Font Size','designer-boutique'),
		'section' => 'designer_boutique_slider_section',
	));

	$wp_customize->add_setting( 'designer_boutique_slider_title_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_title_color', array(
		'label' => 'Title Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_slider_text_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_text_color', array(
		'label' => 'Text Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_slider_btn_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_btn_color', array(
		'label' => 'Button Text Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_slider_btnbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_btnbg_color', array(
		'label' => 'Button Bg Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting('designer_boutique_slidercallustext',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_slidercallustext',array(
		'label'	=> __('Call Us Text','designer-boutique'),
		'section' => 'designer_boutique_slider_section',
		'type' => 'text'
	));

	$wp_customize->add_setting('designer_boutique_slidercallusnumber',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_slidercallusnumber',array(
		'label'	=> __('Call Us Number','designer-boutique'),
		'section' => 'designer_boutique_slider_section',
		'type' => 'text'
	));

	$wp_customize->add_setting( 'designer_boutique_slider_calltext_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_calltext_color', array(
		'label' => 'Call Text Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_slider_callno_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_callno_color', array(
		'label' => 'Call Number Color',
		'section' => 'designer_boutique_slider_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_slider_callbg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_slider_callbg_color', array(
		'label' => 'Call Bg Color',
		'section' => 'designer_boutique_slider_section',
	)));

	//Feature Section
	$wp_customize->add_section('designer_boutique_feature_section',array(
		'title'	=> __('Feature Section','designer-boutique'),
		'description'=> __('<b>Note :</b> This section will appear below the Banner.','designer-boutique'),
		'panel' => 'designer_boutique_panel_id',
	));

 
    $wp_customize->add_setting('designer_boutique_section_titleservice',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_section_titleservice',array(
		'label'	=> __('Section Title','designer-boutique'),
		'section' => 'designer_boutique_feature_section',
		'type' => 'text'
	));

	$wp_customize->add_setting('designer_boutique_section_titleservice_font_size',array(
		'default' => '',
		'sanitize_callback'	=> 'designer_boutique_sanitize_float'
	));
	$wp_customize->add_control('designer_boutique_section_titleservice_font_size',array(
		'type' => 'number',
		'label' => __('Section Title Font Size','designer-boutique'),
		'section' => 'designer_boutique_feature_section',
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('designer_boutique_category_settingfeature',array(
		'default' => 'select',
		'sanitize_callback' => 'designer_boutique_sanitize_choices',
	));
	$wp_customize->add_control('designer_boutique_category_settingfeature',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','designer-boutique'),
		'section' => 'designer_boutique_feature_section',
	));


	$wp_customize->add_setting('designer_boutique_features_number',array(
		'default'	=> '4',
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('designer_boutique_features_number',array(
		'label'	=> __('Number Of Icons To Show In A Category','designer-boutique'),
		'section' => 'designer_boutique_feature_section',
		'type'	  => 'number'
	));

	$designer_boutique_features_number = get_theme_mod('designer_boutique_features_number', 4);
	for ($i=1; $i <= $designer_boutique_features_number; $i++) { 
	   	$wp_customize->add_setting('designer_boutique_feature_icon' . $i, array(
	      	'default' => 'fas fa-chart-line',
	      	'sanitize_callback' => 'sanitize_text_field'
	   	));
	   	$wp_customize->add_control(new designer_boutique_Fontawesome_Icon_Chooser($wp_customize, 'designer_boutique_feature_icon' . $i, array(
	      	'section' => 'designer_boutique_feature_section',
	      	'type' => 'icon',
	      	'label' => esc_html__('Feature Icon ', 'designer-boutique') . $i
	  	)));
	}

	$wp_customize->add_setting( 'designer_boutique_section_titleservice_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_section_titleservice_color', array(
		'label' => 'Section Title Color',
		'section' => 'designer_boutique_feature_section',
	)));

	$wp_customize->add_setting( 'designer_boutique_section_titleservicebg_color', array(
		'default' => '',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'designer_boutique_section_titleservicebg_color', array(
		'label' => 'Section Title Bg Color',
		'section' => 'designer_boutique_feature_section',
	)));

	//Service Section
	$wp_customize->add_section('designer_boutique_service_section',array(
		'title'	=> __('Service Section','designer-boutique'),
		'description'=> __('<b>Note :</b> This section will appear below the Banner.','designer-boutique'),
		'panel' => 'designer_boutique_panel_id',
	));

 
    $wp_customize->add_setting('designer_boutique_section_title',array(
		'default' => '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_section_title',array(
		'label'	=> __('Section Title','designer-boutique'),
		'section' => 'designer_boutique_service_section',
		'type' => 'text'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_pst[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_pst[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('designer_boutique_category_setting',array(
		'default' => 'select',
		'sanitize_callback' => 'designer_boutique_sanitize_choices',
	));
	$wp_customize->add_control('designer_boutique_category_setting',array(
		'type' => 'select',
		'choices' => $cat_pst,
		'label' => __('Select Category To Display Post','designer-boutique'),
		'section' => 'designer_boutique_service_section',
	));

	//Footer
    $wp_customize->add_section( 'designer_boutique_footer', array(
    	'title'  => __( 'Footer Text', 'designer-boutique' ),
		'priority' => null,
		'panel' => 'designer_boutique_panel_id'
	) );

	$wp_customize->add_setting('designer_boutique_show_back_totop',array(
       'default' => true,
       'sanitize_callback'	=> 'designer_boutique_sanitize_checkbox'
    ));
    $wp_customize->add_control('designer_boutique_show_back_totop',array(
       'type' => 'checkbox',
       'label' => __('Show / Hide Back to Top','designer-boutique'),
       'section' => 'designer_boutique_footer'
    ));

    $wp_customize->add_setting('designer_boutique_footer_copy',array(
		'default' => 'Designer Boutique WordPress Theme By Luzuk',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_footer_copy',array(
		'label'	=> __('Footer Text','designer-boutique'),
		'section' => 'designer_boutique_footer',
		'setting' => 'designer_boutique_footer_copy',
		'type' => 'text'
	));

	$wp_customize->add_setting('designer_boutique_footer_copylink',array(
		'default' => 'https://www.luzuk.com/products/designer-boutique-wordpress-theme',
		'sanitize_callback'	=> 'sanitize_text_field'
	));	
	$wp_customize->add_control('designer_boutique_footer_copylink',array(
		'label'	=> __('Footer Link','designer-boutique'),
		'section' => 'designer_boutique_footer',
		'setting' => 'designer_boutique_footer_copylink',
		'type' => 'text'
	));

	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport  = 'postMessage';

	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'designer_boutique_customize_partial_blogname',
	) );
	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'designer_boutique_customize_partial_blogdescription',
	) );
}
add_action( 'customize_register', 'designer_boutique_customize_register' );

function designer_boutique_customize_partial_blogname() {
	bloginfo( 'name' );
}

function designer_boutique_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if (class_exists('WP_Customize_Control')) {

   	class designer_boutique_Fontawesome_Icon_Chooser extends WP_Customize_Control {

      	public $type = 'icon';

      	public function render_content() { ?>
	     	<label>
	            <span class="customize-control-title">
	               <?php echo esc_html($this->label); ?>
	            </span>

	            <?php if ($this->description) { ?>
	                <span class="description customize-control-description">
	                   <?php echo wp_kses_post($this->description); ?>
	                </span>
	            <?php } ?>

	            <div class="designer-boutique-selected-icon">
	                <i class="fa <?php echo esc_attr($this->value()); ?>"></i>
	                <span><i class="fa fa-angle-down"></i></span>
	            </div>

	            <ul class="designer-boutique-icon-list clearfix">
	                <?php
	                $designer_boutique_font_awesome_icon_array = designer_boutique_font_awesome_icon_array();
	                foreach ($designer_boutique_font_awesome_icon_array as $designer_boutique_font_awesome_icon) {
	                   $icon_class = $this->value() == $designer_boutique_font_awesome_icon ? 'icon-active' : '';
	                   echo '<li class=' . esc_attr($icon_class) . '><i class="' . esc_attr($designer_boutique_font_awesome_icon) . '"></i></li>';
	                }
	                ?>
	            </ul>
	            <input type="hidden" value="<?php $this->value(); ?>" <?php $this->link(); ?> />
	        </label>
	        <?php
      	}
  	}
}
function designer_boutique_customizer_script() {
   wp_enqueue_style( 'font-awesome-1', get_template_directory_uri().'/assets/css/fontawesome-all.css');
}
add_action( 'customize_controls_enqueue_scripts', 'designer_boutique_customizer_script' );