<?php 
	 add_action( 'wp_enqueue_scripts', 'delicious_recipe_blog_enqueue_styles' );
	 function delicious_recipe_blog_enqueue_styles() {
 		  wp_enqueue_style( 'delicious-recipe-blog-parent-style', get_template_directory_uri() . '/style.css' ); 
		   wp_enqueue_style( 'delicious-recipe-blog-font', delicious_recipe_blog_font_url(), array(), null);
		   wp_enqueue_style( 'delicious-recipe-blog-child-css', get_template_directory_uri() . '/assets/css/elegant-recipe-blog.css', array(), '1.0' );
		   wp_enqueue_style( 'delicious-recipe-blog-child-style', get_stylesheet_directory_uri().'/style.css', array('parent-style') );

 		  } 


   function delicious_recipe_blog_dequeue_scripts() {
	wp_dequeue_script('slick-js');
	wp_deregister_script( 'slick-js' );
}
add_action( 'wp_print_scripts', 'delicious_recipe_blog_dequeue_scripts' );
		
	
function delicious_recipe_blog_enqueue_scripts() {

	wp_enqueue_script(
        'child-slick-js',
        get_stylesheet_directory_uri() . '/slick.min.js',
        array( 'jquery' )
    );
	wp_enqueue_script(
        'delicious-recipe-blog-custom-script',
        get_stylesheet_directory_uri() . '/custom_script.js',
        array( 'jquery' )
    );
}

add_action( 'wp_enqueue_scripts', 'delicious_recipe_blog_enqueue_scripts');

function delicious_recipe_blog_widgets_init()
{
    register_sidebar([
        'name' => esc_html__('HomePage Sidebar', 'delicious-recipe-blog'),
        'id' => 'homepage-sidebar',
        'description' => esc_html__('Add widgets here.', 'delicious-recipe-blog'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title"><span>',
        'after_title' => '</span></h2>',
    ]);
}
add_action('widgets_init', 'delicious_recipe_blog_widgets_init');


if (!function_exists('delicious_recipe_blog_font_url')) :
    function delicious_recipe_blog_font_url()
    {
        $fonts_url = '';
        $fonts = array();


        if ('off' !== _x('on', 'EB Garamond font: on or off', 'delicious-recipe-blog')) {
            $fonts[] = 'EB Garamond:400';
        }
        if ($fonts) {
            $fonts_url = add_query_arg(array(
                'family' => urlencode(implode('|', $fonts)),
            ), '//fonts.googleapis.com/css');
        }

        return $fonts_url;
    }
endif;


 ?>