<?php
/**
 * Global navigation
 */
class dekiru_walker extends Walker_Nav_Menu {
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = ( $depth > 0  ? str_repeat( "\t", $depth ) : '' );
		$class_names = 'dropdown-menu';

		$output .= "\n" . $indent . '<ul class="' . $class_names . '">' . "\n";
	}

	function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$depth_class_names = ( $depth == 0 ) ? 'dropdown' : 'dropdown-submenu';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$str_classes = implode( ' ', $classes );

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );

		$rtn = preg_match('/menu-item-has-children/', $str_classes);
		if ( $rtn ) {
			$class_names = $depth_class_names . ' ' . $class_names;
		}

		if ( $item->current || $item->current_item_ancestor ) {
			$class_names .= ' active';
		}

		if ( !empty($class_names) ) {
			$output .= $indent . '<li class="' . $class_names . '">';
		} else {
			$output .= $indent . '<li>';
		}


		$attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
		$attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
		$attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		$attributes .= ! empty( $item->url )        ? ' href="'   . esc_url( $item->url        ) .'"' : '';

		$item_output = $args->before;
		$item_output .= '<a'. $attributes .'>';
		$item_output .= $args->link_before .apply_filters( 'the_title', $item->title, $item->ID );
		$item_output .= $args->link_after;
		$item_output .= '</a>';

		if ( $rtn && $depth == 0 ) {
			$item_output .= '<a class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="fa fa-angle-right"></i></a>';
		}
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}

function dekiru_css_attributes_filter($var) {
	return is_array($var) ? array_intersect($var, array('current-menu-item')) : '';
}
add_filter('nav_menu_css_class', 'dekiru_css_attributes_filter', 100, 1);
add_filter('nav_menu_item_id', 'dekiru_css_attributes_filter', 100, 1);

class dekiru_walker_page extends Walker_Page {
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = ( $depth > 0  ? str_repeat( "\t", $depth ) : '' );
		$class_names = 'dropdown-menu';

		$output .= "\n" . $indent . '<ul class="' . $class_names . '">' . "\n";
	}

	function start_el( &$output, $page, $depth = 0, $args = array(), $current_page = 0 ) {
		global $wp_query;
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$depth_class_names = ( $depth == 0 ) ? 'dropdown' : 'dropdown-submenu';

		$css_class = array( 'page_item', 'page-item-' . $page->ID );

		if ( isset( $args['pages_with_children'][ $page->ID ] ) ) {
			$css_class[] = 'page_item_has_children';
		}

		if ( ! empty( $current_page ) ) {
			$_current_page = get_post( $current_page );
			if ( $_current_page && in_array( $page->ID, $_current_page->ancestors ) ) {
				$css_class[] = 'current_page_ancestor';
			}
			if ( $page->ID == $current_page ) {
				$css_class[] = 'current_page_item';
			} elseif ( $_current_page && $page->ID == $_current_page->post_parent ) {
				$css_class[] = 'current_page_parent';
			}
		} elseif ( $page->ID == get_option('page_for_posts') ) {
			$css_class[] = 'current_page_parent';
		}

		$css_classes = $class_names = implode( ' ', apply_filters( 'page_css_class', $css_class, $page, $depth, $args, $current_page ) );

		$rtn = preg_match('/page_item_has_children/', $css_classes);
		if ( $rtn ) {
			$class_names = $depth_class_names . ' ' . $class_names;
		}

		$rtn1 = preg_match('/current_page_ancestor/', $css_classes);
		$rtn2 = preg_match('/current_page_item/', $css_classes);
		if ( $rtn1 || $rtn2 ) {
			$class_names .= ' active';
		}

		if ( '' === $page->post_title ) {
			$page->post_title = sprintf(
				/* translators:
					%d: post id.
				*/
				__( '#%d (no title)', 'dekiru' ),
				$page->ID
			);
		}

		$args['link_before'] = empty( $args['link_before'] ) ? '' : $args['link_before'];
		$args['link_after'] = empty( $args['link_after'] ) ? '' : $args['link_after'];

		$output .= $indent . sprintf(
			/* translators:
				class=%s: class name. 
				href=%s: page url.
				%s%s%s: link before context & page title & link after context
			*/
			'<li class="%s"><a href="%s">%s%s%s</a>',
			$class_names,
			get_permalink( $page->ID ),
			$args['link_before'],
			apply_filters( 'the_title', $page->post_title, $page->ID ),
			$args['link_after']
		);

		if ( ! empty( $args['show_date'] ) ) {
			if ( 'modified' == $args['show_date'] ) {
				$time = $page->post_modified;
			} else {
				$time = $page->post_date;
			}

			$date_format = empty( $args['date_format'] ) ? '' : $args['date_format'];
			$output .= ' ' . mysql2date( $date_format, $time );
		}
	}
}