<?php get_header(); ?>

<div id="content">
	<?php if (have_posts()) :?>
	<?php while (have_posts()) : the_post(); ?>

	<div class="entry">
		<div class="entrytitle_wrap">
			<div class="entrytitle">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2> 
			</div>
			<div class="entrydate"><?php the_time('F jS, Y'); ?></div>
		</div>

		<div class="entrybody">
                    <?php if ((function_exists('has_post_thumbnail')) 
                             AND (has_post_thumbnail())) {
                        the_post_thumbnail(array(200, 200),
                            array('class' => 'alignleft'));
                         }
                    ?>
                    <?php the_content("Read more about ".get_the_title('', '', false)." &raquo;");   ?>
		</div>
		
		<div class="pagelink"><?php wp_link_pages(); ?></div>

		<div class="entrymeta">
			<div class="postinfo"> 
		
				<span><span class="postedby">&nbsp;</span>Posted by <?php the_author() ?></span>
				<span class="info"><span class="categorylink">&nbsp;</span><?php the_category(', ') ?></span>
		
				<span class="info"><span class="commentlink">&nbsp;</span><?php comments_popup_link('No comments', '1 Comment', '% Comments');?></span>   
				
				<?php edit_post_link('Edit', ' | ', ''); ?>
			</div>
		</div>
               
	</div> <!-- end div entry -->

	<?php endwhile; ?>
         
    <div id="navigation">
        <div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
        <div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
    </div>

    <?php else : ?>
	<h2 class="title">Not Found</h2>
	<div class="entrybody">Sorry, but you are looking for something that isn't here.</div>
    <?php endif; ?>

</div><!-- end content -->




<?php get_footer(); ?>