<?php

    class CloudyLifeOptions
    {
        protected $themename = "Deerawan - Cloudy";
        protected $shortname = "cl";
        protected $options = array();

        function CloudyLifeOptions()
        {
            $this->createOptions();
            add_action('admin_init', array(&$this, 'mytheme_add_init'));
            add_action('admin_menu', array(&$this, 'mytheme_add_admin'));
        }
    
        function createOptions()
        {
            $themename = $this->themename;
            $shortname = $this->shortname;
            
            $this->options = array (
 
                array( "name" => $themename." Options",
                    "type" => "title"),


                array( "name" => "General",
                    "type" => "section"),
                array( "type" => "open"),
                
                array( "name" => "Colour Scheme",
                    "desc" => "Select the colour scheme for the theme",
                    "id" => $shortname."_colorscheme",
                    "type" => "select",
                    "options" => array("blue", "green", "brown"),
                    "std" => "blue"),

                array( "name" => "Custom Header Logo",
                    "desc" => "You can paste your custom header logo URL here to replace text title. Recommended size is 215 x 75 in PNG format.",
                    "id" => $shortname."_custom_header_logo",
                    "type" => "text",
                    "std" => ''),

                array( "name" => "Show Go To Top",
                    "desc" => "Check if you want to show go to top option. In IE6, this feature is disabled automatically.",
                    "id" => $shortname."_checkgototop",
                    "type" => "checkbox",
                    "std" => 1),

                array( "type" => "close"),

                array( "name" => "Sidebar",
                    "type" => "section"),
                array( "type" => "open"),

                array( "name" => "Feedburner URL",
                    "desc" => "You can enter your feedburner here",
                    "id" => $shortname."_feedburner",
                    "type" => "text",
                    "std" => ''),

                array( "name" => "Show Twitter Icon",
                    "desc" => "Check if you want to show your twitter icon and address in sidebar",
                    "id" => $shortname."_checktwitter",
                    "type" => "checkbox",
                    "std" => ''),

                array( "name" => "Twitter URL",
                    "desc" => "You can enter your twitter address here",
                    "id" => $shortname."_twitter",
                    "type" => "text",
                    "std" => 'http://www.twitter.com'),

                array( "name" => "Show Facebook Icon",
                    "desc" => "Check if you want to show your facebook icon and address in sidebar",
                    "id" => $shortname."_checkfacebook",
                    "type" => "checkbox",
                    "std" => ''),

                array( "name" => "Facebook URL",
                    "desc" => "You can paste your facebook address here",
                    "id" => $shortname."_facebook",
                    "type" => "text",
                    "std" => 'http://www.facebook.com'),

                array( "type" => "close"),

                array( "name" => "Adsense",
                    "type" => "section"),
                array( "type" => "open"),

                array( "name" => "Header",
                    "desc" => "You can paste your adsense code here. Ads will be put in header (between blog title and content).",
                    "id" => $shortname."_ads_header",
                    "type" => "textarea",
                    "std" => ""),

                array( "name" => "First Column Sidebar",
                    "desc" => "You can paste your adsense code here. Ads will be put in the first column of sidebar. The width of the column is 170px.",
                    "id" => $shortname."_ads_firstcolumn",
                    "type" => "textarea",
                    "std" => ""),

                array( "name" => "Second Column Sidebar",
                    "desc" => "You can paste your adsense code here. Ads will be put in the second column of sidebar. The width of the column is 170px.",
                    "id" => $shortname."_ads_secondcolumn",
                    "type" => "textarea",
                    "std" => ""),

                array( "name" => "Middle",
                    "desc" => "You can paste your adsense code here. Ads will be put between post and comments.",
                    "id" => $shortname."_ads_middle",
                    "type" => "textarea",
                    "std" => ""),

                array( "type" => "close")

            );
        }

        function mytheme_add_init()
        {
            $file_dir = get_bloginfo('template_directory');
            wp_enqueue_style("functions", $file_dir."/functions/functions.css", false, "1.0", "all");
            wp_enqueue_script("rm_script", $file_dir."/functions/rm_script.js", false, "1.0");
        }

        function mytheme_add_admin()
        {
            $themename = $this->themename;
            $shortname = $this->shortname;
            $options = $this->options;
            
            //global $themename, $shortname, $options;

            if ( $_GET['page'] == basename(__FILE__) ) {

                if ( 'save' == $_REQUEST['action'] ) {

                    foreach ($options as $value) {
                        if( isset( $_REQUEST[ $value['id'] ] ) ) {
                            update_option( $value['id'], $_REQUEST[ $value['id'] ]  );
                        }
                        else {
                             delete_option( $value['id'] );
                        }
                    }

                header("Location: admin.php?page=cloudy-life-options.php&saved=true");
                die;

                }
                else if( 'reset' == $_REQUEST['action'] ) {

                    foreach ($options as $value) {
                        delete_option( $value['id'] );
                    }

                    header("Location: admin.php?page=cloudy-life-options.php&reset=true");
                die;

                }
            }

            add_theme_page($themename.' Options', $themename.' Options', 'administrator', basename(__FILE__), array(&$this, 'mytheme_admin'));
            add_menu_page($themename.' Options', $themename.' Options', 'administrator', basename(__FILE__), array(&$this, 'mytheme_admin'));
        }

        function mytheme_admin()
        {
            $themename = $this->themename;
            $shortname = $this->shortname;
            $options = $this->options;

            //global $themename, $shortname, $options;
            $i=0;
            $initial = true;

            if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
            if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';

            if($_REQUEST['saved'])
                $initial = false;
            else
                $initial = true;
            ?>
            <div class="wrap rm_wrap">
            <h2><?php echo $themename; ?> Theme Options</h2>

            <div class="rm_opts">
            <form method="post">

            <?php foreach ($options as $value) {
            switch ( $value['type'] ) {

            case "open":
            ?>

            <?php break;

            case "close":
            ?>

            </div>
            </div>
            <br />


            <?php break;

            case "title":
            ?>
            <p>You can configure <?php echo $themename;?> theme by using the menu below.</p>


            <?php break;

            case 'text':
            ?>

            <div class="rm_input rm_text">
                <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                <input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" value="<?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id'])  ); } else { echo $value['std']; } ?>" />
             <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>

             </div>
            <?php
            break;

            case 'textarea':
            ?>

            <div class="rm_input rm_textarea">
                <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>
                <textarea name="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" cols="" rows=""><?php if ( get_settings( $value['id'] ) != "") { echo stripslashes(get_settings( $value['id']) ); } else { echo $value['std']; } ?></textarea>
             <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>

             </div>

            <?php
            break;

            case 'select':
            ?>

            <div class="rm_input rm_select">
                <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>

            <select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
            <?php foreach ($value['options'] as $option) { ?>
                    <option <?php if (get_settings( $value['id'] ) == $option) { echo 'selected="selected"'; } ?>><?php echo $option; ?></option><?php } ?>
            </select>

                <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
            </div>
            <?php
            break;

            case "checkbox":

            if($value['std'] == 1 && $initial)
                update_option( $value['id'], 1 );
            ?>

            <div class="rm_input rm_checkbox">
                <label for="<?php echo $value['id']; ?>"><?php echo $value['name']; ?></label>

            <?php if(get_option($value['id'])){ $checked = "checked=\"checked\""; }else{ $checked = "";} ?>
            <input type="checkbox" name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" value="true" <?php echo $checked; ?> />


                <small><?php echo $value['desc']; ?></small><div class="clearfix"></div>
             </div>
            <?php break;
            case "section":

            $i++;

            ?>

            <div class="rm_section">
            <div class="rm_title">
            <h3><img src="<?php bloginfo('template_directory')?>/functions/images/trans.gif" class="inactive" alt=""">
            <?php echo $value['name']; ?></h3><span class="submit">
            <input class="button-primary" name="save<?php echo $i; ?>" type="submit" value="Save changes" />
            </span><div class="clearfix"></div></div>
            <div class="rm_options">


            <?php break;

            }
            ?>
            <?php
            }
            ?>

            <p style="float:left;">
            <input class="button-primary" name="save<?php echo $i; ?>" type="submit" value="Save All changes" />
            <input type="hidden" name="action" value="save" />
            </p>
            </form>
            <form method="post">
            <p style="float:right;">
            <input class="button-secondary" name="reset" type="submit" value="Reset All" />
            <input type="hidden" name="action" value="reset" />
            </p>
            </form>
            <div style="clear:both"></div>

            <div class="section">
                <?php echo $themename ?> is designed by <a href="http://www.deerawan.com">Budi Irawan</a> from Indonesia ^^
                <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
                <input type="hidden" name="cmd" value="_s-xclick">
                <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
                ">
                <input type="image" src="https://www.paypal.com/en_US/i/btn/btn_donate_SM.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
                <img alt="" border="0" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
                </form>
            </div>


            <?php
        }

    }

    
    