/**
 * Enables menu toggle for small screens.
 */
( function( $ ) {
    var nav = $( '#access' ), button, menu;
    if ( ! nav )
    	return;

    button = nav.find( '.menu-toggle' );
    if ( ! button )
    	return;

    // Hide button if menu is missing or empty.
    menu = nav.find( '.sf-menu' );
    if ( ! menu || ! menu.children().length ) {
    	button.hide();
    	return;
    }

    $( '.menu-toggle' ).on( 'click', function() {
    	nav.toggleClass( 'toggled-on' );
    } );	
} )( jQuery ); 