# Contribute To Deciduous

Community made patches, localizations, bug reports and contributions are always welcome and are crucial to ensure that Deciduous continues to live and evolve together with WordPress.

When contributing please ensure you follow the guidelines below so that we can keep on top of things.

__Please Note:__ GitHub is for bug reports and contributions only - if you have a support question don't post here, use the WordPress support forums instead.

## GitHub Contribuutions
### Getting Started

* Submit a ticket for your issue, assuming one does not already exist.
* Raise it on our [Issue Tracker](https://github.com/emhr/Deciduous/issues)
* Clearly describe the issue including steps to reproduce the bug.
* Make sure you fill in the earliest version that you know has the issue as well as the version of WordPress you're using.

### Making Changes

* Fork the repository on GitHub
* Make the changes to your forked repository
* Ensure you stick to the [WordPress Coding Standards](http://codex.wordpress.org/WordPress_Coding_Standards)
* When committing, reference your issue (if present) and include a note about the fix
* Please take care to write a good commit message. Your message will be part of the history of the repository and a good message helps everyone understand what has happened. Some tips and guidelines can be found in the additional resource list further down.
* If possible, and if applicable, please also add/update unit tests for your changes
* Push the changes to your fork and submit a pull request to the 'master' branch of the Deciduous repository

### Code Documentation

* We try to ensure that every function is documented well and follows the standards set by phpDoc
* An example function can be found [here](https://gist.github.com/sunnyratilal/5308969)
* Finally, please use tabs and not spaces. The tab indent size should be 4 for all code.

At this point you're waiting on us to merge your pull request. We'll review all pull requests, and make suggestions and changes if necessary.

## Localizations

Help us ranslate Deciduous into different languages. You can register for our [glotpress translation project](http://translate.d.eciduo.us/glotpress/projects/deciduous) by [contacting us](http://d.eciduo.us/contact) and we will set you up with a login to get you started translating.

## Additional Resources

* [General GitHub Documentation](http://help.github.com/)
* [GitHub Pull Request documentation](http://help.github.com/send-pull-requests/)
* [How to write a good commit message](https://github.com/erlang/otp/wiki/Writing-good-commit-messages)
* [5 tips for even better commit messages](http://robots.thoughtbot.com/5-useful-tips-for-a-better-commit-message)