<?php
/**
 * This is the main template file.
 *
 * @package ESE Themes
 * @subpackage De Base
 */

get_header(); ?>

<div id="page-container">
    
    <div id="main-content">
        
		<?php while ( have_posts() ) : the_post(); ?>
        
        <article id="post-<?php the_ID(); ?>">
            
            <header class="post-header">
                <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <?php debase_posted_on(); ?>
                Posted in <?php the_category(' '); ?>
            </header>
            <!-- .post-header -->

			<div class="post-thumbnail"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a></div>
            
            <div class="post-content">
                <?php the_excerpt(); ?>
                <span class="edit-link"><?php edit_post_link('Edit Post');?> </span>
            </div>
            <!-- .post-content --> 
        
        </article>
        <!-- #article -->
        
        <?php endwhile; ?>

        <div class="post-navigation">
            <?php posts_nav_link(); ?>
            <?php wp_link_pages(); ?>
        </div>

    </div>
    <!-- #main-content -->
    
    <?php get_sidebar(); ?>
    
    <div class="clearfloat"></div>

</div>
<!-- #page-container -->

<?php get_footer(); ?>
