<?php
/**
 * This header displays all of the <head> section and everything up until the <div id="page">.
 *
 * @package ESE Themes
 * @subpackage De Base
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, user-scalable=yes">

<title><?php wp_title('-', 'true', 'right'); ?></title>

<?php wp_enqueue_script('Google Fonts', 'http://fonts.googleapis.com/css?family=Raleway:100,200,300,400,500,600,700,800,900') ?>
<?php wp_enqueue_script('Google Fonts', 'http://fonts.googleapis.com/css?family=Rokkit:400,700') ?>

<link href="<?php bloginfo('stylesheet_url'); ?>" rel="stylesheet" type="text/css" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<header id="header-container">

    <div id="header-content">
		
        <div id="site-name">
            <a href="<?php bloginfo('url'); ?>" rel="home">
            <h1><?php bloginfo('name'); ?></h1>
			<h2><?php bloginfo('description'); ?></h2>
            </a>
        </div>
        
        <div id="logo-container" style="display:none">
        	<a href="<?php bloginfo('url'); ?>" rel="home"><img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="" /></a>
        </div>
        
        <div class="clearfloat"></div>

    </div>

        <div class="main-navigation-container">
            <nav class="main-navigation site-navigation" id="primary-navigation">
                <h1 class="menu-toggle"></h1>
                <?php wp_nav_menu( array( 'theme_location' => 'main', 'menu_class' => 'nav-menu' ) ); ?>
            </nav>
        	<div class="clearfloat"></div>
        </div>

</header>
<!-- #header-container -->