<?php add_action( 'after_setup_theme', 'debase_setup' );

function debase_setup() {

// This script is needed for the mobile-optimized menu.
function debase_scripts() {
	wp_enqueue_script( 'debase-script', get_template_directory_uri() . '/js/functions.js', array( 'jquery' ), '20131209', true );
}
add_action( 'wp_enqueue_scripts', 'debase_scripts' );

// Set content width
if ( ! isset( $content_width ) ) $content_width = 620;


// Function for page title tag
add_filter( 'wp_title', 'filter_wp_title' );
/**
 * Filters the page title appropriately depending on the current page
 * This function is attached to the 'wp_title' fiilter hook.
 */
function filter_wp_title( $title ) {
	global $page, $paged;

	if ( is_feed() )
		return $title;

	$site_description = get_bloginfo( 'description' );

	$filtered_title = $title . get_bloginfo( 'name' );
	$filtered_title .= ( ! empty( $site_description ) && ( is_home() || is_front_page() ) ) ? ' | ' . $site_description: '';
	$filtered_title .= ( 2 <= $paged || 2 <= $page ) ? ' | ' . sprintf( __( 'Page %s', 'debase'), max( $paged, $page ) ) : '';

	return $filtered_title;
}


// Add theme support
add_theme_support( 'automatic-feed-links' );
add_theme_support( "post-thumbnails" );
add_theme_support( "custom-background" );

function debase_add_editor_styles() {
    add_editor_style();
}

$args = array(
	'flex-width'    => true,
	'width'         => 480,
	'flex-height'    => true,
	'height'        => 100,
	'default-text-color' => 'FFF',
	'header-text' => true,
);
add_theme_support( 'custom-header', $args );


// Registers menu locations.
register_nav_menus( array(
	'main'   => __( 'Main Menu', 'debase' ),
) );


// Registers widget areas.
register_sidebar( array(
	'name'          => __( 'Main Sidebar', 'debase' ),
	'id'            => 'main-sidebar',
	'description'   => __( 'Main sidebar that appears on the right.', 'debase'),
	'before_widget' => '<div id="%1$s" class="sidebar-widget">',
	'after_widget'  => '</div>',
	'before_title'  => '<h1 class="widget-title">',
	'after_title'   => '</h1>',
) );


//Print HTML with meta information for the current post-date/time and author.
if ( ! function_exists( 'debase_posted_on' ) ) :

function debase_posted_on() {
	if ( is_sticky() && is_home() && ! is_paged() ) {
		echo '<span class="featured-post">' . __( 'Sticky', 'debase' ) . '</span>';
	}

// Set up and print post meta information.
	printf( '<span class="post-meta">Posted on <a href="%1$s"><time datetime="%2$s">%3$s</time></a> | <span class="author vcard">Posted by <a class="url fn n" href="%4$s" rel="author">%5$s</a></span>',
		esc_url( get_permalink() ),
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		get_the_author()
	);
}
endif;

// Set custom exercpt length
function custom_excerpt_length( $length ) {
	return 50;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

// Change excerpt more link
function new_excerpt_more( $more ) {
	return '&nbsp;<a href="'. get_permalink( get_the_ID() ) . '" class="readmore">...read more</a>';
}
add_filter('excerpt_more', 'new_excerpt_more');



}