<?php
/**
 * This template displays the Category posts
 *
 * @package ESE Themes
 * @subpackage De Base
 */

get_header(); ?>

<div id="page-container">
	
    <div id="main-content">

		<h1 class="page-title">Live Show Archives</h1>
            
		<?php while ( have_posts() ) : the_post(); ?>
        
        <article id="post-<?php the_ID(); ?>">
            
            <header class="post-header">
                <h3 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                <?php debase_posted_on(); ?>
            </header>
            <!-- .post-header -->

			<div class="post-thumbnail"><a href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a></div>
            
            <div class="post-content">
                <?php the_excerpt(); ?>
                <span class="edit-link"><?php edit_post_link('Edit Post');?> </span>
            </div>
            <!-- .post-content --> 
        
        </article>
        <!-- #article -->
        
        <?php endwhile; ?>

        <div class="post-navigation">
            <?php posts_nav_link(); ?>
            <?php wp_link_pages(); ?>
        </div>

	</div>
    <!-- #main-content -->
        
	<?php get_sidebar(); ?>

    <div class="clearfloat"></div>

</div>
<!-- #page -->
    
<?php get_footer(); ?>