<?php
/**
 * @package Datar
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?php if ( has_post_thumbnail() ) { ?>
		<a class="post-image" title="<?php the_title_attribute(); ?>" href="<?php the_permalink(); ?>">	
			<div class="post-thumbnail">
				<?php the_post_thumbnail( ); ?>
			</div>
		</a> <!-- /featured-media -->
		<?php } ?>
	<header class="entry-header">

			<?php if ( is_sticky() ) : ?>
		    
		    	<a href="<?php the_permalink(); ?>" title="<?php _e('Sticky post','datar') ?>" class="sticky-post">
			    	<div class="fa fa-thumb-tack"></div>
			    </a>
		    
		    <?php endif; ?>

		<?php the_title( sprintf( '<h1 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h1>' ); ?>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php datar_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

		<div class="entry-content">
		<?php
		if ( is_single() ) :
			/* translators: %s: Name of current post */
			the_content( sprintf(
				__( 'Continue reading %s', 'datar' ),
				the_title( '<span class="screen-reader-text">', '</span>', false )
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'datar' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'datar' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
			else :

			/* translators: %s: Name of current post */
			the_excerpt( sprintf(
				__( 'Continue reading %s', 'datar' ),
				the_title( '<span class="screen-reader-text">', '</span>', false )
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'datar' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'datar' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
			endif;
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php datar_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->