<?php
/**
 * datar functions and definitions
 *
 * @package Datar
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) {
	$content_width = 970; /* pixels */
}

if ( ! function_exists( 'datar_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function datar_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 */
	load_theme_textdomain( 'datar', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/* Post Thumbnails */
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 811, 420, true );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'datar' ),
	) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside', 'image', 'video', 'quote', 'link',
	) );

	// Set up the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'datar_custom_background_args', array(
		'default-color' => 'ebe8e5',
		'default-image' => '',
	) ) );
	}
	endif; // datar_setup
	add_action( 'after_setup_theme', 'datar_setup' );

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
add_action( 'widgets_init', 'datar_widgets_init' );

function datar_widgets_init() {
	register_sidebar( 
		array(
		'name'          => __( 'Sidebar', 'datar' ),
		'id'            => 'sidebar-1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h1 class="widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar(
		array(
		'name' => __("Above Header", "datar"),
		'id' => 'aboveheader',
		'description' => __( 'Above header and menu, right aligned, use for social icons.', 'datar' ),
		'before_widget' => "<div class='aboveheader'>",
		'after_widget' => "</div>"
	) );
	register_sidebar(
		array(
		'name' => __("Above Content Area", "datar"),
		'id' => 'abovecontent',
		'description' => __( 'Front page only, use for sliders.', 'datar' ),
		'before_widget' => "<div class='abovecontent'>",
		'after_widget' => "</div>"
	) );
}

/**
 * Enqueue scripts and styles.
 */
function datar_scripts() {
	wp_enqueue_style( 'datar-style', get_stylesheet_uri() );

	wp_enqueue_script( 'datar-main', get_template_directory_uri() . '/js/datar.js', array('jquery'), '', true );

	wp_enqueue_script( 'datar-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '', true );

	wp_enqueue_script( 'datar-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );

	wp_enqueue_style('font-awesome', get_stylesheet_directory_uri() . '/extras/css/font-awesome.css');
	
	wp_enqueue_script( 'datar-modernizr', get_template_directory_uri() . '/js/modernizr.min.js' );
	
	wp_enqueue_script( 'rem-unit-polyfill', get_template_directory_uri() . '/js/rem.js', false, false, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'datar_scripts' );

// Add editor styles
function datar_add_editor_styles() {
    add_editor_style( 'datar-editor-style.css' );
    $font_url = '//fonts.googleapis.com/css?family=Playfair+Display:300,400,400italic,600,700,700italic,800|Quando:400,400italic,700,700italic';
    add_editor_style( str_replace( ',', '%2C', $font_url ) );
}
add_action( 'init', 'datar_add_editor_styles' );

/**
 * Footer credits
 */
function datar_footer_credits() {
	echo '<a href="' . esc_url( __( 'http://wordpress.org/', 'datar' ) ) . '" rel="nofollow">';
		printf( __( 'Proudly Powered by %s', 'datar' ), 'WordPress' );
	echo '</a>';
	echo '<span class="sep"> | </span>';
	printf( __( '<strong>Theme:</strong> %2$s by %1$s.', 'datar' ), '<a href="https://walterpinem.me" rel="nofollow">Walter Pinem</a>', 'Datar' );
}
add_action( 'datar_footer', 'datar_footer_credits' );

// Add Google Fonts Support
function datar_add_google_fonts() {

wp_enqueue_style( 'datar-google-fonts', '//fonts.googleapis.com/css?family=Quando:300,300italic,400,400italic,700,700italic,900,900italic', false );
wp_enqueue_style( 'datar-google-fonts-playfair-display', '//fonts.googleapis.com/css?family=Playfair+Display:300,300italic,400,400italic,700,700italic,900,900italic', false ); 
}
add_action( 'wp_enqueue_scripts', 'datar_add_google_fonts' );

// Control Excerpt Length & Style
function datar_excerpt_length( $length ) {
    return 100;
}
add_filter( 'excerpt_length', 'datar_excerpt_length', 999 );

function datar_excerpt_more( $more ) {
	return ' <a class="read-more read-more-onhover" href="'. esc_url(get_permalink( get_the_ID() )) . '">' . __('Read More', 'datar') . '</a>';
}
add_filter( 'excerpt_more', 'datar_excerpt_more' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';
