
// Creta Testimonial Showcase plugin activation
document.addEventListener('DOMContentLoaded', function () {
    const data_science_specialist_button = document.getElementById('install-activate-button');

    if (!data_science_specialist_button) return;

    data_science_specialist_button.addEventListener('click', function (e) {
        e.preventDefault();

        const data_science_specialist_redirectUrl = data_science_specialist_button.getAttribute('data-redirect');

        // Step 1: Check if plugin is already active
        const data_science_specialist_checkData = new FormData();
        data_science_specialist_checkData.append('action', 'check_creta_testimonial_activation');

        fetch(installcretatestimonialData.ajaxurl, {
            method: 'POST',
            body: data_science_specialist_checkData,
        })
        .then(res => res.json())
        .then(res => {
            if (res.success && res.data.active) {
                // Plugin is already active → just redirect
                window.location.href = data_science_specialist_redirectUrl;
            } else {
                // Not active → proceed with install + activate
                data_science_specialist_button.textContent = 'Nevigate Getstart';

                const data_science_specialist_installData = new FormData();
                data_science_specialist_installData.append('action', 'install_and_activate_creta_testimonial_plugin');
                data_science_specialist_installData.append('_ajax_nonce', installcretatestimonialData.nonce);

                fetch(installcretatestimonialData.ajaxurl, {
                    method: 'POST',
                    body: data_science_specialist_installData,
                })
                .then(res => res.json())
                .then(res => {
                    if (res.success) {
                        window.location.href = data_science_specialist_redirectUrl;
                    } else {
                        alert('Activation error: ' + (res.data?.message || 'Unknown error'));
                        data_science_specialist_button.textContent = 'Try Again';
                    }
                })
                .catch(error => {
                    alert('Request failed: ' + error.message);
                    data_science_specialist_button.textContent = 'Try Again';
                });
            }
        })
        .catch(error => {
            alert('Check request failed: ' + error.message);
        });
    });
});
