<?php
/**
 * Data Science Specialist functions and definitions
 *
 * @package data_science_specialist
 * @since 1.0
 */

if ( ! function_exists( 'data_science_specialist_support' ) ) :
	function data_science_specialist_support() {

		load_theme_textdomain( 'data-science-specialist', get_template_directory() . '/languages' );

		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );

		add_theme_support('woocommerce');

	 add_editor_style(get_stylesheet_directory_uri() . '/assets/css/editor-style.css');

	 /* Theme Credit link */
	define('DATA_SCIENCE_SPECIALIST_BUY_NOW',__('https://www.cretathemes.com/products/machine-learning-wordpress-theme','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_PRO_DEMO',__('https://pattern.cretathemes.com/data-science-specialist/','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_THEME_DOC',__('https://pattern.cretathemes.com/free-guide/data-science-specialist/','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_PRO_THEME_DOC',__('https://pattern.cretathemes.com/pro-guide/data-science-specialist/','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_SUPPORT',__('https://wordpress.org/support/theme/data-science-specialist','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_REVIEW',__('https://wordpress.org/support/theme/data-science-specialist/reviews/#new-post','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_PRO_THEME_BUNDLE',__('https://www.cretathemes.com/products/wordpress-theme-bundle','data-science-specialist'));
	define('DATA_SCIENCE_SPECIALIST_PRO_ALL_THEMES',__('https://www.cretathemes.com/collections/wordpress-block-themes','data-science-specialist'));

		

	}
endif;
add_action( 'after_setup_theme', 'data_science_specialist_support' );


if ( ! function_exists( 'data_science_specialist_styles' ) ) :
	function data_science_specialist_styles() {
		// Register theme stylesheet.
		$data_science_specialist_theme_version = wp_get_theme()->get( 'Version' );

		$data_science_specialist_version_string = is_string( $data_science_specialist_theme_version ) ? $data_science_specialist_theme_version : false;
		wp_enqueue_style(
			'data-science-specialist-style',
			get_template_directory_uri() . '/style.css',
			array(),
			$data_science_specialist_version_string
		);

		wp_enqueue_script( 'data-science-specialist-custom-script', get_theme_file_uri( '/assets/js/custom-script.js' ), array( 'jquery' ), true );

		wp_enqueue_style( 'dashicons' );

		wp_enqueue_style( 'animate-css', esc_url(get_template_directory_uri()).'/assets/css/animate.css' );

		wp_enqueue_script( 'jquery-wow', esc_url(get_template_directory_uri()) . '/assets/js/wow.js', array('jquery') );

		wp_style_add_data( 'data-science-specialist-style', 'rtl', 'replace' );

		//font-awesome
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/inc/fontawesome/css/all.css'
			, array(), '6.7.0' );

		//homepage slider
		wp_enqueue_style('data-science-specialist-swiper-bundle-style', get_template_directory_uri() . '/assets/css/swiper-bundle.css', array(), $data_science_specialist_version_string);

		wp_enqueue_script('data-science-specialist-swiper-bundle-scripts', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), $data_science_specialist_version_string, true);
	}
endif;

add_action( 'wp_enqueue_scripts', 'data_science_specialist_styles' );

/* Enqueue admin-notice-script js */
add_action('admin_enqueue_scripts', function ($hook) {
    if ($hook !== 'appearance_page_data-science-specialist') return;

    wp_enqueue_script('admin-notice-script', get_template_directory_uri() . '/get-started/js/admin-notice-script.js', ['jquery'], null, true);
    wp_localize_script('admin-notice-script', 'pluginInstallerData', [
        'ajaxurl'     => admin_url('admin-ajax.php'),
        'nonce'       => wp_create_nonce('install_cretatestimonial_nonce'), // Match this with PHP nonce check
        'redirectUrl' => admin_url('themes.php?page=data-science-specialist-guide-page'),
    ]);
});

add_action('wp_ajax_check_creta_testimonial_activation', function () {
    include_once ABSPATH . 'wp-admin/includes/plugin.php';
    $data_science_specialist_plugin_file = 'creta-testimonial-showcase/creta-testimonial-showcase.php';


    if (is_plugin_active($data_science_specialist_plugin_file)) {
        wp_send_json_success(['active' => true]);
    } else {
        wp_send_json_success(['active' => false]);
    }
});

// Add block patterns
require get_template_directory() . '/inc/block-patterns.php';

// Add block styles
require get_template_directory() . '/inc/block-styles.php';

// Block Filters
require get_template_directory() . '/inc/block-filters.php';

// Svg icons
require get_template_directory() . '/inc/icon-function.php';

// Customizer
require get_template_directory() . '/inc/customizer.php';

// Get Started.
require get_template_directory() . '/inc/get-started/get-started.php';

// TGM Plugin
require get_template_directory() . '/inc/tgm/tgm.php';


// Add Getstart admin notice
function data_science_specialist_admin_notice() { 
    global $pagenow;
    $theme_args      = wp_get_theme();
    $meta            = get_option( 'data_science_specialist_admin_notice' );
    $name            = $theme_args->__get( 'Name' );
    $current_screen  = get_current_screen();

    if( !$meta ){
	    if( is_network_admin() ){
	        return;
	    }

	    if( ! current_user_can( 'manage_options' ) ){
	        return;
	    } if($current_screen->base != 'appearance_page_data-science-specialist-guide-page' && $current_screen->base != 'toplevel_page_cretats-theme-showcase' ) { ?>

	    <div class="notice notice-success dash-notice">
	        <h1><?php esc_html_e('Hey, Thank you for installing Data Science Specialist Theme!', 'data-science-specialist'); ?></h1>
	        <p><a href="javascript:void(0);" id="install-activate-button" class="button admin-button info-button get-start-btn">
				   <?php echo __('Nevigate Getstart', 'data-science-specialist'); ?>
				</a>

				<script type="text/javascript">
				document.getElementById('install-activate-button').addEventListener('click', function () {
				    const data_science_specialist_button = this;
				    const data_science_specialist_redirectUrl = '<?php echo esc_url(admin_url("themes.php?page=data-science-specialist-guide-page")); ?>';
				    // First, check if plugin is already active
				    jQuery.post(ajaxurl, { action: 'check_creta_testimonial_activation' }, function (response) {
				        if (response.success && response.data.active) {
				            // Plugin already active — just redirect
				            window.location.href = data_science_specialist_redirectUrl;
				        } else {
				            // Show Installing & Activating only if not already active
				            data_science_specialist_button.textContent = 'Nevigate Getstart';

				            jQuery.post(ajaxurl, {
				                action: 'install_and_activate_creta_testimonial_plugin',
				                nonce: '<?php echo wp_create_nonce("install_activate_nonce"); ?>'
				            }, function (response) {
				                if (response.success) {
				                    window.location.href = data_science_specialist_redirectUrl;
				                } else {
				                    alert('Failed to activate the plugin.');
				                    data_science_specialist_button.textContent = 'Try Again';
				                }
				            });
				        }
				    });
				});
				</script>

	        	<a class="button button-primary site-edit" href="<?php echo esc_url( admin_url( 'site-editor.php' ) ); ?>"><?php esc_html_e('Site Editor', 'data-science-specialist'); ?></a> 
				<a class="button button-primary buy-now-btn" href="<?php echo esc_url( DATA_SCIENCE_SPECIALIST_BUY_NOW ); ?>" target="_blank"><?php esc_html_e('Buy Pro', 'data-science-specialist'); ?></a>
				<a class="button button-primary bundle-btn" href="<?php echo esc_url( DATA_SCIENCE_SPECIALIST_PRO_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e('Get Bundle', 'data-science-specialist'); ?></a>
	        </p>
	        <p class="dismiss-link"><strong><a href="?data_science_specialist_admin_notice=1"><?php esc_html_e( 'Dismiss', 'data-science-specialist' ); ?></a></strong></p>
	    </div>
	    <?php

	}?>
	    <?php

	}
}

add_action( 'admin_notices', 'data_science_specialist_admin_notice' );

if( ! function_exists( 'data_science_specialist_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function data_science_specialist_update_admin_notice(){
    if ( isset( $_GET['data_science_specialist_admin_notice'] ) && $_GET['data_science_specialist_admin_notice'] = '1' ) {
        update_option( 'data_science_specialist_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'data_science_specialist_update_admin_notice' );

//After Switch theme function
add_action('after_switch_theme', 'data_science_specialist_getstart_setup_options');
function data_science_specialist_getstart_setup_options () {
    update_option('data_science_specialist_admin_notice', FALSE );
}


function data_science_specialist_google_fonts() {
 
	wp_enqueue_style( 'montserrat', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap', false ); 
}
 
add_action( 'wp_enqueue_scripts', 'data_science_specialist_google_fonts' );

add_action('admin_bar_menu', 'your_plugin_adminbar_link', 100);
function your_plugin_adminbar_link($wp_admin_bar) {
    $wp_admin_bar->add_node([
        'id'    => 'yourplugin_upgrade',
        'title' => ' Upgrade to Pro',
        'href'  => 'https://www.cretathemes.com/products/machine-learning-wordpress-theme',
        'meta'  => array(
            'target' => '_blank',
        )
    ]);
}