<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package dashy
 */
get_header();
?>

<div id="content" class="site-content details">
		<main id="primary" class="site-main">
		<section class="error-404 not-found">
				<div class="page-content">
                    <strong><?php esc_html_e( '404', 'dashy' ); ?> </strong>
                    <header class="page-header">
						<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'dashy' ); ?></h1>
					</header><!-- .page-header -->
                    <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'dashy' ); ?></p>
                    <br>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="common-button is-bg"><?php esc_html_e( 'Go Back', 'dashy' ); ?> </a> 
					
			</div><!-- .page-content -->
		</section><!-- .error-404 -->

	</main><!-- #main -->

<?php
get_footer();