<?php
/*
 * The header for the head element and for displaying sidebar (with site title, tagline, logo, menu and widgets) and header image.
 */
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<div id="container">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'darkelements' ); ?></a>
	<div id="sidebar">
		<div class="logo">
			<?php if ( get_theme_mod( 'darkelements_logo' ) ) : ?>
				<?php if ( get_theme_mod( 'darkelements_logo_width' ) ) {
					$logo_width = 'style="width:'.get_theme_mod( 'darkelements_logo_width' ).'px;"';
				} else {
					$logo_width = '';
				} ?>
				<div class="site-logo">
					<?php // phpcs:ignore ?>
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>" rel="home"><img src="<?php echo esc_url( get_theme_mod( 'darkelements_logo' ) ); ?>" <?php echo wp_strip_all_tags( $logo_width, true ); ?> class="site-logo-img" alt="<?php bloginfo( 'name' ); ?>"></a>
				</div>
			<?php endif; ?>
			<?php if ( ( get_theme_mod( 'darkelements_site_title' ) != 'no' ) || ( get_theme_mod( 'darkelements_tagline' ) != 'no' ) ) : ?>
				<div class="site-title-tagline">
					<?php if ( get_theme_mod( 'darkelements_site_title' ) != 'no' ) : ?>
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php bloginfo( 'name' ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
					<?php endif; ?>
					<?php if ( get_theme_mod( 'darkelements_tagline' ) != 'no' ) : ?>
						<?php if ( get_bloginfo( 'description' ) ) : ?>
							<div class="site-tagline"><?php bloginfo( 'description' ); ?></div>
						<?php endif; ?>
					<?php endif; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php if ( has_nav_menu( 'primary' ) ) : ?>
			<?php if ( get_theme_mod( 'darkelements_show_menu_title' ) != 'no' ) : ?>
				<?php if ( get_theme_mod( 'darkelements_menu_title' ) ) {
					$menu_title = get_theme_mod( 'darkelements_menu_title' );
				} else {
					$menu_title = __( 'Menu', 'darkelements' );
				} ?>
				<h3 class="nav-primary-title"><?php echo esc_html( $menu_title ); ?></h3>
			<?php endif; ?>
			<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'nav-primary' ) ); ?>
			<div class="mobile-nav-container">
				<?php if ( get_theme_mod( 'darkelements_mobile_menu_label' ) ) {
					$mobile_menu_label = get_theme_mod( 'darkelements_mobile_menu_label' );
				} else {
					$mobile_menu_label = __( 'Menu', 'darkelements' ).' &#43;';
				} ?>
				<button id="mobile-nav-toggle" class="mobile-nav-toggle"><?php echo esc_html( $mobile_menu_label ); ?></button>
				<div id="mobile-nav" class="mobile-nav">
					<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
				</div>
			</div>
		<?php endif; ?>
		<?php if ( is_front_page() || ( ! is_front_page() && ( get_theme_mod( 'darkelements_header_image' ) == 'no' ) ) ) { ?>
			<?php if ( get_header_image() ) { ?>
				<div id="header-image-mobile">
					<img src="<?php header_image(); ?>" class="header-img" alt="<?php bloginfo( 'name' ); ?>" />
				</div>
			<?php } ?>
		<?php } ?>
		<?php get_sidebar(); ?>
	</div>
	<?php if ( is_front_page() || ( ! is_front_page() && ( get_theme_mod( 'darkelements_header_image' ) == 'no' ) ) ) { ?>
		<?php if ( get_header_image() ) { ?>
			<div id="header-image">
				<img src="<?php header_image(); ?>" class="header-img" alt="<?php bloginfo( 'name' ); ?>" />
			</div>
		<?php } ?>
	<?php } ?>
