<?php
/*
 * Theme functions and definitions.
 */

// Sets up theme defaults and registers various WordPress features that theme supports
function darkelements_setup() {
	// Set max content width for img, video, and more
	global $content_width;
	if ( ! isset( $content_width ) )
	$content_width = 680;

	// Register Menu
	register_nav_menus( array(
		'primary' => __( 'Primary Navigation', 'darkelements' ),
	) );

	// Add document title
	add_theme_support( 'title-tag' );

	// Add support for editor styles
	add_theme_support( 'editor-styles' );

	// Add editor styles
	add_editor_style( 'custom-editor-style.css' );

	// Custom header
	$header_args = array(
		'width' => 680,
		'height' => 450,
		'default-image' => get_template_directory_uri() . '/images/boats.jpg',
		'header-text' => false,
		'uploads' => true,
	);
	add_theme_support( 'custom-header', $header_args );

	// Default header
	register_default_headers( array(
		'boats' => array(
			'url' => get_template_directory_uri() . '/images/boats.jpg',
			'thumbnail_url' => get_template_directory_uri() . '/images/boats.jpg',
			'description' => __( 'Default header', 'darkelements' ),
		),
	) );

	// Post thumbnails
	add_theme_support( 'post-thumbnails' );

	// Resize thumbnails
	set_post_thumbnail_size( 300, 300 );

	// This feature adds RSS feed links to html head
	add_theme_support( 'automatic-feed-links' );

	// Switch default core markup for search form, comment form, comments and caption to output valid html5
	add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list', 'caption' ) );

	// Background color and image
	$background_args = array(
		'default-color' => '333333',
	);
	add_theme_support( 'custom-background', $background_args );

	// Post formats
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'gallery', 'audio' ) );
}
add_action( 'after_setup_theme', 'darkelements_setup' );

// Enqueues scripts and styles for front-end
function darkelements_scripts() {
	wp_enqueue_style( 'darkelements-style', get_stylesheet_uri() );
	wp_enqueue_script( 'darkelements-nav', get_template_directory_uri() . '/js/nav.js' );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'darkelements_scripts' );

// Widget areas
function darkelements_widgets_init() {
	register_sidebar( array(
		'name' => __( 'Primary Sidebar', 'darkelements' ),
		'id' => 'primary',
		'description' => __( 'You can add one or multiple widgets here.', 'darkelements' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Left', 'darkelements' ),
		'id' => 'footer-left',
		'description' => __( 'You can add one or multiple widgets here.', 'darkelements' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Middle', 'darkelements' ),
		'id' => 'footer-middle',
		'description' => __( 'You can add one or multiple widgets here.', 'darkelements' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
	register_sidebar( array(
		'name' => __( 'Footer Right', 'darkelements' ),
		'id' => 'footer-right',
		'description' => __( 'You can add one or multiple widgets here.', 'darkelements' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h3 class="widget-title">',
		'after_title' => '</h3>',
	) );
}
add_action( 'widgets_init', 'darkelements_widgets_init' );

// Add class to post nav
function darkelements_post_next() {
	return 'class="nav-next"';
}
add_filter( 'next_posts_link_attributes', 'darkelements_post_next', 999 );

function darkelements_post_prev() {
	return 'class="nav-prev"';
}
add_filter( 'previous_posts_link_attributes', 'darkelements_post_prev', 999 );

// Add class to comment nav
function darkelements_comment_next() {
	return 'class="comment-next"';
}
add_filter( 'next_comments_link_attributes', 'darkelements_comment_next', 999 );

function darkelements_comment_prev() {
	return 'class="comment-prev"';
}
add_filter( 'previous_comments_link_attributes', 'darkelements_comment_prev', 999 );

// Custom excerpt lenght (default length is 55 words)
function darkelements_excerpt_length( $length ) {
	if ( get_theme_mod( 'darkelements_content_lenght' ) ) {
		$length = get_theme_mod( 'darkelements_content_lenght' );
	}
	return $length;
}
add_filter( 'excerpt_length', 'darkelements_excerpt_length', 999 );

// Theme Customizer
function darkelements_theme_customizer( $wp_customize ) {
	$wp_customize->add_section( 'darkelements_logo_section', array(
		'title' => __( 'Logo', 'darkelements' ),
		'priority' => 30,
	) );
	$wp_customize->add_setting( 'darkelements_logo', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'esc_url_raw',
	) );
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'darkelements_logo', array(
		'label' => __( 'Logo', 'darkelements' ),
		'section' => 'darkelements_logo_section',
		'settings' => 'darkelements_logo',
	) ) );
	$wp_customize->add_setting( 'darkelements_logo_width', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_logo_width', array(
		'label' => __( 'Width', 'darkelements' ),
		'description' => __( 'Only numeric characters allowed.', 'darkelements' ),
		'section' => 'darkelements_logo_section',
		'settings' => 'darkelements_logo_width',
		'type' => 'number',
		'input_attrs' => array(
			'min' => 20,
			'max' => 1200,
			'step' => 20,
		),
	) ) );
	$wp_customize->add_section( 'darkelements_sidebar_section', array(
		'title' => __( 'Sidebar', 'darkelements' ),
		'priority' => 31,
	) );
	$wp_customize->add_setting( 'darkelements_show_menu_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_show_menu_title', array(
		'label' => __( 'Menu Title', 'darkelements' ),
		'section' => 'darkelements_sidebar_section',
		'settings' => 'darkelements_show_menu_title',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_menu_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_menu_title', array(
		'section' => 'darkelements_sidebar_section',
		'settings' => 'darkelements_menu_title',
		'input_attrs' => array(
			'placeholder' => __( 'Menu', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_section( 'darkelements_mobile_section', array(
		'title' => __( 'Mobile', 'darkelements' ),
		'priority' => 32,
	) );
	$wp_customize->add_setting( 'darkelements_mobile_menu_label', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_mobile_menu_label', array(
		'label' => __( 'Menu label', 'darkelements' ),
		'section' => 'darkelements_mobile_section',
		'settings' => 'darkelements_mobile_menu_label',
		'input_attrs' => array(
			'placeholder' => __( 'Menu', 'darkelements' ).' &#43;',
		),
	) ) );
	$wp_customize->add_section( 'darkelements_blog_section', array(
		'title' => __( 'Blog', 'darkelements' ),
		'priority' => 33,
	) );
	$wp_customize->add_setting( 'darkelements_blog_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_blog_title', array(
		'label' => __( 'Page title', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_blog_title',
	) ) );
	$wp_customize->add_setting( 'darkelements_blog_content', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_blog_content', array(
		'label' => __( 'Content', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_blog_content',
		'type' => 'textarea',
	) ) );
	$wp_customize->add_setting( 'darkelements_content_type', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_content_type', array(
		'label' => __( 'Summary', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_content_type',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_content_lenght', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_content_lenght', array(
		'label' => __( 'Summary lenght', 'darkelements' ),
		'description' => __( 'Only numeric characters allowed.', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_content_lenght',
		'type' => 'number',
		'input_attrs' => array(
			'min' => 10,
			'max' => 100,
			'step' => 1,
			'placeholder' => '55',
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_read_more', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_read_more', array(
		'label' => __( 'Read More button', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_read_more',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_read_more_label', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_read_more_label', array(
		'label' => __( 'Read More label', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_read_more_label',
		'input_attrs' => array(
			'placeholder' => __( 'Read More', 'darkelements' ).' &raquo;',
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_post_image', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'no',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_post_image', array(
		'label' => __( 'Featured image on single post page', 'darkelements' ),
		'section' => 'darkelements_blog_section',
		'settings' => 'darkelements_post_image',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_section( 'darkelements_footer_section', array(
		'title' => __( 'Footer', 'darkelements' ),
		'priority' => 34,
	) );
	$wp_customize->add_setting( 'darkelements_footer_content', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_footer_content', array(
		'label' => __( 'Copyright', 'darkelements' ),
		'section' => 'darkelements_footer_section',
		'settings' => 'darkelements_footer_content',
		'type' => 'textarea',
		'input_attrs' => array(
			'placeholder' => __( 'Copyright', 'darkelements' ).' '.gmdate( 'Y' ).' '.get_bloginfo( 'name' ),
		),
	) ) );
	// Site Identity section
	$wp_customize->add_setting( 'darkelements_site_title', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_site_title', array(
		'label' => __( 'Site Title', 'darkelements' ),
		'section' => 'title_tagline',
		'settings' => 'darkelements_site_title',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	$wp_customize->add_setting( 'darkelements_tagline', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_tagline', array(
		'label' => __( 'Tagline', 'darkelements' ),
		'section' => 'title_tagline',
		'settings' => 'darkelements_tagline',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
	// Header Image section	
	$wp_customize->add_setting( 'darkelements_header_image', array(
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default' => 'yes',
	) );
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'darkelements_header_image', array(
		'label' => __( 'Homepage only', 'darkelements' ),
		'section' => 'header_image',
		'settings' => 'darkelements_header_image',
		'type' => 'radio',
		'choices' => array(
			'yes' => __( 'Yes', 'darkelements' ),
			'no' => __( 'No', 'darkelements' ),
		),
	) ) );
}
add_action( 'customize_register', 'darkelements_theme_customizer' );
