<?php
//  TABLE OF CONTENTS

//  Widgets
//  Nav Animation
//  Register Custom Menu
//  Archive Pagination
//  Search Highlighting
//  Comment output
//  Custom Login
//  Post Thumbnail
//  Change Excerpt Content
//  Custom Admin Site Footer 
//  Custom Dashboard Widget
//  Eliminate Spam Comments
//  Custom Gravatar
//  Change Excerpt Content



/* Widgets ********************************************/
// This establishes the elements that wrap your widgets

    register_sidebar(array( 
    'name' => 'Page', 
    'before_widget' => '<div id="%1$s" class="widget %2$s">', 
    'after_widget' => '</div>', 
    'before_title' => '<h3 class="widgettitle">', 
    'after_title' => '</h3>', 
)); 
    register_sidebar(array( 
    'name' => 'Blog', 
    'before_widget' => '<div id="%1$s" class="widget %2$s">', 
    'after_widget' => '</div>', 
    'before_title' => '<h3 class="widgettitle">', 
    'after_title' => '</h3>', 
)); 
 


/* Nav Animation ********************************************/
// This enqueues the necessary javascript

function nav_animation() {
	
	wp_enqueue_script('superfish', get_template_directory_uri() .'/js/superfish.js', array( 'jquery' ) );
	wp_enqueue_script('hoverintent', get_template_directory_uri() .'/js/hoverIntent.js', array( 'jquery' ) );
	  if ( is_singular() ) wp_enqueue_script('comment-reply');
	};


/* Register Custom Menus ********************************************/
// Register the custom navigation menu, and remove the container div

// This theme uses wp_nav_menu()

register_nav_menus( array(
		'primary' => ( 'Primary Navigation' ),
	) );


function mytheme_nav() {
    if ( function_exists( 'wp_nav_menu' ) )
        wp_nav_menu( 'container_class=menu&fallback_cb=mytheme_nav_fallback' );
    else
        mytheme_nav_fallback();
}
function mytheme_nav_fallback() {
     wp_page_menu('show_home=1&title_li=&depth=1');
}

function my_wp_nav_menu_args( $args = '' )
{
	$args['container'] = false;
	return $args;
} 

add_filter( 'wp_nav_menu_args', 'my_wp_nav_menu_args' );

/* Archive Pagination ********************************************/
// This adds next/previous pagination to the custom Archives page

function my_post_limit($limit) {
	global $paged, $myOffset, $postsperpage;
	if(empty($paged)) {
		$paged = 1;
	}
	$pgstrt = ((intval($paged) -1) * $postsperpage) + $myOffset . ', ';
	$limit = 'LIMIT '.$pgstrt.$postsperpage;
	return $limit;
}

/* Search Highlighting ********************************************/
// This highlights search terms in both titles, excerpts and content

function search_excerpt_highlight() {
	$excerpt = get_the_excerpt();
	$keys = implode('|', explode(' ', get_search_query()));
	$excerpt = preg_replace('/(' . $keys .')/iu', '<strong class="search-highlight">\0</strong>', $excerpt);
	
	echo '<p>' . $excerpt . '</p>';
}


function search_title_highlight() {
	$title = get_the_title();
	$keys = implode('|', explode(' ', get_search_query()));
	$title = preg_replace('/(' . $keys .')/iu', '<strong class="search-highlight">\0</strong>', $title);
	
	echo $title;
}
		
/* Comments Callback ********************************************/
// This code abstracts out comment code and makes the markup editable

function mytheme_comment($comment, $args, $depth) {

	$GLOBALS['comment'] = $comment;
?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
		<div id="comment-<?php comment_ID(); ?>">
			<div class="comment-author vcard">
				<?php echo get_avatar($comment,$size='48' ); ?>
				<div class="commentmetadata">
					<?php printf(('<cite class="fn">%s</cite>'), get_comment_author_link()) ?>
					<div class="comment-date">
						<a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
							<?php printf(('%1$s &bull; %2$s'), get_comment_date(),  get_comment_time()) ?>
						</a>
						<?php edit_comment_link(' {Edit}') ?>
					</div>
				</div>
			</div>
<?php
	if ($comment->comment_approved == '0') {
?>
			<em>Your comment is awaiting moderation.</em>
			<br />
<?php }	comment_text(); ?>
			<div class="reply">
<?php
	comment_reply_link(
		array_merge( $args, array(
			'depth' => $depth, 
			'reply_text' => ('Reply'), 
			'login_text' => ('Log in to reply'),				
			'max_depth' => $args['max_depth'])
		)
	);
?>
			</div>
		</div>
<?php
}
		
		
function comment_add_microid($classes) {
	$c_email=get_comment_author_email();
	$c_url=get_comment_author_url();
	if (!empty($c_email) && !empty($c_url)) {
		$microid = 'microid-mailto+http:sha1:' . sha1(sha1('mailto:'.$c_email).sha1($c_url));
		$classes[] = $microid;
	}
	return $classes;	
}
add_filter('comment_class','comment_add_microid'); 

function mytheme_ping($comment, $args, $depth) {

	$GLOBALS['comment'] = $comment;
?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
		<div id="comment-<?php comment_ID(); ?>" class="ping">					
			<?php printf(('%1$s'), get_comment_date()) ?> :: <?php printf(('<cite>%s</cite>'), get_comment_author_link()) ?>
		</div>
<?php
}



/* Add Theme Support ********************************************/
// This code adds a thumbnail image for each post, automatic feed links, and post formats

add_theme_support( 'automatic-feed-links' );
add_custom_background();


/* Eliminate Spam Comments ********************************************/
// Disables commenting access for spam bots

function check_referrer() {
    if (!isset($_SERVER['HTTP_REFERER']) || $_SERVER['HTTP_REFERER'] == "") {
        wp_die( ('Please enable referrers in your browser, or, if you\'re a spammer, bugger off!') );
    }
}
add_action('check_comment_flood', 'check_referrer');

/* Add Custom Gravatar ********************************************/
// This code lets you select your custom gravatar from your Discussion options page

add_filter( 'avatar_defaults', 'newgravatar' );

function newgravatar ($avatar_defaults) {
    $myavatar = get_template_directory_uri() . '/images/gravatar.png';
    $avatar_defaults[$myavatar] = "Personalized Gravatar";
    return $avatar_defaults;
}

/* Change Excerpt Content ********************************************/
// Replaces what shows up when the excerpt is displayed.

function change_excerpt($excerpt)
{
return str_replace('[...]', '<a class="tiplink" href="'.get_permalink().'">Read More &raquo</a>', $excerpt);
}
add_filter('the_excerpt', 'change_excerpt');

/* Remove WordPress version ********************************************/
// Deletes the version of WordPress being  used to thwart hackers.

function remove_version() {
return '';
}
add_filter('the_generator', 'remove_version');

if ( ! isset( $content_width ) ) $content_width = 565;


?>