<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * e.g., it puts together the home page when no home.php file exists.
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage Cuberta
 * @since cuberta 1.0
 */
get_header();
?>

<main>
    <div class="content">  

        <?php if ( have_posts() ) : ?>

            <?php if ( is_home() && !is_front_page() ) : ?>
                <header>
                    <h1 class="page-title screen-reader-text"><?php esc_html( single_post_title() ); ?></h1>
                </header>
            <?php
            endif;
            // Start the loop.
            while ( have_posts() ) : the_post();

                /*
                 * Include the Post-Format-specific template for the content.
                 * If you want to override this in a child theme, then include a file
                 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                 */
                get_template_part( 'content', get_post_format() );

            // End the loop.
            endwhile;

            // Previous/next page navigation.
            the_posts_pagination( array(
                'prev_text'          => '',
                'next_text'          => '',
                'before_page_number' => '<span class="meta-nav screen-reader-text"></span>',
                'screen_reader_text' => '',
            ) );

        // If no content, include the "No posts found" template.
        else :
            get_template_part( 'content', 'none' );

        endif;
        ?>
    </div>
</main>

<?php get_footer(); ?>