<?php
/*
 * Essential actions
 * since 1.0
 */
 
 
/**
 * @package twentysixteen
 * Converts a HEX value to RGB.
 */
function creative_consulting_hex2rgb( $color ) {
	$color = trim( $color, '#' );

	if ( strlen( $color ) === 3 ) {
		$r = hexdec( substr( $color, 0, 1 ) . substr( $color, 0, 1 ) );
		$g = hexdec( substr( $color, 1, 1 ) . substr( $color, 1, 1 ) );
		$b = hexdec( substr( $color, 2, 1 ) . substr( $color, 2, 1 ) );
	} elseif ( strlen( $color ) === 6 ) {
		$r = hexdec( substr( $color, 0, 2 ) );
		$g = hexdec( substr( $color, 2, 2 ) );
		$b = hexdec( substr( $color, 4, 2 ) );
	} else {
		return array();
	}

	return array(
		'red'   => $r,
		'green' => $g,
		'blue'  => $b,
	);
}



function creative_consulting_do_home_slider(){

	if((is_front_page() || is_home()) && get_theme_mod('slider_in_home_page' , 1)) {
		get_template_part('templates/top', 'slider' );
	}

}
add_action('creative_consulting_home_slider', 'creative_consulting_do_home_slider');

function creative_consulting_do_before_header(){
	get_template_part( 'templates/top', 'notice' ); 
}

add_action('creative_consulting_before_header', 'creative_consulting_do_before_header');


function creative_consulting_do_header(){

		get_template_part( 'templates/contact', 'section' );
		
		do_action('creative_consulting_before_header');
		
		$creative_consulting_header = get_theme_mod('header_layout', 1);
		
		if ($creative_consulting_header == 0) {
			do_action('business_architect_default_header');
			//woocommerce layout
		} else if($creative_consulting_header == 1 && class_exists('WooCommerce')){
			do_action('business_architect_store_header');
			//list layout
		} else if ($creative_consulting_header == 2){
			do_action('business_architect_burger_header');
		} else {
			//default layout			
			do_action('business_architect_default_header');
		}
		
		if(is_front_page()){
			get_template_part( 'templates/top', 'shortcode' );
		}
		


}

add_action('creative_consulting_header', 'creative_consulting_do_header');



/**
 * Theme Breadcrumbs
*/
if( !function_exists('creative_consulting_page_header_breadcrumbs') ):
	function creative_consulting_page_header_breadcrumbs() { 	
		global $post;
		$homeLink = esc_url(home_url());
		$creative_consulting_page_header_layout = get_theme_mod('creative_consulting_page_header_layout', 'creative_consulting_page_header_layout1');
		if($creative_consulting_page_header_layout == 'creative_consulting_page_header_layout1'):
			$breadcrumb_class = 'center-text';	
		else: $breadcrumb_class = 'text-right'; 
		endif;
		
		echo '<ul id="content" class="page-breadcrumb '.esc_attr( $breadcrumb_class ).'">';			
			if (is_home() || is_front_page()) :
					echo '<li><a href="'.esc_url($homeLink).'">'.esc_html__('Home','creative-consulting').'</a></li>';
					    echo '<li class="active">'; echo single_post_title(); echo '</li>';
						else:
						echo '<li><a href="'.esc_url($homeLink).'">'.esc_html__('Home','creative-consulting').'</a></li>';
						if ( is_category() ) {
							echo '<li class="active"><a href="'. esc_url( creative_consulting_page_url() ) .'">' . esc_html__('Archive by category','creative-consulting').' "' . single_cat_title('', false) . '"</a></li>';
						} elseif ( is_day() ) {
							echo '<li class="active"><a href="'. esc_url(get_year_link(esc_attr(get_the_time('Y')))) . '">'. esc_html(get_the_time('Y')) .'</a>';
							echo '<li class="active"><a href="'. esc_url(get_month_link(esc_attr(get_the_time('Y')),esc_attr(get_the_time('m')))) .'">'. esc_html(get_the_time('F')) .'</a>';
							echo '<li class="active"><a href="'. esc_url( creative_consulting_page_url() ) .'">'. esc_html(get_the_time('d')) .'</a></li>';
						} elseif ( is_month() ) {
							echo '<li class="active"><a href="' . esc_url( get_year_link(esc_attr(get_the_time('Y'))) ) . '">' . esc_html(get_the_time('Y')) . '</a>';
							echo '<li class="active"><a href="'. esc_url( creative_consulting_page_url() ) .'">'. esc_html(get_the_time('F')) .'</a></li>';
						} elseif ( is_year() ) {
							echo '<li class="active"><a href="'. esc_url( creative_consulting_page_url() ) .'">'. esc_html(get_the_time('Y')) .'</a></li>';
                        } elseif ( is_single() && !is_attachment() && is_page('single-product') ) {
						if ( get_post_type() != 'post' ) {
							$cat = get_the_category(); 
							$cat = $cat[0];
							echo '<li>';
								echo esc_html( get_category_parents($cat, TRUE, '') );
							echo '</li>';
							echo '<li class="active"><a href="' . esc_url( creative_consulting_page_url() ) . '">'. wp_title( '',false ) .'</a></li>';
						} }  
						elseif ( is_page() && $post->post_parent ) {
							$parent_id  = $post->post_parent;
							$breadcrumbs = array();
							while ($parent_id) {
							$page = get_page($parent_id);
							$breadcrumbs[] = '<li class="active"><a href="' . esc_url(get_permalink($page->ID)) . '">' . esc_html( get_the_title($page->ID)) . '</a>';
							$parent_id  = $page->post_parent;
                            }
							$breadcrumbs = array_reverse($breadcrumbs);
							foreach ($breadcrumbs as $crumb) echo $crumb;
							echo '<li class="active"><a href="' .  esc_url( creative_consulting_page_url()) . '">'. esc_html( get_the_title() ).'</a></li>';
                        }
						elseif( is_search() )
						{
							echo '<li class="active"><a href="' . esc_url( creative_consulting_page_url() ) . '">'. get_search_query() .'</a></li>';
						}
						elseif( is_404() )
						{
							echo '<li class="active"><a href="' . esc_url( creative_consulting_page_url() ) . '">'.esc_html__('Error 404','creative-consulting').'</a></li>';
						}
						else { 
						    echo '<li class="active"><a href="' . esc_url( creative_consulting_page_url() ) . '">'. esc_html( get_the_title() ) .'</a></li>';
						}
					endif;
			echo '</ul>';
        }
endif;


/**
 * Theme Breadcrumbs Url
*/
function creative_consulting_page_url() {
	global $wp;
	$current_url = esc_url(home_url(add_query_arg(array(), $wp->request)));
	
	return $current_url;
}


/*************
 *  Widgets  *
 ************/

/**
 * Registers the new widget to add it to the available widgets
 * @since 1.0.0
 */
function creative_consulting_Search_register_widget() {
	register_widget( 'creative_consulting_Search_Widget' );
}
add_action( 'widgets_init', 'creative_consulting_Search_register_widget' );


/*
 * Post Widget
 */
class creative_consulting_Post_Widget extends WP_Widget {

	/**
	 * Setup the widget options
	 * @since 1.0
	 */
	public function __construct() {
	
		// set widget options
		$options = array(
			'classname'   => 'creative_consulting_Post_Widget', // CSS class name
			'description' => esc_html__( 'Pro- Post Widget.', 'creative-consulting' ),
		);
		
		// instantiate the widget
		parent::__construct( 'creative_consulting_Post_Widget', esc_html__( 'Pro- Post Widget', 'creative-consulting' ), $options );
	}
	
	

	public function widget( $args, $instance ) {
	
		$category = ( ! empty( $instance['category'] ) ) ? strip_tags( $instance['category'] ) : 0;
		$colums = (!empty($instance['colums'])) ? strip_tags($instance['colums']) : "col-md-3 col-sm-3 col-lg-3 col-xs-12";
		
		// get the widget configuration
		$title = "";
		if(isset($instance['title'])) $title = $instance['title'];
		
				
		if ( $title ) {
			echo  "<h2 class='page-title center-text'>".wp_kses_post($title)."</h2>";
		}

		?>
	  <section id="" class="post-widget-content text-center">
		  <div class="row">
			<?php
			$max_items = 20;
			$args =  array(  'post_type' => 'post', 'ignore_sticky_posts' => 1 , 'cat' =>  $category , 'posts_per_page' =>  absint($max_items), 'numberposts' => absint($max_items) , 'orderby' => 'date', 'order' => 'DESC' );

			$page_query = new WP_Query($args);?>
			  <?php while( $page_query->have_posts() ) : $page_query->the_post(); ?>
				<div class="<?php echo esc_attr($colums) ;?>">
				  <div class="center-text post">
					<?php the_post_thumbnail(); ?>				  
					<h2 class="widget-title"><a href="<?php the_permalink();?>"><?php the_title();?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
					<p class="mt-3"><?php $excerpt = wp_trim_words( get_the_excerpt(), 20 ) ; echo wp_kses_post($excerpt); ?></p>
				  	<span><a class="call-to-action" href="<?php the_permalink();?>"><?php esc_html_e('Read More', 'creative-consulting'); ?></a></span>
				  </div>
				</div>
			  <?php endwhile;
			  wp_reset_postdata();
			  ?>
		  </div>
	  </section>
		<?php
		
	}
	

	public function update( $new_instance, $old_instance ) {
	
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title']) : "" ;
		$instance['category'] = ( ! empty( $new_instance['category'] ) ) ? strip_tags( $new_instance['category']) : 0 ;
		$instance['colums'] = ( ! empty( $new_instance['colums'] ) ) ? strip_tags( $new_instance['colums'] ): "" ;
		
		return $instance;
	}
	

	public function form( $instance ) {
	
		$category = ( ! empty( $instance['category'] ) ) ? strip_tags( $instance['category'] ) : 0;
		$title = ( ! empty( $instance['title'] ) ) ? strip_tags( $instance['title'] ) : '';
		$colums = (!empty($instance['colums'])) ? strip_tags($instance['colums']) : "col-md-3 col-sm-3 col-lg-3 col-xs-12";
		

		$args = array( 'orderby' => 'name', 'exclude' => '', 'include' => '', 'parent' => 0 );
		$categories = get_categories( $args );
		$category_code = '';
			if(0==$category){
				$category_code = $category_code.'<option value="0" Selected=selected>'.__( '-Select Category-','creative-consulting').'</option>';
			} else{
				$category_code = $category_code.'<option value="0">'.__( '-Select Category-','creative-consulting').'</option>';
			}
			foreach ( $categories as $cat ) {
				$selected ='';
				if(($cat->term_id)==$category){
					$selected ='Selected=selected';
				}
			$category_code = $category_code.'<option value="'.$cat->term_id.'" '.$selected.' >'.$cat->name.'</option>';
		}
		
		//
		$bootstrap_colums = array(
			"col-md-12 col-sm-12 col-lg-12 col-xs-12" => 1,
			"col-md-6 col-sm-6 col-lg-6 col-xs-12" => 2,
			"col-md-4 col-sm-4 col-lg-4 col-xs-12" => 3,
			"col-md-3 col-sm-3 col-lg-3 col-xs-12" => 4,
			"col-md-2 col-sm-2 col-lg-2 col-xs-12" => 6,
		);	
		

		?>
				
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'creative-consulting' ) ?>:</label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( isset( $instance['title'] ) ? $instance['title'] : '' ); ?>" />
		</p>
		
		
		<p>
		<label for="<?php echo esc_attr($this->get_field_id( 'category' )); ?>"><?php esc_html_e( 'Select the News category:','creative-consulting'  ); ?></label> 
		<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'category' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'category' )); ?>" type="text">
		<?php echo wp_kses_post($category_code); ?>
		</select>
		</p>
		<p>
		<label for="<?php echo esc_attr($this->get_field_id('colums')); ?>"><?php esc_html_e('Number of colums:', 'creative-consulting'); ?></label> 
		<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('colums')); ?>" name="<?php echo esc_attr( $this->get_field_name('colums')); ?>" type="text">
		<?php
		foreach ($bootstrap_colums as $key => $value) {
				if ($key == $colums) {
						echo '<option value="' . esc_attr($key) . '" Selected = selected >' . esc_html( $value) . '</option>';
				}
				else {
						echo '<option value="' . esc_attr($key) . '" >' . esc_html($value) . '</option>';
				}
		}
		?>
		</select>
		</p>

		
		<?php
	}
	
} 


/**
 * Registers the new widget to add it to the available widgets
 * @since 1.0.0
 */
function creative_consulting_Post_register_widget() {
	register_widget( 'creative_consulting_Post_Widget' );
}
add_action( 'widgets_init', 'creative_consulting_Post_register_widget' );



/* search widgets */
class creative_consulting_Search_Widget extends WP_Widget {

	/**
	 * Setup the widget options
	 * @since 1.0
	 */
	public function __construct() {
	
		// set widget options
		$options = array(
			'classname'   => 'creative_consulting_Search_Widget', // CSS class name
			'description' => esc_html__( 'WooCommerce Search [With Categories]', 'creative-consulting' ),
		);
		
		// instantiate the widget
		parent::__construct( 'creative_consulting_Search_Widget', esc_html__( 'Pro- WooCommerce Search Widget', 'creative-consulting' ), $options );
	}
	
	

	public function widget( $args, $instance ) {
		
		// get the widget configuration
		$title = "";
		if(isset($instance['title'])) $title = $instance['title'];
				
		if ( $title ) {
			echo wp_kses_post($args['before_title']) . wp_kses_post($title) . wp_kses_post($args['after_title']);
		}

		?>
		<div class="row">
		<div class="col-sm-12">
			<div class="woo-search">
			  <?php if ( class_exists( 'WooCommerce' ) ) { ?>
			  <div class="header-search-form">
				<form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
				  <select class="header-search-select" name="product_cat">
					<option value="">
					<?php esc_html_e( 'Categories', 'creative-consulting' ); ?>
					</option>
					<?php
									/*
									 * @package envo-ecommerce
									 * @subpackage consultus
									 */
									$args = array(
										'taxonomy'     => 'product_cat',
										'orderby'      => 'date',
										'order'      	=> 'ASC',
										'show_count'   => 1,
										'pad_counts'   => 0,
										'hierarchical' => 1,
										'title_li'     => '',
										'hide_empty'   => 1,
									);
									$categories = get_categories( $args);
									foreach ( $categories as $category ) {
										$option = '<option value="' . esc_attr( $category->category_nicename ) . '">';
										$option .= esc_html( $category->cat_name );
										$option .= ' (' . absint( $category->category_count ) . ')';
										$option .= '</option>';
										echo wp_kses_post($option); 
									}
									?>
				  </select>
				  <input type="hidden" name="post_type" value="product" />
				  <input class="header-search-input" name="s" type="text" placeholder="<?php esc_attr_e( 'Search products...', 'creative-consulting' ); ?>"/>
				  <button class="header-search-button" type="submit"><i class="fa fa-search" aria-hidden="true"></i></button>
				</form>
			  </div>
			  <?php } ?>
			</div>
			</div>
		</div>
		<?php
		
	}
	


	public function update( $new_instance, $old_instance ) {
	
		$instance['title'] = strip_tags( $new_instance['title'] );
		
		return $instance;
	}
	

	public function form( $instance ) {
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'creative-consulting' ) ?>:</label>
			<input type="text" class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( isset( $instance['title'] ) ? $instance['title'] : '' ); ?>" />
		</p>
		
		<?php
	}
	
} 
