<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


/*
 * BEGIN ENQUEUE PARENT ACTION
 * AUTO GENERATED - Do not modify or remove comment markers above or below:
 */
 
if ( ! function_exists( 'business_architect_default_settings' ) ) :

function business_architect_default_settings($param){
	$values = array (	 'background_color'=> '#fff', 
						 'page_background_color'=> '#fff', 
						 'woocommerce_menubar_color'=> '#fff0', 
						 'woocommerce_menubar_text_color'=> '#333333', 
						 'link_color'=>  '#0568bf',
						 'main_text_color' => '#1a1a1a', 
						 'primary_color'=> '#2271b1',
						 'header_bg_color'=> '#fff',
						 'header_text_color'=> '#333333',
						 'footer_bg_color'=> '#01182b',
						 'footer_text_color'=> '#ffffff',
						 'header_contact_social_bg_color'=> '#1e73be',
						 'footer_border' =>'1',
						 'hero_border' =>'1',
						 'header_layout' =>'1',
						 'heading_font' => 'Google Sans', 
						 'body_font' => 'Google Sans',
						 'pre_loader_style' => 1,
						 'pre_loader_enabled' => false					 
				 
					 );
					 
	return $values[$param];
}

endif;

 
if ( !function_exists( 'creative_consulting_locale_css' ) ):
    function creative_consulting_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'creative_consulting_locale_css' );

if ( !function_exists( 'creative_consulting_parent_css' ) ):
    function creative_consulting_parent_css() {
        wp_enqueue_style( 'creative_consulting_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array( 'bootstrap','fontawesome' ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'creative_consulting_parent_css', 10 );


if ( class_exists( 'WP_Customize_Control' ) ) {

	require get_template_directory() .'/inc/color-picker/alpha-color-picker.php';
}


/* common codes */
require get_stylesheet_directory() .'/inc/functions.php';


function creative_consulting_wp_body_open(){
	do_action( 'wp_body_open' );
}

if ( ! function_exists( 'creative_consulting_the_custom_logo' ) ) :
	/**
	 * Displays the optional custom logo.
	 */
	function creative_consulting_the_custom_logo() {
		if ( function_exists( 'the_custom_logo' ) ) {
			the_custom_logo();
		}
	}
endif;

/**
 * @since 1.0.0
 * add home link.
 */
function creative_consulting_nav_wrap() {
  $wrap  = '<ul id="%1$s" class="%2$s">';
  $wrap .= '<li class="hidden-xs"><a href="/"><i class="fa fa-home"></i></a></li>';
  $wrap .= '%3$s';
  $wrap .= '</ul>';
  return $wrap;
}


/* 
 * add customizer settings 
 */
add_action( 'customize_register', 'creative_consulting_customize_register' );  
function creative_consulting_customize_register( $wp_customize ) {


	// banner image
	$wp_customize->add_setting( 'banner_image' , 
		array(
			'default' 		=> '',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize , 'banner_image' ,
		array(
			'label'          => __( 'Banner Image', 'creative-consulting' ),
			'description'	=> __('Upload banner image', 'creative-consulting'),
			'settings'  => 'banner_image',
			'section'        => 'theme_header',
		))
	);
	
	$wp_customize->add_setting('banner_link' , array(
		'default'    => '#',
		'sanitize_callback' => 'esc_url_raw',
	));
	
	
	$wp_customize->add_control('banner_link' , array(
		'label' => __('Banner Link', 'creative-consulting' ),
		'section' => 'theme_header',
		'type'=> 'url',
	) );
	

	//breadcrumb 

	$wp_customize->add_section( 'breadcrumb_section' , array(
		'title'      => __( 'Header Breadcrumb', 'creative-consulting' ),
		'priority'   => 3,
		'panel' => 'theme_options',
	) );


	$wp_customize->add_setting( 'breadcrumb_enable' , array(
		'default'    => false,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'business_architect_sanitize_checkbox',
	));

	$wp_customize->add_control('breadcrumb_enable' , array(
		'label' => __('Enable | Disable Breadcrumb','creative-consulting' ),
		'section' => 'breadcrumb_section',
		'type'=> 'checkbox',
	));		
	
	// loader
	$wp_customize->add_section( 'pre_loader' , array(
		'description' => __( 'Add a preloader', 'creative-consulting' ),
		'title'      => __( 'Preloader', 'creative-consulting' ),
		'priority'   => 2,
		'panel' => 'theme_options',
	) );
	
	$wp_customize->add_setting( 'pre_loader_enabled' , array(
		'default'    => false,
		'sanitize_callback' => 'business_architect_sanitize_checkbox',
	));

	$wp_customize->add_control('pre_loader_enabled' , array(
		'label' => __('Enable | Disable Preloader [If prealoader not stopping due to js errors, Disable Preloader.]', 'creative-consulting' ),
		'section' => 'pre_loader',
		'type'=> 'checkbox',
	));		
			
	
}



/*
 * Preloader
 * since 1.0
 */

function creative_consulting_add_preloader() {

	if (get_theme_mod('pre_loader_enabled' , false)){
		echo '<div class="preloader-wrap"><div class="sk-chase">
					  <div class="sk-chase-dot"></div>
					  <div class="sk-chase-dot"></div>
					  <div class="sk-chase-dot"></div>
					  <div class="sk-chase-dot"></div>
					  <div class="sk-chase-dot"></div>
					  <div class="sk-chase-dot"></div>
					</div></div>';
	}

}


add_action( 'wp_body_open', 'creative_consulting_add_preloader' );


function creative_consulting_admin_css_add_style() {  



wp_enqueue_style('admin-css-style', get_bloginfo('stylesheet_directory').'/css/admin.css');



}



add_action('admin_enqueue_scripts', 'creative_consulting_admin_css_add_style');