<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Creative Blogger
 */

get_header(); ?>
<?php
    $creative_blogger_post_date = get_the_date();

    $creative_blogger_author_name = get_the_author();
?>

<div id="content" >

<?php
    $creative_blogger_slider = get_theme_mod('creative_blogger_slider', false);
    $creative_blogger_slider_cat = get_theme_mod('creative_blogger_slider_cat', false);
    if ($creative_blogger_slider || $creative_blogger_slider_cat) { ?>
    <section id="slider-cat">
      <div class="slideimg py-4">
        <div class="container sliderbox">
            <div class="row">   
                <div class="col-xl-7 col-lg-7 col-md-12 col-12">
                    <div class="owl-carousel m-0 owl-theme">
                        <?php
                        $creative_blogger_slider_cat = get_theme_mod('creative_blogger_slider_category', ''); 
                        if ($creative_blogger_slider_cat && $creative_blogger_slider_cat !== 'select') {
                            $creative_blogger_page_query = new WP_Query(
                                array(
                                    'category_name' => esc_attr($creative_blogger_slider_cat),
                                    'posts_per_page' => -1, 
                                )
                            );
                            while ($creative_blogger_page_query->have_posts()) : $creative_blogger_page_query->the_post(); ?>
                                <div class="imagebox">
                                    <div class="slider-overlay"></div>
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full');
                                    } else { ?>
                                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider.png" alt="<?php echo esc_attr( 'image', 'creative-blogger'); ?>"/>
                                    <?php } ?>
                                    <div class="text-content">
                                        <?php $creative_blogger_latest_category = creative_blogger_get_latest_category(get_the_ID());
                                        if ($creative_blogger_latest_category) {
                                            echo '<a class="post-categories" href="' . esc_url(get_category_link($creative_blogger_latest_category->term_id)) . '">' . esc_html($creative_blogger_latest_category->name) . '</a>';
                                        } ?>
                                        <h1 class="mt-3"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                        <div class="post-meta">
                                            <div class="post-meta-author"> 
                                                <span class="me-2"><?php esc_html_e('By', 'creative-blogger'); ?></span><a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
                                            </div>
                                            <div class="post-meta-date">
                                                <i class="fa-regular fa-calendar-days"></i><?php echo esc_html($creative_blogger_post_date); ?>
                                            </div>
                                            <div class="post-meta-comments"> 
                                                <i class="fa-regular fa-message"></i><?php comments_number(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; 
                            wp_reset_postdata();
                        } else {
                            echo '<p>' . esc_html__('No posts found in the selected category.', 'creative-blogger') . '</p>';
                        }
                        ?>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-5 col-md-12 col-12 feature-main-box">
                    <?php
                        for ($creative_blogger_i=1; $creative_blogger_i <= 3; $creative_blogger_i++) {
                        $creative_blogger_postData=  get_theme_mod('creative_blogger_select_posts'.$creative_blogger_i);
                        if($creative_blogger_postData){ ?>
                        <div class="feature-box">
                            <?php
                            $args = array(
                              'p' => esc_html($creative_blogger_postData ,'creative-blogger'),
                              'posts_per_page' => 1,
                              'post_type' => 'post'
                            );
                            $query = new WP_Query( $args );
                            if ( $query->have_posts() ) :
                              while ( $query->have_posts() ) : $query->the_post(); ?>
                                <div class="row">
                                    <div class="col-xl-5 col-lg-5 col-md-5 align-self-center">
                                        <div class="blog-img">
                                        <div class="post-slider-img"></div>
                                            <?php if (has_post_thumbnail()) {
                                                the_post_thumbnail('full');
                                            } else { ?>
                                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/dummy-post.png" alt="<?php echo esc_attr( 'image', 'creative-blogger'); ?>"/>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="col-xl-7 col-lg-5 col-md-7 align-self-center">
                                        <div class="blog-content">
                                            <?php $creative_blogger_latest_category = creative_blogger_get_latest_category(get_the_ID());
                                                if ($creative_blogger_latest_category) {
                                                    echo '<a class="post-categories" href="' . esc_url(get_category_link($creative_blogger_latest_category->term_id)) . '">' . esc_html($creative_blogger_latest_category->name) . '</a>';
                                            } ?>
                                            <div class="post-title">
                                                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?><span class="screen-reader-text"><?php the_title(); ?></span></a></h2>
                                            </div>
                                            <div class="blog-date">
                                                <i class="fa-regular fa-calendar-days"></i><?php echo esc_html($creative_blogger_post_date); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                                wp_reset_postdata();
                            endif; ?>
                        </div>
                    <?php }} ?>
                </div>
            </div> 
        </div>
      </div>
    </section>
<?php } ?>

<!-- Trending Section -->
<?php
$creative_blogger_hide_trending_section = get_theme_mod('creative_blogger_disabled_trending_section', false);
if ($creative_blogger_hide_trending_section) {
?>
    <section id="trending_section" class="my-5 text-left">
        <div class="container">
            <div class="blog_bx text-left">
                <?php if (get_theme_mod('creative_blogger_trending_title') != "") { ?>
                    <h3 class="trending-title mb-1 text-capitalize"><?php echo esc_html(get_theme_mod('creative_blogger_trending_title', 'creative-blogger')); ?></h3>
                <?php } ?>
                <?php if (get_theme_mod('creative_blogger_trending_text') != "") { ?>
                    <p class="mb-3 text-capitalize trending-text"><?php echo esc_html(get_theme_mod('creative_blogger_trending_text', 'creative-blogger')); ?></p>
                <?php } ?>
            </div>
            <div class="owl-carousel">
                <?php
                $args = array(
                    'taxonomy'   => 'category',
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => 0,
                    'parent'     => 0
                );
                $creative_blogger_post_categories = get_terms($args);
                $creative_blogger_count = count($creative_blogger_post_categories);
                $creative_blogger_colors = ['#2A67F7', '#EF4444', '#EAB308', '#EC4899'];
                $creative_blogger_counter = 0;

                if ($creative_blogger_count > 0) {
                    foreach ($creative_blogger_post_categories as $creative_blogger_post_category) {
                        $creative_blogger_post_cat_id = $creative_blogger_post_category->term_id;
                        $creative_blogger_cat_link = get_category_link($creative_blogger_post_cat_id);
                        $creative_blogger_thumbnail_id = get_term_meta($creative_blogger_post_cat_id, 'category_image', true); // Get Category Thumbnail
                        $creative_blogger_post_count = $creative_blogger_post_category->count; // Get post count
                        $creative_blogger_color = $creative_blogger_colors[$creative_blogger_counter % count($creative_blogger_colors)];
                        $creative_blogger_counter++;

                        if ($creative_blogger_post_category->parent == 0) { ?>
                            <div class="cat-box" style="<?php echo !$creative_blogger_thumbnail_id ? 'background-color: #e3e0e0;' : ''; ?>">
                                <?php
                                if ($creative_blogger_thumbnail_id) {
                                    echo '<img class="thumb_img" src="' . esc_url($creative_blogger_thumbnail_id) . '" alt="" />';
                                } else {
                                    echo '<img class="thumb_img" src="' . esc_url(get_template_directory_uri() . '/images/dummy.png') . '" alt="Default Image" />';
                                }
                                ?>                               
                                <div class="articles p-3">
                                    <div class="row">
                                        <div class="col-xl-4 col-lg-4 col-md-4 col-4 align-self-center pe-0">
                                            <span style="background-color: <?php echo esc_attr($creative_blogger_color); ?>;"><?php esc_html_e('#1', 'creative-blogger'); ?></span>
                                        </div>
                                        <div class="col-xl-8 col-lg-8 col-md-8 col-8 align-self-center">
                                            <a href="<?php echo esc_url(get_term_link($creative_blogger_post_category)); ?>">
                                                <?php echo esc_html($creative_blogger_post_category->name); ?>
                                            </a>
                                            <p class="mb-0"><?php echo esc_html($creative_blogger_post_count) . ' Articles'; ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    }
                } ?>
            </div>
        </div>
    </section>
<?php } ?>

</div>
<?php get_footer(); ?>
