<div class="theme-offer">
   <?php
        // Check if the demo import has been completed
        $creative_blogger_demo_import_completed = get_option('creative_blogger_demo_import_completed', false);

        // If the demo import is completed, display the "View Site" button
        if ($creative_blogger_demo_import_completed) {
            echo '<br>';
            echo '<div class="success">Demo Import Successful</div>';
            echo '<br>';
            echo '<hr>';
            echo '<br>';
            echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'creative-blogger' ) . '</span>';
            echo '<br>';
            echo '<br>';
            echo '<br>';
            echo '<div class="view-site-btn">';
            echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
            echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
            echo '</div>';
        }
     // POST and update the customizer and other related data of Creative Blogger
    if ( isset( $_POST['submit'] ) ) {
        echo '<div class="plugin-notice">';
            // Check if Classic Blog Grid plugin is installed
            if (!is_plugin_active('classic-blog-grid/classic-blog-grid.php')) {
                // Plugin slug and file path for Classic Blog Grid
                $creative_blogger_plugin_slug = 'classic-blog-grid';
                $creative_blogger_plugin_file = 'classic-blog-grid/classic-blog-grid.php';
            
                // Check if Classic Blog Grid is installed and activated
                if ( ! is_plugin_active( $creative_blogger_plugin_file ) ) {
            
                    // Check if Classic Blog Grid is installed
                    $creative_blogger_installed_plugins = get_plugins();
                    if ( ! isset( $creative_blogger_installed_plugins[ $creative_blogger_plugin_file ] ) ) {
            
                        // Include necessary files to install plugins
                        include_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
                        include_once( ABSPATH . 'wp-admin/includes/file.php' );
                        include_once( ABSPATH . 'wp-admin/includes/misc.php' );
                        include_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
            
                        // Download and install Classic Blog Grid
                        $creative_blogger_upgrader = new Plugin_Upgrader();
                        $creative_blogger_upgrader->install( 'https://downloads.wordpress.org/plugin/classic-blog-grid.latest-stable.zip' );
                    }
            
                    // Activate the Classic Blog Grid plugin after installation (if needed)
                    activate_plugin( $creative_blogger_plugin_file );
                }
            }
        echo '</div>';
        // ------- Create Main Menu --------
        $creative_blogger_menuname = 'Primary Menu';
        $creative_blogger_bpmenulocation = 'primary';
        $creative_blogger_menu_exists = wp_get_nav_menu_object( $creative_blogger_menuname );
    
        if (!$creative_blogger_menu_exists) {
            // Create a new menu
            $creative_blogger_menu_id = wp_create_nav_menu($creative_blogger_menuname);

            // Define pages to be created
            $creative_blogger_pages = array(
                'home' => array(
                    'title' => 'Home',
                    'template' => '/templates/template-home-page.php'
                ),
                'posts' => array(
                    'title' => 'Posts',
                    'content' => ''
                ),
                'mega-menu' => array(
                    'title' => 'Mega Menu',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'pages' => array(
                    'title' => 'Pages',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'lifestyle' => array(
                    'title' => 'Lifestyle',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'gadgets' => array(
                    'title' => 'Gadgets',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
                'contact' => array(
                    'title' => 'contact',
                    'content' => '<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.</p>'
                ),
            );

            $creative_blogger_page_ids = array();

            // Loop through the pages and create them if they don’t exist
            foreach ($creative_blogger_pages as $creative_blogger_slug => $creative_blogger_data) {
                $creative_blogger_existing_page = get_page_by_path($creative_blogger_slug);

                if ($creative_blogger_existing_page) {
                    // If the page already exists, use its ID
                    $creative_blogger_page_id = $creative_blogger_existing_page->ID;
                } else {
                    // Create a new page
                    $creative_blogger_page_data = array(
                        'post_type'    => 'page',
                        'post_title'   => $creative_blogger_data['title'],
                        'post_content' => isset($creative_blogger_data['content']) ? $creative_blogger_data['content'] : '',
                        'post_status'  => 'publish',
                        'post_author'  => get_current_user_id(), // Set author dynamically
                        'post_name'    => $creative_blogger_slug,
                    );

                    $creative_blogger_page_id = wp_insert_post($creative_blogger_page_data);

                    // Assign custom page template if specified
                    if (!empty($creative_blogger_data['template'])) {
                        update_post_meta($creative_blogger_page_id, '_wp_page_template', $creative_blogger_data['template']);
                    }
                }

                // Store the page IDs
                $creative_blogger_page_ids[$creative_blogger_slug] = $creative_blogger_page_id;
            }

            // Set homepage and blog page
            update_option('page_for_posts', $creative_blogger_page_ids['posts']);
            update_option('page_on_front', $creative_blogger_page_ids['home']);
            update_option('show_on_front', 'page');

            // Define menu items
            $creative_blogger_menu_items = array(
                'home',
                'posts',
                'mega-menu',
                'pages',
                'lifestyle',
                'gadgets',
                'contact'
            );

            // Add menu items dynamically
            foreach ($creative_blogger_menu_items as $creative_blogger_slug) {
                wp_update_nav_menu_item($creative_blogger_menu_id, 0, array(
                    'menu-item-title' => esc_html($creative_blogger_pages[$creative_blogger_slug]['title']),
                    'menu-item-url' => get_permalink($creative_blogger_page_ids[$creative_blogger_slug]),
                    'menu-item-status' => 'publish',
                    'menu-item-object-id' => $creative_blogger_page_ids[$creative_blogger_slug],
                    'menu-item-object' => 'page',
                    'menu-item-type' => 'post_type',
                ));
            }

            // Assign menu to theme location
            $creative_blogger_locations = get_theme_mod('nav_menu_locations', array());
            $creative_blogger_locations[$creative_blogger_bpmenulocation] = $creative_blogger_menu_id;
            set_theme_mod('nav_menu_locations', $creative_blogger_locations);
        }

        //Logo
        set_theme_mod( 'creative_blogger_the_custom_logo', esc_url( get_template_directory_uri().'/images/Logo.png'));

        //Topbar Section
        set_theme_mod( 'creative_blogger_topbar_enable', true);
        set_theme_mod( 'creative_blogger_follow_us_text', 'Follow Us');
        set_theme_mod( 'creative_blogger_addvertise_text', 'Advertisement');
        set_theme_mod( 'creative_blogger_about_text', 'About');
        set_theme_mod( 'creative_blogger_contact_text', 'Contact');

        //Header Section
        set_theme_mod( 'creative_blogger_middle_header_img', esc_url( get_template_directory_uri().'/images/header.png'));
        set_theme_mod( 'creative_blogger_discount_text', '60% OFF');
        set_theme_mod( 'creative_blogger_img_text', 'Kitchen Appliances');
        set_theme_mod( 'creative_blogger_header_btn_text', 'Shop Now');
        set_theme_mod( 'creative_blogger_header_btn_url', '#');
        set_theme_mod( 'creative_blogger_bookmark_link', '#');
        set_theme_mod( 'creative_blogger_subscribe_link', '#');
        set_theme_mod( 'creative_blogger_admin_img', esc_url( get_template_directory_uri().'/images/account.png'));
        set_theme_mod( 'creative_blogger_image_link', '#');

        // Helper function to download and set featured image for a post
        function creative_blogger_set_featured_image( $creative_blogger_post_id, $creative_blogger_image_url ) {
            $creative_blogger_upload_dir = wp_upload_dir();
            $creative_blogger_response = wp_remote_get( $creative_blogger_image_url );

            if ( is_wp_error( $creative_blogger_response ) ) {
                return false;
            }

            $creative_blogger_image_data = wp_remote_retrieve_body( $creative_blogger_response );
            if ( empty( $creative_blogger_image_data ) ) {
                return false;
            }

            $creative_blogger_image_name = basename( $creative_blogger_image_url );
            $creative_blogger_unique_file_name = wp_unique_filename( $creative_blogger_upload_dir['path'], $creative_blogger_image_name );
            $creative_blogger_file_path = $creative_blogger_upload_dir['path'] . '/' . $creative_blogger_unique_file_name;

            global $wp_filesystem;
            if ( empty( $wp_filesystem ) ) {
                require_once ABSPATH . 'wp-admin/includes/file.php';
                WP_Filesystem();
            }

            $wp_filesystem->put_contents( $creative_blogger_file_path, $creative_blogger_image_data );

            $creative_blogger_file_type = wp_check_filetype( $creative_blogger_unique_file_name, null );
            $creative_blogger_attachment = array(
                'post_mime_type' => $creative_blogger_file_type['type'],
                'post_title'     => sanitize_file_name( $creative_blogger_unique_file_name ),
                'post_content'   => '',
                'post_status'    => 'inherit',
            );

            $creative_blogger_attach_id = wp_insert_attachment( $creative_blogger_attachment, $creative_blogger_file_path, $creative_blogger_post_id );

            require_once ABSPATH . 'wp-admin/includes/image.php';
            $creative_blogger_attach_data = wp_generate_attachment_metadata( $creative_blogger_attach_id, $creative_blogger_file_path );
            wp_update_attachment_metadata( $creative_blogger_attach_id, $creative_blogger_attach_data );

            set_post_thumbnail( $creative_blogger_post_id, $creative_blogger_attach_id );

            return true;
        }

        // Slider Section: Enable slider and create category
        set_theme_mod( 'creative_blogger_slider', true );

        $creative_blogger_slider_cat_id = wp_create_category( 'SPORTS' );
        $creative_blogger_slider_cat_slug = get_category( $creative_blogger_slider_cat_id )->slug;
        set_theme_mod( 'creative_blogger_slider_category', $creative_blogger_slider_cat_slug );

        // Slider posts titles
        $creative_blogger_slider_titles = [
            'Pathways squads to play Wentworthville trial',
            'Training Schedule Announced for New Recruits',
            'Coach Discusses Season Goals in Interview',
        ];        

        $creative_blogger_slider_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s.';

        for ( $creative_blogger_i = 0; $creative_blogger_i < 3; $creative_blogger_i++ ) {
            $creative_blogger_post_data = [
                'post_title'    => wp_strip_all_tags( $creative_blogger_slider_titles[ $creative_blogger_i ] ),
                'post_content'  => $creative_blogger_slider_content,
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => [ $creative_blogger_slider_cat_id ],
            ];

            $creative_blogger_post_id = wp_insert_post( $creative_blogger_post_data );
            if ( ! is_wp_error( $creative_blogger_post_id ) ) {
                $creative_blogger_image_url = get_stylesheet_directory_uri() . '/images/slider' . ( $creative_blogger_i + 1 ) . '.png';
                creative_blogger_set_featured_image( $creative_blogger_post_id, $creative_blogger_image_url );
            }
        }

        // Trending Topics Section
        set_theme_mod( 'creative_blogger_disabled_trending_section', true );
        set_theme_mod( 'creative_blogger_trending_title', 'Top Trending Topics' );
        set_theme_mod( 'creative_blogger_trending_text', 'Discover 233 Topics' );

        // Create demo posts 
        $creative_blogger_demo_posts = [
            1 => ['title' => 'Delicious Street Foods You Must Try', 'image' => 'food.png', 'category' => 'Food'],
            2 => ['title' => 'Top 5 Tech Gadgets in 2025', 'image' => 'technology.png', 'category' => 'Technology'],
            3 => ['title' => 'Exploring the Hidden Gems of Europe', 'image' => 'travel.png', 'category' => 'Travel'],
        ];        

        foreach ( $creative_blogger_demo_posts as $creative_blogger_index => $creative_blogger_data ) {
            $creative_blogger_cat_id = wp_create_category( $creative_blogger_data['category'] );

            $creative_blogger_post_id = wp_insert_post( [
                'post_title'    => wp_strip_all_tags( $creative_blogger_data['title'] ),
                'post_content'  => $creative_blogger_slider_content,
                'post_status'   => 'publish',
                'post_type'     => 'post',
                'post_category' => [ $creative_blogger_cat_id ],
            ] );

            if ( ! is_wp_error( $creative_blogger_post_id ) ) {
                $creative_blogger_image_url = get_stylesheet_directory_uri() . '/images/' . $creative_blogger_data['image'];
                creative_blogger_set_featured_image( $creative_blogger_post_id, $creative_blogger_image_url );
                set_theme_mod( 'creative_blogger_select_posts' . $creative_blogger_index, $creative_blogger_post_id );
            }
        }

        function creative_blogger_create_categories_and_posts_with_images() {
            $creative_blogger_categories = [
                'Garden'     => ['description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'post_image' => 'garden.png', 'image' => get_stylesheet_directory_uri() . '/images/garden.png'],
                'Jewelry'    => ['description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'post_image' => 'jewelry.png', 'image' => get_stylesheet_directory_uri() . '/images/jewelry.png'],
                'Industrial' => ['description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'post_image' => 'industrial.png', 'image' => get_stylesheet_directory_uri() . '/images/industrial.png'],
                'Tools'      => ['description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'post_image' => 'tools.png', 'image' => get_stylesheet_directory_uri() . '/images/tools.png'],
            ];

            $creative_blogger_post_content = 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.';

            foreach ( $creative_blogger_categories as $creative_blogger_name => $creative_blogger_data ) {
                $creative_blogger_term = term_exists( $creative_blogger_name, 'category' );

                if ( ! $creative_blogger_term ) {
                    $creative_blogger_term = wp_insert_term( $creative_blogger_name, 'category', [ 'description' => $creative_blogger_data['description'] ] );
                }

                if ( ! is_wp_error( $creative_blogger_term ) ) {
                    $creative_blogger_cat_id = is_array( $creative_blogger_term ) ? $creative_blogger_term['term_id'] : $creative_blogger_term;

                    // Save category image URL in term meta
                    update_term_meta( $creative_blogger_cat_id, 'category_image', $creative_blogger_data['image'] );

                    $creative_blogger_post_id = wp_insert_post( [
                        'post_title'    => wp_strip_all_tags( $creative_blogger_name ),
                        'post_content'  => $creative_blogger_post_content,
                        'post_status'   => 'publish',
                        'post_type'     => 'post',
                        'post_category' => [ $creative_blogger_cat_id ],
                    ] );

                    if ( ! is_wp_error( $creative_blogger_post_id ) ) {
                        $creative_blogger_image_url = get_stylesheet_directory_uri() . '/images/' . $creative_blogger_data['post_image'];
                        creative_blogger_set_featured_image( $creative_blogger_post_id, $creative_blogger_image_url );
                    }
                }
            }
        }

        // Call the function during demo import or setup
        creative_blogger_create_categories_and_posts_with_images();

        // Show success message and the "View Site" button
        update_option('creative_blogger_demo_import_completed', true);
        echo '<br>';
        echo '<div class="success">Demo Import Successful</div>';
        echo '<br>';
        echo '<hr>';
        echo '<br>';
        echo '<span>' . esc_html__( 'You can now visit your site or customize it further.', 'creative-blogger' ) . '</span>';
        echo '<br>';
    }
     ?>
    <ul>
        <li>
        <?php 
        // Check if the form is submitted
        if ( !isset( $_POST['submit'] ) ) : ?>
            <!-- Show demo importer form only if it's not submitted -->
            <?php if (!get_option('creative_blogger_demo_import_completed')) : ?>
                <span><?php echo esc_html( 'Click on the below content to get demo content installed.', 'creative-blogger' ); ?></span>
                <br><br>
                <hr><br>
                <b class="note"><?php echo esc_html('Note :', 'creative-blogger' ); ?></b><br><br>
                <small><b><?php echo esc_html('Please take a backup if your website is already live with data. This importer will overwrite existing data.', 'creative-blogger' ); ?></b></small><br><br>
                <form id="demo-importer-form" action="" method="POST" onsubmit="return runDemoImport();">
                    <input type="submit" name="submit" value="<?php echo esc_attr('Run Importer','creative-blogger'); ?>" class="button button-primary button-large">
                </form>
                <script type="text/javascript">
                    function runDemoImport() {
                        if (confirm('Do you really want to do this?')) {
                            document.getElementById('demo-import-loader').style.display = 'block';
                            return true;
                        }
                        return false;
                    }
                </script>
             <?php endif; ?>
         <?php 
        endif; 

        // Show "View Site" button after form submission
        if ( isset( $_POST['submit'] ) ) {
        echo '<div class="view-site-btn">';
        echo '<a href="' . esc_url(home_url()) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">View Site</a>';
        echo '<a href="' . esc_url( admin_url('customize.php') ) . '" class="button button-primary button-large" style="margin-top: 10px;" target="_blank">Customize Demo Content</a>';
        echo '</div>';
        }
        ?>
        </li>
    </ul>
 </div>