<?php
/**
 * Creative Blogger Theme Customizer
 *
 * @package Creative Blogger
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function creative_blogger_customize_register( $wp_customize ) {

	function creative_blogger_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('creative-blogger-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	// Enable / Disable Logo
	$wp_customize->add_setting('creative_blogger_logo_enable',array(
		'default' => true,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_logo_enable', array(
		'settings' => 'creative_blogger_logo_enable',
		'section'   => 'title_tagline',
		'label'     => __('Enable Logo','creative-blogger'),
		'type'      => 'checkbox'
	));

	//Logo
    $wp_customize->add_setting('creative_blogger_logo_width', array(
        'default' => '',
        'transport' => 'refresh',
        'sanitize_callback' => 'creative_blogger_sanitize_integer'
    ));
    $wp_customize->add_control(new Creative_Blogger_Slider_Custom_Control($wp_customize, 'creative_blogger_logo_width', array(
    	'label'          => __( 'Logo Width', 'creative-blogger'),
        'section' => 'title_tagline',
        'settings' => 'creative_blogger_logo_width',
        'input_attrs' => array(
            'step' => 1,
            'min' => 0,
            'max' => 300,
        ),
    )));

	// color site title
	$wp_customize->add_setting('creative_blogger_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_sitetitle_color', array(
	   'settings' => 'creative_blogger_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('creative_blogger_title_enable',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_title_enable', array(
	   'settings' => 'creative_blogger_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','creative-blogger'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('creative_blogger_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_sitetagline_color', array(
	   'settings' => 'creative_blogger_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('creative_blogger_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_tagline_enable', array(
	   'settings' => 'creative_blogger_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','creative-blogger'),
	   'type'      => 'checkbox'
	));
	
	// woocommerce section
	$wp_customize->add_section('creative_blogger_woocommerce_page_settings', array(
		'title'    => __('WooCommerce Page Settings', 'creative-blogger'),
		'priority' => null,
		'panel'    => 'woocommerce',
	));

	$wp_customize->add_setting('creative_blogger_shop_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_shop_page_sidebar',array(
		'type' => 'checkbox',
		'label' => __(' Check To Enable Shop page sidebar','creative-blogger'),
		'section' => 'creative_blogger_woocommerce_page_settings',
	));

    // shop page sidebar alignment
    $wp_customize->add_setting('creative_blogger_shop_page_sidebar_position', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'creative_blogger_sanitize_choices',
	));
	$wp_customize->add_control('creative_blogger_shop_page_sidebar_position',array(
		'type'           => 'radio',
		'label'          => __('Shop Page Sidebar', 'creative-blogger'),
		'section'        => 'creative_blogger_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'creative-blogger'),
			'Right Sidebar' => __('Right Sidebar', 'creative-blogger'),
		),
	));	 

	$wp_customize->add_setting('creative_blogger_wooproducts_nav',array(
		'default' => 'Yes',
		'sanitize_callback'	=> 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_wooproducts_nav',array(
		'type' => 'select',
		'label' => __('Shop Page Products Navigation','creative-blogger'),
		'choices' => array(
			 'Yes' => __('Yes','creative-blogger'),
			 'No' => __('No','creative-blogger'),
		 ),
		'section' => 'creative_blogger_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'creative_blogger_single_page_sidebar',array(
		'default' => false,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
    ));
    $wp_customize->add_control('creative_blogger_single_page_sidebar',array(
    	'type' => 'checkbox',
       	'label' => __('Check To Enable Single Product Page Sidebar','creative-blogger'),
		'section' => 'creative_blogger_woocommerce_page_settings'
    ));

	// single product page sidebar alignment
    $wp_customize->add_setting('creative_blogger_single_product_page_layout', array(
		'default'           => 'Right Sidebar',
		'sanitize_callback' => 'creative_blogger_sanitize_choices',
	));
	$wp_customize->add_control('creative_blogger_single_product_page_layout',array(
		'type'           => 'radio',
		'label'          => __('Single product Page Sidebar', 'creative-blogger'),
		'section'        => 'creative_blogger_woocommerce_page_settings',
		'choices'        => array(
			'Left Sidebar'  => __('Left Sidebar', 'creative-blogger'),
			'Right Sidebar' => __('Right Sidebar', 'creative-blogger'),
		),
	));

	$wp_customize->add_setting('creative_blogger_related_product_enable',array(
		'default' => true,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_related_product_enable',array(
		'type' => 'checkbox',
		'label' => __('Check To Enable Related product','creative-blogger'),
		'section' => 'creative_blogger_woocommerce_page_settings',
	));

	$wp_customize->add_setting( 'creative_blogger_woo_product_img_border_radius', array(
        'default'              => '0',
        'transport'            => 'refresh',
        'sanitize_callback'    => 'creative_blogger_sanitize_integer'
    ));
    $wp_customize->add_control(new Creative_Blogger_Slider_Custom_Control( $wp_customize, 'creative_blogger_woo_product_img_border_radius',array(
		'label'	=> esc_html__('Woo Product Img Border Radius','creative-blogger'),
		'section'=> 'creative_blogger_woocommerce_page_settings',
		'settings'=>'creative_blogger_woo_product_img_border_radius',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

    // Add a setting for number of products per row
    $wp_customize->add_setting('creative_blogger_products_per_row', array(
	    'default'   => '4',
	    'transport' => 'refresh',
	    'sanitize_callback' => 'creative_blogger_sanitize_integer'  
    ));
    $wp_customize->add_control('creative_blogger_products_per_row', array(
	   'label'    => __('Woo Products Per Row', 'creative-blogger'),
	   'section'  => 'creative_blogger_woocommerce_page_settings',
	   'settings' => 'creative_blogger_products_per_row',
	   'type'     => 'select',
	   'choices'  => array(
		      '2' => '2',
		'      3' => '3',
		      '4' => '4',
	  ),
    ));

	// Add a setting for the number of products per page
	$wp_customize->add_setting('creative_blogger_products_per_page', array(
		'default'   => '9',
		'transport' => 'refresh',
		'sanitize_callback' => 'creative_blogger_sanitize_integer'
	));
	$wp_customize->add_control('creative_blogger_products_per_page', array(
		'label'    => __('Woo Products Per Page', 'creative-blogger'),
		'section'  => 'creative_blogger_woocommerce_page_settings',
		'settings' => 'creative_blogger_products_per_page',
		'type'     => 'number',
		'input_attrs' => array(
			'min'  => 1,
			'step' => 1,
		),
	));	

	$wp_customize->add_setting('creative_blogger_product_sale_position',array(
		'default' => 'Left',
		'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_product_sale_position',array(
		'type' => 'radio',
		'label' => __('Product Sale Position','creative-blogger'),
		'section' => 'creative_blogger_woocommerce_page_settings',
		'choices' => array(
			'Left' => __('Left','creative-blogger'),
			'Right' => __('Right','creative-blogger'),
		),
	) );  

	//Theme Options
	$wp_customize->add_panel( 'creative_blogger_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'creative-blogger' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('creative_blogger_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','creative-blogger'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','creative-blogger'),
		'priority'	=> 1,
		'panel' => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_preloader',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_preloader', array(
	   'section'   => 'creative_blogger_site_layoutsec',
	   'label'	=> __('Check to Show preloader','creative-blogger'),
	   'type'      => 'checkbox'
 	));		

	$wp_customize->add_setting('creative_blogger_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_box_layout', array(
	   'section'   => 'creative_blogger_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','creative-blogger'),
	   'type'      => 'checkbox'
 	));

	// Add Settings and Controls for Page Layout
    $wp_customize->add_setting('creative_blogger_sidebar_page_layout',array(
		'default' => 'right',
	 	'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'creative-blogger'),
		'section' => 'creative_blogger_site_layoutsec',
		'choices' => array(
			'full' => __('Full','creative-blogger'),
			'left' => __('Left','creative-blogger'),
			'right' => __('Right','creative-blogger'),
	),
	) );			

	$wp_customize->add_setting( 'creative_blogger_layout_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_layout_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_site_layoutsec'
	)); 	

   //Global Color
	$wp_customize->add_section('creative_blogger_global_color', array(
		'title'    => __('Manage Global Color Section', 'creative-blogger'),
		'panel'    => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_first_color', array(
		'default'           => '#3858F6',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_first_color', array(
		'label'    => __('Theme Color One', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_first_color',
	)));		

	$wp_customize->add_setting('creative_blogger_second_color', array(
		'default'           => '#111827',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_second_color', array(
		'label'    => __('Theme Color Two', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_second_color',
	)));	

	$wp_customize->add_setting('creative_blogger_third_color', array(
		'default'           => '#2A67F7',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_third_color', array(
		'label'    => __('Theme Color Three', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_third_color',
	)));

	$wp_customize->add_setting('creative_blogger_fourth_color', array(
		'default'           => '#FFAF25',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_fourth_color', array(
		'label'    => __('Theme Color Four', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_fourth_color',
	)));

	$wp_customize->add_setting('creative_blogger_fifth_color', array(
		'default'           => '#FF3D00',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_fifth_color', array(
		'label'    => __('Theme Color Fifth', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_fifth_color',
	)));

	$wp_customize->add_setting('creative_blogger_sixth_color', array(
		'default'           => '#FF3385',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'creative_blogger_sixth_color', array(
		'label'    => __('Theme Color Six', 'creative-blogger'),
		'section'  => 'creative_blogger_global_color',
		'settings' => 'creative_blogger_sixth_color',
	)));	
		
	$wp_customize->add_setting( 'creative_blogger_global_color_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_global_color_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_global_color'
	)); 	 

	// Topbar
 	$wp_customize->add_section('creative_blogger_topbar_section', array(
        'title' => __('Manage Topbar Section', 'creative-blogger'),
		'description' => __('<p class="sec-title">Manage Topbar Section</p>','creative-blogger'),
        'priority' => null,
		'panel' => 'creative_blogger_panel_area',
 	));

	$wp_customize->add_setting('creative_blogger_topbar_enable',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control( 'creative_blogger_topbar_enable', array(
	   'settings' => 'creative_blogger_topbar_enable',
	   'section'   => 'creative_blogger_topbar_section',
	   'label'     => __('Enable Topbar','creative-blogger'),
	   'type'      => 'checkbox'
	));

 	$wp_customize->add_setting('creative_blogger_follow_us_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_follow_us_text',array(
        'label' => __('Follow Us Text ','creative-blogger'),
        'section'=> 'creative_blogger_topbar_section',
        'settings'=> 'creative_blogger_follow_us_text',
        'type'=> 'text'
    ));

 	$wp_customize->add_setting('creative_blogger_addvertise_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_addvertise_text',array(
        'label' => __('Advertisement Text ','creative-blogger'),
        'section'=> 'creative_blogger_topbar_section',
        'settings'=> 'creative_blogger_addvertise_text',
        'type'=> 'text'
    ));

    $wp_customize->add_setting('creative_blogger_about_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_about_text',array(
        'label' => __('About Text ','creative-blogger'),
        'section'=> 'creative_blogger_topbar_section',
        'settings'=> 'creative_blogger_about_text',
        'type'=> 'text'
    ));

    $wp_customize->add_setting('creative_blogger_contact_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_contact_text',array(
        'label' => __('Contact Text ','creative-blogger'),
        'section'=> 'creative_blogger_topbar_section',
        'settings'=> 'creative_blogger_contact_text',
        'type'=> 'text'
    ));
 
	$wp_customize->add_setting( 'creative_blogger_topbar_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_topbar_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_topbar_section'
	)); 		

 	// Header Section
	$wp_customize->add_section('creative_blogger_header_section', array(
        'title' => __('Manage Header Section', 'creative-blogger'),
		'description' => __('<p class="sec-title">Manage Header Section</p>','creative-blogger'),
        'priority' => null,
		'panel' => 'creative_blogger_panel_area',
 	));

	// Sticky Header
	$wp_customize->add_setting( 'creative_blogger_sticky_header',array(
        'default' => false,
        'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control( 'creative_blogger_sticky_header',array(
		'settings' => 'creative_blogger_sticky_header',
	    'section'   => 'creative_blogger_header_section',
        'label' => esc_html__( 'Check To Enable Sticky Header','creative-blogger' ),
        'type'      => 'checkbox'
    ));

	$wp_customize->add_setting('creative_blogger_middle_header_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'creative_blogger_middle_header_img',array(
	    'label' => __('Middle Header Image','creative-blogger'),
	    'description'	=> __('Use the given image dimension (665 x 77).','creative-blogger'),
	    'section' => 'creative_blogger_header_section'
	)));

	$wp_customize->add_setting('creative_blogger_discount_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_discount_text',array(
        'label' => __('Discount Text ','creative-blogger'),
        'section'=> 'creative_blogger_header_section',
        'settings'=> 'creative_blogger_discount_text',
        'type'=> 'text'
    ));

    $wp_customize->add_setting('creative_blogger_img_text',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
    ));
    $wp_customize->add_control('creative_blogger_img_text',array(
        'label' => __('Image Text ','creative-blogger'),
        'section'=> 'creative_blogger_header_section',
        'settings'=> 'creative_blogger_img_text',
        'type'=> 'text'
    ));

	$wp_customize->add_setting('creative_blogger_header_btn_text',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_header_btn_text', array(
	   'settings' => 'creative_blogger_header_btn_text',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Add Button Text', 'creative-blogger'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('creative_blogger_header_btn_url',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_header_btn_url', array(
	   'settings' => 'creative_blogger_header_btn_url',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Add Button URL', 'creative-blogger'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('creative_blogger_bookmark_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_bookmark_link', array(
	   'settings' => 'creative_blogger_bookmark_link',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Bookmark Link', 'creative-blogger'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('creative_blogger_subscribe_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_subscribe_link', array(
	   'settings' => 'creative_blogger_subscribe_link',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Subscribe Link', 'creative-blogger'),
	   'type'      => 'url'
	));

	$wp_customize->add_setting('creative_blogger_admin_img',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'creative_blogger_admin_img',array(
	    'label' => __('Add Image','creative-blogger'),
	    'description'	=> __('Use the given image dimension (33 x 33).','creative-blogger'),
	    'section' => 'creative_blogger_header_section'
	)));

	$wp_customize->add_setting('creative_blogger_image_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_image_link', array(
	   'settings' => 'creative_blogger_image_link',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Add Account Link', 'creative-blogger'),
	   'type'      => 'url'
	));

	// header menu
	$wp_customize->add_setting('creative_blogger_menu_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_menu_color', array(
	   'settings' => 'creative_blogger_menu_color',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Menu Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	// header menu hover color
	$wp_customize->add_setting('creative_blogger_menuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_menuhrv_color', array(
	   'settings' => 'creative_blogger_menuhrv_color',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('Menu Hover Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	// header sub menu color
	$wp_customize->add_setting('creative_blogger_submenu_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_submenu_color', array(
	   'settings' => 'creative_blogger_submenu_color',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('SubMenu Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	// header sub menu hover color
	$wp_customize->add_setting('creative_blogger_submenuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_submenuhrv_color', array(
	   'settings' => 'creative_blogger_submenuhrv_color',
	   'section'   => 'creative_blogger_header_section',
	   'label' => __('SubMenu Hover Color', 'creative-blogger'),
	   'type'      => 'color'
	));

    // Menu Text Transform
    $wp_customize->add_setting( 'creative_blogger_menu_text_transform', array(
        'default'           => 'Capitalize',
		'transport' => 'refresh',
		'sanitize_callback' => 'creative_blogger_sanitize_choices'
    ));

    $wp_customize->add_control( 'creative_blogger_menu_text_transform', array(
        'label'    => __( 'Menu Text Transform', 'creative-blogger' ),
        'section'  => 'creative_blogger_header_section',
        'type'     => 'select',
        'choices'  => array(
			'None'       => __( 'None', 'creative-blogger' ),
            'Capitalize' => __( 'Capitalize', 'creative-blogger' ),
            'Uppercase'  => __( 'Uppercase', 'creative-blogger' ),
            'Lowercase'  => __( 'Lowercase', 'creative-blogger' ),
        ),
    ));

	$wp_customize->add_setting( 'creative_blogger_header_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_header_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_header_section'
	)); 			

	// Slider Section
	$wp_customize->add_section('creative_blogger_slider_section',array(
	    'title' => __('Manage Slider Section','creative-blogger'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Slider Section</p> Select Category from the Dropdowns for slider, Also use the given image dimension (580 x 550).','creative-blogger'),
	    'panel' => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_slider',array(
		'default' => false,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_slider', array(
	   'settings' => 'creative_blogger_slider',
	   'section'   => 'creative_blogger_slider_section',
	   'label'     => __('Check To Enable This Section','creative-blogger'),
	   'type'      => 'checkbox'
	));

	$categories = get_categories();
	$cat_post = array('select' => 'Select');
	foreach ($categories as $category) {
	    $cat_post[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('creative_blogger_slider_category', array(
	    'default' => '0',
	    'sanitize_callback' => 'creative_blogger_sanitize_choices',
	));
	$wp_customize->add_control('creative_blogger_slider_category', array(
	    'type'    => 'select',
	    'choices' => $cat_post,
	    'label'   => __('Select Category to display Latest Post', 'creative-blogger'),
	    'section' => 'creative_blogger_slider_section',
	));

	$wp_customize->add_setting( 'creative_blogger_slider_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_slider_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_slider_section'
	)); 			

	// Add Banner Posts Section
	$wp_customize->add_section('creative_blogger_below_main_post_section', array(
	    'title'       => __('Manage Banner Posts Section', 'creative-blogger'),
	    'description' => __('<p class="sec-title">Manage Banner Posts Section</p>', 'creative-blogger'),
	    'priority'    => null,
	    'panel'       => 'creative_blogger_panel_area',
	));

	$args = array('numberposts' => -1);
	$post_list = get_posts($args);
	$i = 0;
	$pst[]='Select';
	foreach($post_list as $post){
		$pst[$post->ID] = $post->post_title;
	}

	for ( $creative_blogger_i = 1; $creative_blogger_i <= 3; $creative_blogger_i++ ) {
		$wp_customize->add_setting('creative_blogger_select_posts'.$creative_blogger_i,array(
			'sanitize_callback' => 'creative_blogger_sanitize_choices',
		));
		$wp_customize->add_control('creative_blogger_select_posts'.$creative_blogger_i,array(
			'type'    => 'select',
			'choices' => $pst,
			'label' => __('Select post','creative-blogger'),
			'section' => 'creative_blogger_below_main_post_section',
		));
	}

	$wp_customize->add_setting( 'creative_blogger_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_below_main_post_section'
	)); 	

	// Trending Topics
	$wp_customize->add_section('creative_blogger_trending_topics_section', array(
	    'title'       => __('Manage Trending Topics Section', 'creative-blogger'),
	    'description' => __('<p class="sec-title">Manage Trending Topics Section</p>', 'creative-blogger'),
	    'priority'    => null,
	    'panel'       => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_disabled_trending_section', array(
	    'default'           => false,
	    'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('creative_blogger_disabled_trending_section', array(
	    'settings' => 'creative_blogger_disabled_trending_section',
	    'section'  => 'creative_blogger_trending_topics_section',
	    'label'    => __('Check To Enable This Section', 'creative-blogger'),
	    'type'     => 'checkbox',
	));

	$wp_customize->add_setting('creative_blogger_trending_title', array(
	    'default'           => ' ',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('creative_blogger_trending_title', array(
	    'settings' => 'creative_blogger_trending_title',
	    'section'  => 'creative_blogger_trending_topics_section',
	    'label'    => __('Add Trending Title', 'creative-blogger'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting('creative_blogger_trending_text', array(
	    'default'           => ' ',
	    'sanitize_callback' => 'sanitize_text_field',
	    'capability'        => 'edit_theme_options',
	));
	$wp_customize->add_control('creative_blogger_trending_text', array(
	    'settings' => 'creative_blogger_trending_text',
	    'section'  => 'creative_blogger_trending_topics_section',
	    'label'    => __('Add Trending Details', 'creative-blogger'),
	    'type'     => 'text',
	));

	$wp_customize->add_setting( 'creative_blogger_trending_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_trending_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_trending_topics_section'
	)); 	
	
	//Blog post
	$wp_customize->add_section('creative_blogger_blog_post_settings',array(
        'title' => __('Manage Post Section', 'creative-blogger'),
        'priority' => null,
        'panel' => 'creative_blogger_panel_area'
    ));

	$wp_customize->add_setting('creative_blogger_metafields_date', array(
	    'default' => true,
	    'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control('creative_blogger_metafields_date', array(
	    'settings' => 'creative_blogger_metafields_date', 
	    'section'   => 'creative_blogger_blog_post_settings',
	    'label'     => __('Check to Enable Date', 'creative-blogger'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('creative_blogger_metafields_comments', array(
		'default' => true,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control('creative_blogger_metafields_comments', array(
		'settings' => 'creative_blogger_metafields_comments',
		'section'  => 'creative_blogger_blog_post_settings',
		'label'    => __('Check to Enable Comments', 'creative-blogger'),
		'type'     => 'checkbox',
	));

	$wp_customize->add_setting('creative_blogger_metafields_author', array(
		'default' => true,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control('creative_blogger_metafields_author', array(
		'settings' => 'creative_blogger_metafields_author',
		'section'  => 'creative_blogger_blog_post_settings',
		'label'    => __('Check to Enable Author', 'creative-blogger'),
		'type'     => 'checkbox',
	));		

	$wp_customize->add_setting('creative_blogger_metafields_time', array(
		'default' => true,
		'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control('creative_blogger_metafields_time', array(
		'settings' => 'creative_blogger_metafields_time',
		'section'  => 'creative_blogger_blog_post_settings',
		'label'    => __('Check to Enable Time', 'creative-blogger'),
		'type'     => 'checkbox',
	));	

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('creative_blogger_sidebar_post_layout',array(
		'default' => 'right',
		'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_sidebar_post_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Post Sidebar Position', 'creative-blogger'),
		'description'   => __('This option work for blog page, archive page and search page.', 'creative-blogger'),
		'section' => 'creative_blogger_blog_post_settings',
		'choices' => array(
			'full' => __('Full','creative-blogger'),
			'left' => __('Left','creative-blogger'),
			'right' => __('Right','creative-blogger'),
			'three-column' => __('Three Columns','creative-blogger'),
			'four-column' => __('Four Columns','creative-blogger'),
			'grid' => __('Grid Layout','creative-blogger')
     ),
	) );

	$wp_customize->add_setting('creative_blogger_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','creative-blogger'),
        'section' => 'creative_blogger_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','creative-blogger'),
            'Excerpt Content' => __('Excerpt Content','creative-blogger'),
            'Full Content' => __('Full Content','creative-blogger'),
        ),
	) );

	$wp_customize->add_setting('creative_blogger_blog_post_thumb',array(
        'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('creative_blogger_blog_post_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Show / Hide Blog Post Thumbnail', 'creative-blogger'),
        'section'     => 'creative_blogger_blog_post_settings',
    ));

	$wp_customize->add_setting( 'creative_blogger_blog_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_blog_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_blog_post_settings'
	)); 	
	
	//Single Post Settings
	$wp_customize->add_section('creative_blogger_single_post_settings',array(
		'title' => __('Manage Single Post Section', 'creative-blogger'),
		'priority' => null,
		'panel' => 'creative_blogger_panel_area'
	));

	$wp_customize->add_setting('creative_blogger_single_post_date',array(
		'default' => true,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_single_post_date',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Date ','creative-blogger'),
		'section' => 'creative_blogger_single_post_settings'
	));	

	$wp_customize->add_setting('creative_blogger_single_post_author',array(
		'default' => true,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_single_post_author',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Author','creative-blogger'),
		'section' => 'creative_blogger_single_post_settings'
	));

	$wp_customize->add_setting('creative_blogger_single_post_comment',array(
		'default' => true,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_single_post_comment',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Comments','creative-blogger'),
		'section' => 'creative_blogger_single_post_settings'
	));	

	$wp_customize->add_setting('creative_blogger_single_post_time',array(
		'default' => true,
		'sanitize_callback'	=> 'creative_blogger_sanitize_checkbox'
	));
	$wp_customize->add_control('creative_blogger_single_post_time',array(
		'type' => 'checkbox',
		'label' => __('Enable / Disable Time','creative-blogger'),
		'section' => 'creative_blogger_single_post_settings'
	));	

	$wp_customize->add_setting('creative_blogger_single_post_metabox_seperator',array(
		'default' => '|',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_single_post_metabox_seperator',array(
		'type' => 'text',
		'label' => __('Metabox Seperator','creative-blogger'),
		'description' => __('Ex: "/", "|", "-", ...','creative-blogger'),
		'section' => 'creative_blogger_single_post_settings'
	)); 

	$wp_customize->add_setting('creative_blogger_sidebar_single_post_layout',array(
    	'default' => 'right',
    	 'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_sidebar_single_post_layout',array(
   		'type' => 'radio',
    	'label'     => __('Single post sidebar layout', 'creative-blogger'),
     	'section' => 'creative_blogger_single_post_settings',
     	'choices' => array(
			'full' => __('Full','creative-blogger'),
			'left' => __('Left','creative-blogger'),
			'right' => __('Right','creative-blogger'),
     ),
	));

	$wp_customize->add_setting( 'creative_blogger_single_post_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_single_post_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_single_post_settings'
	)); 

	//Page Settings
	$wp_customize->add_section('creative_blogger_page_settings',array(
		'title' => __('Manage Page Section', 'creative-blogger'),
		'priority' => null,
		'panel' => 'creative_blogger_panel_area'
	));

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('creative_blogger_sidebar_page_layout',array(
		'default' => 'full',
			'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_sidebar_page_layout',array(
		'type' => 'radio',
		'label'     => __('Theme Page Sidebar Position', 'creative-blogger'),
		'section' => 'creative_blogger_page_settings',
		'choices' => array(
			'left' => __('Left','creative-blogger'),
			'right' => __('Right','creative-blogger'),
			'full' => __('No Sidebar','creative-blogger')
		),
	));

	// 404 Page Settings
	$wp_customize->add_section('creative_blogger_page_not_found', array(
		'title'	=> __('Manage 404 Page Section','creative-blogger'),
		'priority'	=> null,
		'panel' => 'creative_blogger_panel_area',
	));
	
	$wp_customize->add_setting('creative_blogger_page_not_found_heading',array(
		'default'=> __('404 Not Found','creative-blogger'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_page_not_found_heading',array(
		'label'	=> __('404 Heading','creative-blogger'),
		'section'=> 'creative_blogger_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('creative_blogger_page_not_found_content',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));

	$wp_customize->add_control('creative_blogger_page_not_found_content',array(
		'label'	=> __('404 Text','creative-blogger'),
		'input_attrs' => array(
			'placeholder' => __( 'Looks like you have taken a wrong turn.....Don\'t worry... it happens to the best of us.', 'creative-blogger' ),
		),
		'section'=> 'creative_blogger_page_not_found',
		'type'=> 'text'
	));

	$wp_customize->add_setting('creative_blogger_page_not_found_btn',array(
		'default' => 'Homepage',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_page_not_found_btn', array(
	   'settings' => 'creative_blogger_page_not_found_btn',
	   'section'   => 'creative_blogger_page_not_found',
	   'label' => __('404 Button', 'creative-blogger'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting( 'creative_blogger_page_not_found_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_page_not_found_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
			<a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_page_not_found'
	));

	// Footer Section
	$wp_customize->add_section('creative_blogger_footer', array(
		'title'	=> __('Manage Footer Section','creative-blogger'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','creative-blogger'),
		'priority'	=> null,
		'panel' => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_footer_widget', array(
	    'default' => true,
	    'sanitize_callback' => 'creative_blogger_sanitize_checkbox',
	));
	$wp_customize->add_control('creative_blogger_footer_widget', array(
	    'settings' => 'creative_blogger_footer_widget',
	    'section'   => 'creative_blogger_footer',
	    'label'     => __('Check to Enable Footer Widget', 'creative-blogger'),
	    'type'      => 'checkbox',
	));

	//  footer bg color
	$wp_customize->add_setting('creative_blogger_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footerbg_color', array(
	   'settings' => 'creative_blogger_footerbg_color',
	   'section'   => 'creative_blogger_footer',
	   'label' => __('Footer Background Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('creative_blogger_footer_bg_image',array(
        'default'   => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'creative_blogger_footer_bg_image',array(
        'label' => __('Footer Background Image','creative-blogger'),
        'section' => 'creative_blogger_footer',
    )));

	$wp_customize->add_setting('creative_blogger_footer_img_position',array(
		'default' => 'center center',
		'transport' => 'refresh',
		'sanitize_callback' => 'creative_blogger_sanitize_choices'
	));
	$wp_customize->add_control('creative_blogger_footer_img_position',array(
		'type' => 'select',
		'label' => __('Footer Image Position','creative-blogger'),
		'section' => 'creative_blogger_footer',
		'choices' 	=> array(
			'center center'   => esc_html__( 'Center', 'creative-blogger' ),
			'center top'   => esc_html__( 'Top', 'creative-blogger' ),
			'left center'   => esc_html__( 'Left', 'creative-blogger' ),
			'right center'   => esc_html__( 'Right', 'creative-blogger' ),
			'center bottom'   => esc_html__( 'Bottom', 'creative-blogger' ),
		),
	));	

	$wp_customize->add_setting('creative_blogger_copyright_line',array(
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'creative_blogger_copyright_line', array(
	   'section' 	=> 'creative_blogger_footer',
	   'label'	 	=> __('Copyright Line','creative-blogger'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	$wp_customize->add_setting('creative_blogger_copyright_link',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));	
	$wp_customize->add_control( 'creative_blogger_copyright_link', array(
	   'section' 	=> 'creative_blogger_footer',
	   'label'	 	=> __('Copyright Link','creative-blogger'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer title color
	$wp_customize->add_setting('creative_blogger_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footertitle_color', array(
	   'settings' => 'creative_blogger_footertitle_color',
	   'section'   => 'creative_blogger_footer',
	   'label' => __('Title Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('creative_blogger_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'creative_blogger_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footerlist_color', array(
	   'settings' => 'creative_blogger_footerlist_color',
	   'section'   => 'creative_blogger_footer',
	   'label' => __('List Color', 'creative-blogger'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('creative_blogger_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'creative_blogger_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'creative_blogger_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'creative-blogger' ),
        'section'        => 'creative_blogger_footer',
        'settings'       => 'creative_blogger_scroll_hide',
        'type'           => 'checkbox',
    )));

	$wp_customize->add_setting('creative_blogger_scroll_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'creative_blogger_sanitize_choices'
    ));
    $wp_customize->add_control('creative_blogger_scroll_position',array(
        'type' => 'radio',
        'section' => 'creative_blogger_footer',
        'label'	 	=> __('Scroll To Top Positions','creative-blogger'),
        'choices' => array(
            'Right' => __('Right','creative-blogger'),
            'Left' => __('Left','creative-blogger'),
            'Center' => __('Center','creative-blogger')
        ),
    ));

	$wp_customize->add_setting('creative_blogger_scroll_text',array(
		'default'	=> __('TOP','creative-blogger'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));	
	$wp_customize->add_control('creative_blogger_scroll_text',array(
		'label'	=> __('Scroll To Top Button Text','creative-blogger'),
		'section'	=> 'creative_blogger_footer',
		'type'		=> 'text'
	));

	$wp_customize->add_setting( 'creative_blogger_scroll_top_shape', array(
		'default'           => 'circle',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'creative_blogger_scroll_top_shape', array(
		'label'    => __( 'Scroll to Top Button Shape', 'creative-blogger' ),
		'section'  => 'creative_blogger_footer',
		'settings' => 'creative_blogger_scroll_top_shape',
		'type'     => 'radio',
		'choices'  => array(
			'box'        => __( 'Box', 'creative-blogger' ),
			'curved' => __( 'Curved', 'creative-blogger'),
			'circle'     => __( 'Circle', 'creative-blogger' ),
		),
	));

	$wp_customize->add_setting('creative_blogger_footer_widget_areas',array(
		'default'           => 4,
		'sanitize_callback' => 'creative_blogger_sanitize_choices',
	));
	$wp_customize->add_control('creative_blogger_footer_widget_areas',array(
		'type'        => 'radio',
		'section' => 'creative_blogger_footer',
		'label'       => __('Footer widget area', 'creative-blogger'),
		'choices' => array(
		   '1'     => __('One', 'creative-blogger'),
		   '2'     => __('Two', 'creative-blogger'),
		   '3'     => __('Three', 'creative-blogger'),
		   '4'     => __('Four', 'creative-blogger')
		),
	));

	$wp_customize->add_setting( 'creative_blogger_footerlist_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_footerlist_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		   <a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_footer'
	)); 
	
	// Footer Social Section
	$wp_customize->add_section('creative_blogger_footer_social_icons', array(
		'title'	=> __('Manage Footer Social Section','creative-blogger'),
		'description'	=> __('<p class="sec-title">Manage Footer Social Section</p>','creative-blogger'),
		'priority'	=> null,
		'panel' => 'creative_blogger_panel_area',
	));

	$wp_customize->add_setting('creative_blogger_footer_facebook_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footer_facebook_link', array(
		'settings' => 'creative_blogger_footer_facebook_link',
		'section'   => 'creative_blogger_footer_social_icons',
		'label' => __('Facebook Link', 'creative-blogger'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('creative_blogger_footer_instagram_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footer_instagram_link', array(
		'settings' => 'creative_blogger_footer_instagram_link',
		'section'   => 'creative_blogger_footer_social_icons',
		'label' => __('Instagram Link', 'creative-blogger'),
		'type'      => 'url'
		));

	$wp_customize->add_setting('creative_blogger_footer_pinterest_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footer_pinterest_link', array(
		'settings' => 'creative_blogger_footer_pinterest_link',
		'section'   => 'creative_blogger_footer_social_icons',
		'label' => __('Pinterest Link', 'creative-blogger'),
		'type'      => 'url'
	));

	$wp_customize->add_setting('creative_blogger_footer_twitter_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footer_twitter_link', array(
		'settings' => 'creative_blogger_footer_twitter_link',
		'section'   => 'creative_blogger_footer_social_icons',
		'label' => __('Twitter Link', 'creative-blogger'),
		'type'      => 'url'
		));

	$wp_customize->add_setting('creative_blogger_footer_youtube_link',array(
		'default' => '',
		'sanitize_callback' => 'esc_url_raw',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'creative_blogger_footer_youtube_link', array(
		'settings' => 'creative_blogger_footer_youtube_link',
		'section'   => 'creative_blogger_footer_social_icons',
		'label' => __('Youtube Link', 'creative-blogger'),
		'type'      => 'url'
	));

	$wp_customize->add_setting( 'creative_blogger_footer_social_settings_upgraded_features',array(
		'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('creative_blogger_footer_social_settings_upgraded_features', array(
		'type'=> 'hidden',
		'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
		<a target='_blank' href='". esc_url(CREATIVE_BLOGGER_PREMIUM_PAGE) ." '>Upgrade to Pro</a></span>",
		'section' => 'creative_blogger_footer_social_icons'
	));

	// Google Fonts
	$wp_customize->add_section( 'creative_blogger_google_fonts_section', array(
		'title'       => __( 'Google Fonts', 'creative-blogger' ),
		'priority'    => 24,
	) );

	$font_choices = array(
		'' => 'No Fonts',
		'Kaushan Script:' => 'Kaushan Script',
		'Emilys Candy:' => 'Emilys Candy',
		'Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900' => 'Poppins',
		'Source Sans Pro:400,700,400italic,700italic' => 'Source Sans Pro',
		'Open Sans:400italic,700italic,400,700' => 'Open Sans',
		'Oswald:400,700' => 'Oswald',
		'Playfair Display:400,700,400italic' => 'Playfair Display',
		'Montserrat:400,700' => 'Montserrat',
		'Raleway:400,700' => 'Raleway',
		'Droid Sans:400,700' => 'Droid Sans',
		'Lato:400,700,400italic,700italic' => 'Lato',
		'Arvo:400,700,400italic,700italic' => 'Arvo',
		'Lora:400,700,400italic,700italic' => 'Lora',
		'Merriweather:400,300italic,300,400italic,700,700italic' => 'Merriweather',
		'Oxygen:400,300,700' => 'Oxygen',
		'PT Serif:400,700' => 'PT Serif',
		'PT Sans:400,700,400italic,700italic' => 'PT Sans',
		'PT Sans Narrow:400,700' => 'PT Sans Narrow',
		'Cabin:400,700,400italic' => 'Cabin',
		'Fjalla One:400' => 'Fjalla One',
		'Francois One:400' => 'Francois One',
		'Josefin Sans:400,300,600,700' => 'Josefin Sans',
		'Libre Baskerville:400,400italic,700' => 'Libre Baskerville',
		'Arimo:400,700,400italic,700italic' => 'Arimo',
		'Ubuntu:400,700,400italic,700italic' => 'Ubuntu',
		'Bitter:400,700,400italic' => 'Bitter',
		'Droid Serif:400,700,400italic,700italic' => 'Droid Serif',
		'Roboto:400,400italic,700,700italic' => 'Roboto',
		'Open Sans Condensed:700,300italic,300' => 'Open Sans Condensed',
		'Roboto Condensed:400italic,700italic,400,700' => 'Roboto Condensed',
		'Roboto Slab:400,700' => 'Roboto Slab',
		'Yanone Kaffeesatz:400,700' => 'Yanone Kaffeesatz',
		'Rokkitt:400' => 'Rokkitt',
	);

	$wp_customize->add_setting( 'creative_blogger_headings_fonts', array(
		'sanitize_callback' => 'creative_blogger_sanitize_fonts',
	));
	$wp_customize->add_control( 'creative_blogger_headings_fonts', array(
		'type' => 'select',
		'description' => __('Select your desired font for the headings.', 'creative-blogger'),
		'section' => 'creative_blogger_google_fonts_section',
		'choices' => $font_choices
	));

	$wp_customize->add_setting( 'creative_blogger_body_fonts', array(
		'sanitize_callback' => 'creative_blogger_sanitize_fonts'
	));
	$wp_customize->add_control( 'creative_blogger_body_fonts', array(
		'type' => 'select',
		'description' => __( 'Select your desired font for the body.', 'creative-blogger' ),
		'section' => 'creative_blogger_google_fonts_section',
		'choices' => $font_choices
	));	

}
add_action( 'customize_register', 'creative_blogger_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function creative_blogger_customize_preview_js() {
	wp_enqueue_script( 'creative_blogger_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'creative_blogger_customize_preview_js' );
