<?php
/**
 * @package Creative Blogger
 * Setup the WordPress core custom header feature.
 *
 * @uses creative_blogger_header_style()
 */
function creative_blogger_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'creative_blogger_custom_header_args', array(
		'default-text-color'     => 'fff',
		'width'                  => 2500,
		'height'                 => 400,
		'wp-head-callback'       => 'creative_blogger_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'creative_blogger_custom_header_setup' );

if ( ! function_exists( 'creative_blogger_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see creative_blogger_custom_header_setup().
 */
function creative_blogger_header_style() {
	$creative_blogger_header_text_color = get_header_textcolor();

	?>
	<style type="text/css">
	<?php
		//Check if user has defined any header image.
		if ( get_header_image() || get_header_textcolor() ) :
	?>
		.mainhead {
			background: url(<?php echo esc_url( get_header_image() ); ?>) no-repeat !important;
			background-position: center top;
			background-size: cover !important;
		}

	<?php endif; ?>	

	h1.site-title a, p.site-title a{
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_sitetitle_color')); ?> !important;
	}

	.site-description{
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_sitetagline_color')); ?> !important;
	}

	.main-nav ul li a {
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_menu_color')); ?> !important;
	}

	.main-nav a:hover{
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_menuhrv_color')); ?> !important;
	}

	.main-nav ul ul a{
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_submenu_color')); ?> !important;
	}

	.main-nav ul ul a:hover {
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_submenuhrv_color')); ?> !important;
	}

	#footer h3 {
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_footertitle_color')); ?> !important;

	}
	#footer ul li a {
		color: <?php echo esc_attr(get_theme_mod('creative_blogger_footerlist_color')); ?>;

	}
	#footer {
		background-color: <?php echo esc_attr(get_theme_mod('creative_blogger_footerbg_color')); ?>;
	}
	

	</style>
	<?php 
}
endif;