<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div class="container">
 *
 * @package Creative Blogger
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php if ( function_exists( 'wp_body_open' ) ) {
  wp_body_open();
} else {
  do_action( 'wp_body_open' );
} ?>

<?php if ( get_theme_mod('creative_blogger_preloader', false) != "") { ?>
  <div id="preloader">
    <div id="status">&nbsp;</div>
  </div>
<?php }?>

<a class="screen-reader-text skip-link" href="#content"><?php esc_html_e( 'Skip to content', 'creative-blogger' ); ?></a>

<div id="pageholder" <?php if( get_theme_mod( 'creative_blogger_box_layout', false) != "" ) { echo 'class="boxlayout"'; } ?>>

<div class="mainhead">
  <?php if (get_theme_mod('creative_blogger_topbar_enable', false)) { ?>
    <div class="topbar py-3">
      <div class="container">
        <div class="row m-0">
          <div class="col-xl-6 col-lg-6 col-md-6 col-12 align-self-center px-md-0 topbar-date">
            <div class="row">
              <div class="col-xl-2 col-lg-3 col-md-4 col-6 align-self-center main-date">
                <div class="news-date">
                  <span><?php echo esc_html( date_i18n( 'F j, Y' ) ); ?></span>
                </div>
              </div>
              <div class="col-xl-10 col-lg-9 col-md-4 col-6 align-self-center">
                <?php if (get_theme_mod('creative_blogger_follow_us_text') != '') { ?>
                  <p class="topbar-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_follow_us_text')); ?></p>
                <?php } ?>
              </div>
            </div>
          </div>
          <div class="col-xl-6 col-lg-6 col-md-6 col-12 align-self-center px-md-0">
            <div class="row">
              <div class="col-xl-8 col-lg-4 col-md-4 col-4 text-end align-self-center">
                <?php if (get_theme_mod('creative_blogger_addvertise_text') != '') { ?>
                  <p class="topbar-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_addvertise_text')); ?></p>
                <?php } ?>
              </div>
              <div class="col-xl-2 col-lg-4 col-md-4 col-4 text-end align-self-center">
                <?php if (get_theme_mod('creative_blogger_about_text') != '') { ?>
                  <p class="topbar-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_about_text')); ?></p>
                <?php } ?>
              </div>
              <div class="col-xl-2 col-lg-4 col-md-4 col-4 text-end align-self-center">
                <?php if (get_theme_mod('creative_blogger_contact_text') != '') { ?>
                  <p class="topbar-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_contact_text')); ?></p>
                <?php } ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php } ?>
  <div class="middle-header py-3">
    <div class="container">
      <div class="row m-0">
        <div class="col-xl-3 col-lg-3 col-md-4 align-self-center px-md-0">
          <div class="logo text-center text-md-start">
            <?php if (get_theme_mod('creative_blogger_logo_enable', true)) { ?>
              <?php creative_blogger_the_custom_logo(); ?>
            <?php } ?>
            <div class="site-branding-text">
              <?php if (get_theme_mod('creative_blogger_title_enable', false)) { ?>
                <?php if (is_front_page() && is_home()) : ?>
                  <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></h1>
                <?php else : ?>
                  <p class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></p>
                <?php endif; ?>
              <?php } ?>
              <?php $creative_blogger_description = get_bloginfo('description', 'display');
              if ($creative_blogger_description || is_customize_preview()) : ?>
                <?php if (get_theme_mod('creative_blogger_tagline_enable', false)) { ?>
                  <span class="site-description"><?php echo esc_html($creative_blogger_description); ?></span>
                <?php } ?>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <div class="col-xl-9 col-lg-9 col-md-8 align-self-center mid-header-img p-0">
          <?php if (get_theme_mod('creative_blogger_middle_header_img') != '') { ?>
            <img src="<?php echo esc_url(get_theme_mod('creative_blogger_middle_header_img')); ?>" alt="<?php echo esc_attr( 'image', 'creative-blogger'); ?>" />
          <?php } ?>
          <div class="row">
            <div class="col-xl-3 col-lg-3 col-md-3 discount-main-text align-self-center">
              <?php if (get_theme_mod('creative_blogger_discount_text') != '') { ?>
                <p class="discount-text text-uppercase mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_discount_text')); ?></p>
              <?php } ?>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-4 img-main-text align-self-center">
              <?php if (get_theme_mod('creative_blogger_img_text') != '') { ?>
                <p class="img-text text-capitalize mb-0"><?php echo esc_html(get_theme_mod('creative_blogger_img_text')); ?></p>
              <?php } ?>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-5 col-12 shop-header-btn align-self-center">
              <?php if ( get_theme_mod('creative_blogger_header_btn_text') != "" && get_theme_mod('creative_blogger_header_btn_url') != "") { ?> 
                <div class="shop-btn">
                  <a href="<?php echo esc_url(get_theme_mod ('creative_blogger_header_btn_url','')); ?>"><?php echo esc_html(get_theme_mod ('creative_blogger_header_btn_text','Download CV','creative-blogger')); ?></a>
                </div>
              <?php }?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="header <?php echo ( get_theme_mod( 'creative_blogger_sticky_header', false ) == 1 ) ? 'header-sticky' : 'close-sticky'; ?>">
    <div class="container">
      <div class="row m-0">
        <div class="col-xl-7 col-lg-6 col-md-2 col-sm-2 col-12 align-self-center ps-0">
          <div class="toggle-nav text-center">
            <?php if (has_nav_menu('primary')) { ?>
              <button role="tab"><?php esc_html_e('Menu', 'creative-blogger'); ?></button>
            <?php } ?>
          </div>
          <div id="mySidenav" class="nav sidenav">
            <nav id="site-navigation" class="main-nav" role="navigation" aria-label="<?php esc_attr_e('Top Menu', 'creative-blogger'); ?>">
              <ul class="mobile_nav">
                <?php wp_nav_menu(array(
                  'theme_location' => 'primary',
                  'container_class' => 'main-menu',
                  'items_wrap' => '%3$s',
                  'fallback_cb' => 'wp_page_menu',
                )); ?>
              </ul>
              <a href="javascript:void(0)" class="close-button"><?php esc_html_e('CLOSE', 'creative-blogger'); ?></a>
            </nav>
          </div>
        </div>
        <div class="col-xl-3 col-lg-3 col-md-6 col-sm-7 col-7 align-self-center">
          <div class="search_box"><?php get_search_form(); ?></div>
        </div>
        <div class="col-xl-2 col-lg-3 col-md-4 col-sm-3 col-5 align-self-center header-icons text-end">
          <?php if ( get_theme_mod('creative_blogger_bookmark_link') != "") { ?>
            <a title="<?php echo esc_attr('bookmark', 'creative-blogger'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('creative_blogger_bookmark_link')); ?>"><i class="fa-solid fa-bookmark"></i></a> 
          <?php } ?>
          <?php if ( get_theme_mod('creative_blogger_subscribe_link') != "") { ?>
            <a title="<?php echo esc_attr('Subscribe', 'creative-blogger'); ?>" target="_blank" href="<?php echo esc_url(get_theme_mod('creative_blogger_subscribe_link')); ?>"><i class="fa-solid fa-bell"></i></a> 
          <?php } ?>
          <?php if (get_theme_mod('creative_blogger_admin_img') != '') { ?>
            <a target="_blank" href="<?php echo esc_url(get_theme_mod('creative_blogger_image_link')); ?>"><img src="<?php echo esc_url(get_theme_mod('creative_blogger_admin_img')); ?>" alt="<?php echo esc_attr( 'image', 'creative-blogger'); ?>" />
            </a>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</div>