<?php
/**
 * Creative Blogger functions and definitions
 *
 * @package Creative Blogger
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

if ( ! function_exists( 'creative_blogger_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function creative_blogger_setup() {
	global $content_width;
	if ( ! isset( $content_width ) )
		$content_width = 680;

	load_theme_textdomain( 'creative-blogger', get_template_directory() . '/languages' );		
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "responsive-embeds" );
	add_theme_support( 'align-wide' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'wp-block-styles');
	add_theme_support( 'custom-header', array(
		'default-text-color' => false,
		'header-text' => false,
	) );
	add_theme_support( 'custom-logo', array(
		'height'      => 150,
		'width'       => 150,
		'flex-height' => true,
	) );
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'creative-blogger' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_editor_style( 'editor-style.css' );

	// Theme Activation Notice
	global $pagenow;

	if (
		is_admin()
		&&
		('themes.php' == $pagenow)
		// &&
		// isset( $_GET['activated'] )
	) {
		add_action('admin_notices', 'creative_blogger_deprecated_hook_admin_notice');
	}
}
endif; // creative_blogger_setup
add_action( 'after_setup_theme', 'creative_blogger_setup' );

function creative_blogger_the_breadcrumb() {
    echo '<div class="breadcrumb my-3">';

    if (!is_home()) {
        echo '<a class="home-main align-self-center" href="' . esc_url(home_url()) . '">';
        bloginfo('name');
        echo "</a>";

        if (is_category() || is_single()) {
            the_category(' ');
            if (is_single()) {
                echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
        }
    }

    echo '</div>';
}

function creative_blogger_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'creative-blogger' ),
		'description'   => __( 'Appears on blog page sidebar', 'creative-blogger' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'creative-blogger' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your sidebar on pages.', 'creative-blogger' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'creative-blogger' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'creative-blogger' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar(array(
        'name'          => __('Shop Sidebar', 'creative-blogger'),
        'description'   => __('Sidebar for WooCommerce shop pages', 'creative-blogger'),
		'id'            => 'woocommerce_sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));
	register_sidebar(array(
        'name'          => __('Single Product Sidebar', 'creative-blogger'),
        'description'   => __('Sidebar for single product pages', 'creative-blogger'),
		'id'            => 'woocommerce-single-sidebar',
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ));	
	
	$creative_blogger_widget_areas = get_theme_mod('creative_blogger_footer_widget_areas', '4');
	for ($creative_blogger_i=1; $creative_blogger_i<=$creative_blogger_widget_areas; $creative_blogger_i++) {
		register_sidebar( array(
			'name'          => __( 'Footer Widget ', 'creative-blogger' ) . $creative_blogger_i,
			'id'            => 'footer-' . $creative_blogger_i,
			'description'   => '',
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="widget-title">',
			'after_title'   => '</h3>',
		) );
	}
}
add_action( 'widgets_init', 'creative_blogger_widgets_init' );

// Change number of products per row to 4
add_filter('loop_shop_columns', 'creative_blogger_loop_columns');
if (!function_exists('creative_blogger_loop_columns')) {
    function creative_blogger_loop_columns() {
        $creative_blogger_colm = get_theme_mod('creative_blogger_products_per_row', 4); // Default to 4 if not set
        return $creative_blogger_colm;
    }
}

// Use the customizer setting to set the number of products per page
function creative_blogger_products_per_page($creative_blogger_cols) {
    $creative_blogger_cols = get_theme_mod('creative_blogger_products_per_page', 9); // Default to 9 if not set
    return $creative_blogger_cols;
}
add_filter('loop_shop_per_page', 'creative_blogger_products_per_page', 9);

function creative_blogger_scripts() {

	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri())."/css/bootstrap.css" );
	wp_enqueue_style('creative-blogger-style', get_stylesheet_uri(), array() );
		wp_style_add_data('creative-blogger-style', 'rtl', 'replace');

	require get_parent_theme_file_path( '/inc/color-scheme/custom-color-control.php' );
	wp_add_inline_style( 'creative-blogger-style',$creative_blogger_color_scheme_css );
	wp_enqueue_style( 'owl.carousel-css', esc_url(get_template_directory_uri())."/css/owl.carousel.css" );
	wp_enqueue_style( 'creative-blogger-default', esc_url(get_template_directory_uri())."/css/default.css" );
	wp_enqueue_style( 'animate-style', get_template_directory_uri().'/css/animate.css' );
	wp_enqueue_script( 'wow-jquery', get_template_directory_uri() . '/js/wow.js', array('jquery'),'' ,true );
	wp_enqueue_style( 'creative-blogger-style', get_stylesheet_uri() );
	wp_enqueue_script( 'owl.carousel-js', esc_url(get_template_directory_uri()). '/js/owl.carousel.js', array('jquery') );
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()). '/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'creative-blogger-theme', esc_url(get_template_directory_uri()) . '/js/theme.js' );
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/css/fontawesome-all.css" );
	wp_enqueue_style( 'creative-blogger-block-style', esc_url( get_template_directory_uri() ).'/css/blocks.css' );	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// font-family
	$creative_blogger_headings_font = esc_html(get_theme_mod('creative_blogger_headings_fonts'));
	$creative_blogger_body_font = esc_html(get_theme_mod('creative_blogger_body_fonts'));

	if ($creative_blogger_headings_font) {
	    wp_enqueue_style('creative-blogger-headings-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($creative_blogger_headings_font));
	} else {
	    wp_enqueue_style('Unbounded-heading', 'https://fonts.googleapis.com/css?family=Unbounded:wght@200..900');
	}

	if ($creative_blogger_body_font) {
	    wp_enqueue_style('creative-blogger-body-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($creative_blogger_body_font));
	} else {
	    wp_enqueue_style('inter-body', 'https://fonts.googleapis.com/css?family=Inter:wght@100..900');
	}

}
add_action( 'wp_enqueue_scripts', 'creative_blogger_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Sanitization Callbacks.
 */
require get_template_directory() . '/inc/sanitization-callbacks.php';

/**
 * Webfont-Loader.
 */
require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/upgrade-to-pro.php';

/**
 * Google Fonts
 */
require get_template_directory() . '/inc/gfonts.php';
/**
 * select .
 */
require get_template_directory() . '/inc/select/category-dropdown-custom-control.php';
/**
 * Theme Info Page.
 */
require get_template_directory() . '/inc/addon.php';

/**
 * Load TGM.
 */
require get_template_directory() . '/inc/tgm/tgm.php';

function creative_blogger_setup_theme() {
	if ( ! defined( 'CREATIVE_BLOGGER_PRO_NAME' ) ) {
		define( 'CREATIVE_BLOGGER_PRO_NAME', __( 'About Creative Blogger', 'creative-blogger' ));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_PREMIUM_PAGE' ) ) {
	define('CREATIVE_BLOGGER_PREMIUM_PAGE',__('https://www.theclassictemplates.com/products/blog-wordpress-theme','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_THEME_PAGE' ) ) {
	define('CREATIVE_BLOGGER_THEME_PAGE',__('https://www.theclassictemplates.com/collections/best-wordpress-templates','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_SUPPORT' ) ) {
	define('CREATIVE_BLOGGER_SUPPORT',__('https://wordpress.org/support/theme/creative-blogger/','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_REVIEW' ) ) {
	define('CREATIVE_BLOGGER_REVIEW',__('https://wordpress.org/support/theme/creative-blogger/reviews/#new-post','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_PRO_DEMO' ) ) {
	define('CREATIVE_BLOGGER_PRO_DEMO',__('https://live.theclassictemplates.com/creative-blogger-pro/','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_THEME_DOCUMENTATION' ) ) {
	define('CREATIVE_BLOGGER_THEME_DOCUMENTATION',__('https://live.theclassictemplates.com/demo/docs/creative-blogger-free/','creative-blogger'));
	}
	if ( ! defined( 'CREATIVE_BLOGGER_BUNDLE_PAGE' ) ) {
		define('CREATIVE_BLOGGER_BUNDLE_PAGE',__('https://www.theclassictemplates.com/products/wordpress-theme-bundle','creative-blogger'));
	}
}
add_action( 'after_setup_theme', 'creative_blogger_setup_theme' );

/* Starter Content */
	add_theme_support( 'starter-content', array(
		'widgets' => array(
			'footer-1' => array(
				'categories',
			),
			'footer-2' => array(
				'archives',
			),
			'footer-3' => array(
				'meta',
			),
			'footer-4' => array(
				'search',
			),
		),
    ));
    
// logo
if ( ! function_exists( 'creative_blogger_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 */
function creative_blogger_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;

// Category Slider
function creative_blogger_taxonomy_add_custom_field() {
    ?>
    <div class="form-field term-image-wrap">
        <label for="cat-image"><?php echo esc_html( 'Image', 'creative-blogger' ); ?></label>
        <p><a href="#" class="creative_blogger_upload_image_button button button-secondary"><?php echo esc_html('Upload Image', 'creative-blogger'); ?></a></p>
        <input type="text" name="category_image" id="cat-image" value="" size="40" />
    </div>
    <?php
}
add_action( 'category_add_form_fields', 'creative_blogger_taxonomy_add_custom_field', 10, 2 );
 
function creative_blogger_taxonomy_edit_custom_field($creative_blogger_term) {
    $creative_blogger_image = get_term_meta($creative_blogger_term->creative_blogger_term_id, 'category_image', true);
    ?>
    <tr class="form-field term-image-wrap">
        <th scope="row"><label for="category_image"><?php echo esc_html( 'Image', 'creative-blogger' ); ?></label></th>
        <td>
            <p><a href="#" class="creative_blogger_upload_image_button button button-secondary"><?php echo esc_html('Upload Image', 'creative-blogger'); ?></a></p><br/>
            <input type="text" name="category_image" id="cat-image" value="<?php echo esc_attr($creative_blogger_image); ?>" size="40" />
        </td>
    </tr>
    <?php
}
add_action( 'category_edit_form_fields', 'creative_blogger_taxonomy_edit_custom_field', 10, 2 );

function creative_blogger_include_script() {
    if ( ! did_action( 'wp_enqueue_media' ) ) {
        wp_enqueue_media();
    }
    wp_enqueue_script( 'creative-blogger-script', get_stylesheet_directory_uri() . '/js/category.js', array('jquery'), null, false );
}
add_action( 'admin_enqueue_scripts', 'creative_blogger_include_script' );

function creative_blogger_save_taxonomy_custom_meta_field( $creative_blogger_term_id ) {
    if ( isset( $_POST['category_image'] ) ) {
        update_term_meta($creative_blogger_term_id, 'category_image', wp_unslash( $_POST['category_image']));
    }
}  
add_action( 'edited_category', 'creative_blogger_save_taxonomy_custom_meta_field', 10, 2 );  
add_action( 'create_category', 'creative_blogger_save_taxonomy_custom_meta_field', 10, 2 );

// Latest Category
function creative_blogger_get_latest_category($post_id) {
    $categories = get_the_category($post_id);
    if (empty($categories)) {
        return null;
    }

    usort($categories, function($creative_blogger_a, $creative_blogger_b) {
        return $creative_blogger_b->term_id - $creative_blogger_a->term_id;
    });

    return $categories[0];
}

/* Activation Notice */
function creative_blogger_deprecated_hook_admin_notice() {
	 $creative_blogger_theme = wp_get_theme();
	$creative_blogger_meta = get_option( 'creative_blogger_admin_notice' );

	if (!$creative_blogger_meta) {
    ?>
        <div id="creative-blogger-welcome-notice" class="getstrat updated notice notice-success welcome-notice is-dismissible notice-get-started-class">
            <div class="admin-image">
                <img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
            <div class="admin-content" >
                <h1><?php 
				/* translators: 1: Theme name, 2: Theme version. */
				printf( esc_html__( 'Welcome to %1$s %2$s', 'creative-blogger' ), esc_html($creative_blogger_theme->get( 'Name' )), esc_html($creative_blogger_theme->get( 'Version' ))); ?>
                </h1>
                <p><?php _e('Get Started With Theme By Clicking On Getting Started.', 'creative-blogger'); ?></p>
                <div style="display: grid;">
                    <a class="admin-notice-btn button button-hero upgrade-pro" target="_blank" href="<?php echo esc_url( CREATIVE_BLOGGER_PREMIUM_PAGE ); ?>"><?php esc_html_e('Upgrade Pro', 'creative-blogger') ?><i class="dashicons dashicons-cart"></i></a>
                    <a class="admin-notice-btn button button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=creative-blogger' )); ?>"><?php esc_html_e( 'Get started', 'creative-blogger' ) ?><i class="dashicons dashicons-backup"></i></a>
                    <a class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( CREATIVE_BLOGGER_THEME_DOCUMENTATION ); ?>"><?php esc_html_e('Free Doc', 'creative-blogger') ?><i class="dashicons dashicons-visibility"></i></a>
                    <a  class="admin-notice-btn button button-hero" target="_blank" href="<?php echo esc_url( CREATIVE_BLOGGER_PRO_DEMO ); ?>"><?php esc_html_e('View Demo', 'creative-blogger') ?><i class="dashicons dashicons-awards"></i></a>
                </div>
            </div>
			<div class="admin-bundle-image">
				<a href="<?php echo esc_url( CREATIVE_BLOGGER_BUNDLE_PAGE ); ?>" target="_blank"><img src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/images/image_1.webp'; ?>" /></a>
			</div>
        </div>
	<?php
    }
}
// Admin notice code START
function creative_blogger_dismissed_notice() {
	update_option( 'creative_blogger_admin_notice', true );
}
add_action( 'wp_ajax_creative_blogger_dismissed_notice', 'creative_blogger_dismissed_notice' );


//After Switch theme function
add_action('after_switch_theme', 'creative_blogger_getstart_setup_options');
function creative_blogger_getstart_setup_options () {
    update_option('creative_blogger_admin_notice', false );
}
// Admin notice code END