<?php
/**
 * Title: Feature Brands
 * Slug: crcote-corporate/feature-brands
 * Categories: crcote_features
 * 
 */
?>
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|60","bottom":"var:preset|spacing|60"}}},"className":"is-style-default","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull is-style-default" style="padding-top:var(--wp--preset--spacing--60);padding-bottom:var(--wp--preset--spacing--60)"><!-- wp:group {"align":"wide","style":{"position":{"all":"relative"},"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide" style="margin-top:0;margin-bottom:0"><!-- wp:paragraph {"align":"wide","style":{"position":{"all":"absolute"},"top":{"all":"-1.5em"},"spacing":{"margin":{"top":"0","right":"0","bottom":"var:preset|spacing|60","left":"0"}},"typography":{"fontStyle":"normal","fontWeight":"600","fontSize":"28px"}},"className":"alignwide alignwide"} -->
<p class="has-text-align-wide alignwide" style="margin-top:0;margin-right:0;margin-bottom:var(--wp--preset--spacing--60);margin-left:0;font-size:28px;font-style:normal;font-weight:600">Trusted by industry leaders:</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns {"verticalAlignment":"center","align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|lg"},"padding":{"top":"var:preset|spacing|lg","bottom":"var:preset|spacing|lg"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":{"topLeft":"0px","topRight":"0px"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center" style="border-top-left-radius:0px;border-top-right-radius:0px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--lg);padding-bottom:var(--wp--preset--spacing--lg)"><!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|lg"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":56,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 180 42\u0022\u003e\n  \u003cpath fill=\u0022currentColor\u0022 fill-rule=\u0022evenodd\u0022 d=\u0022M21.481 1.156c-.063.107-.755 2.624-1.537 5.594-.782 2.97-1.515 5.576-1.629 5.792-.114.216-.863-2.051-1.664-5.037-.869-3.243-1.585-5.381-1.778-5.31-.178.066-1.032.299-1.898.519-.866.22-1.571.543-1.567.718.004.175.674 2.809 1.488 5.855.815 3.045 1.446 5.571 1.403 5.614-.043.043-1.823-1.671-3.956-3.808L6.465 7.206 5.029 8.62l-1.437 1.415 4.265 4.272c2.345 2.349 4.203 4.323 4.129 4.386-.075.063-2.296-.469-4.936-1.182-2.64-.712-5.014-1.299-5.276-1.303-.325-.005-.626.534-.952 1.707-.263.942-.427 1.797-.364 1.898.062.1 2.617.841 5.678 1.645 3.06.805 5.564 1.544 5.564 1.643 0 .1-2.295.778-5.1 1.508-5.653 1.47-5.403 1.262-4.634 3.852.366 1.231.576 1.536.975 1.415.28-.085 2.872-.786 5.759-1.558 2.888-.772 5.283-1.429 5.324-1.46.04-.031-.343-.824-.852-1.764-.775-1.432-.925-2.039-.925-3.748 0-2.417.491-3.733 2.028-5.435 2.133-2.36 5.168-3.209 8.251-2.307 3.335.976 5.328 3.56 5.636 7.307l.188 2.282 4.95 1.299c2.723.714 5.17 1.301 5.438 1.303.619.006 1.621-3.556 1.059-3.763-.191-.07-2.833-.782-5.871-1.582-3.038-.8-5.4-1.529-5.25-1.621.151-.092 2.501-.743 5.224-1.446 2.723-.704 4.996-1.315 5.052-1.358.133-.103-.581-3.286-.826-3.682-.12-.195-2.217.235-5.732 1.175-3.049.815-5.677 1.482-5.84 1.482-.162 0 1.454-1.753 3.593-3.896l3.887-3.897-1.422-1.444-1.422-1.444-4.34 4.366-4.339 4.365 1.34-5.1c.738-2.805 1.343-5.308 1.345-5.561.003-.312-.581-.618-1.797-.944-.991-.266-1.854-.396-1.918-.289M152.1 14.602v3.203l-.721-.678c-.953-.895-2.544-1.226-4.202-.872-1.611.344-3.269 1.999-3.755 3.749-.419 1.509-.409 4.547.019 5.826 1.241 3.707 5.673 5.406 8.082 3.098l.877-.84v.806c0 .785.047.806 1.8.806h1.8V11.4h-3.9v3.202M49.2 20.661V29.7h4.2v-6.6h2.775c3.23-.001 4.331-.422 5.754-2.203.837-1.047.921-1.351.921-3.322 0-2.561-.723-3.912-2.684-5.014-1.065-.599-1.722-.686-6.08-.805l-4.886-.134v9.039m14.4.039v9h3.9v-18h-3.9v9m45.9 0v9h3.9v-4.598c0-4.418.027-4.623.694-5.25.868-.815 2.121-.837 2.906-.052.548.548.6 1 .6 5.25v4.65h3.9l-.001-5.325c-.001-4.812-.06-5.421-.607-6.318-1.356-2.225-5.856-2.549-7.262-.524-.122.174-.223-1.067-.225-2.758L113.4 11.7h-3.9v9m28.2 0v9h3.9v-18h-3.9v9m-78.871-4.538c.755.932.723 2.088-.081 2.944-.574.611-.934.694-3 .694H53.4v-4.564l2.429.111c2.115.096 2.504.201 3 .815m13.854.312c-2.002.512-3.383 2.11-3.383 3.916 0 .54.191.61 1.657.61 1.467 0 1.689-.082 1.927-.709.297-.779.872-1.091 2.01-1.091 1.053 0 1.906.525 1.906 1.174 0 .828-.541 1.116-2.819 1.506-3.853.658-5.151 1.822-5.109 4.583.019 1.234.175 1.622.971 2.418.849.849 1.168.961 3.046 1.067 1.735.098 2.284.009 3.172-.515 1.279-.754 1.339-.763 1.339-.183 0 .345.383.45 1.65.45h1.65l-.001-5.175c-.001-5.804-.229-6.608-2.158-7.606-1.108-.572-4.387-.822-5.858-.445m12.489.422c-1.775.935-2.712 2.637-2.898 5.266-.34 4.802 1.995 7.822 6.056 7.833 2.432.007 4.172-.861 5.304-2.647 1.364-2.151 1.232-2.448-1.084-2.448-1.433 0-1.95.107-1.95.404 0 .746-1.098 1.443-2.117 1.342-1.389-.137-2.168-1.31-2.301-3.467-.124-2.003.31-3.049 1.502-3.62 1.005-.483 2.301.018 2.762 1.067.262.595.516.674 2.175.674 1.694 0 1.879-.06 1.879-.615 0-1.473-1.787-3.548-3.57-4.144-1.739-.582-4.276-.425-5.758.355m14.025-.258c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286H108v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m27.783-.104c-1.571.454-3.246 2.282-3.797 4.145-.6 2.024-.604 2.805-.026 4.752.909 3.061 3.024 4.556 6.443 4.556 4.221 0 6.9-2.674 6.9-6.887 0-4.157-2.709-6.912-6.75-6.866-.99.011-2.237.146-2.77.3m34.317.104c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286h4.35v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m14.878.159c-.796.485-.975.512-.975.149 0-.345-.408-.446-1.8-.446h-1.8v13.2h3.9v-4.148c0-3.947.033-4.179.694-4.8.485-.455 1.074-.652 1.95-.652h1.256v-3.9l-1.125.001c-.619.001-1.564.269-2.1.596m-73.034 2.928c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m62.1 0c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m-33.518.55c.623.665.727 1.067.726 2.827-.001 1.757-.106 2.163-.727 2.825-.728.774-2.283 1.038-3.459.587-1.265-.486-1.829-4.043-.919-5.802.525-1.016.813-1.157 2.429-1.188.945-.019 1.387.152 1.95.751m19.641.019c.722.778.917 1.77.758 3.856-.149 1.955-1.781 3.188-3.356 2.536-1.932-.8-2.419-5.047-.745-6.487 1.102-.948 2.411-.911 3.343.095M27.678 24.635c-.665 1.494-2.971 3.754-4.304 4.219-.618.216-.849.463-.75.804.079.27.704 2.584 1.39 5.142.686 2.558 1.335 4.743 1.441 4.857.331.352 3.645-.716 3.645-1.175 0-.334-2.099-8.365-2.88-11.022-.099-.336 1.626 1.18 3.833 3.369l4.012 3.978 1.414-1.435 1.415-1.436-4.316-4.308-4.315-4.307-.585 1.314m49.422-.199c0 1.836-1.233 2.983-3.023 2.812-.902-.086-1.038-.21-1.117-1.024-.109-1.113.229-1.426 2.19-2.024 1.984-.606 1.95-.61 1.95.236M10.35 30.9l-3.892 3.9 1.421 1.421L9.3 37.642l4.2-4.192c2.31-2.306 4.2-4.295 4.2-4.421 0-.126-.182-.229-.405-.229-.223 0-.964-.405-1.647-.9-.684-.495-1.28-.9-1.325-.9-.045 0-1.833 1.755-3.973 3.9m7.342-.225c-.183.701-.795 2.976-1.362 5.054-.566 2.079-1.03 3.907-1.03 4.062 0 .237 3.614 1.401 3.786 1.22.069-.073 3.114-11.302 3.114-11.484 0-.07-.94-.127-2.088-.127h-2.089l-.331 1.275\u0022\u003e\u003c/path\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-1.png" alt="" class="wp-image-56"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":57,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 180 42\u0022\u003e\n  \u003cpath fill=\u0022currentColor\u0022 fill-rule=\u0022evenodd\u0022 d=\u0022M18.9 1.113c-6.76.565-12.473 4.145-15.895 9.964C1.101 14.313.446 16.92.473 21.15c.02 3.045.145 3.97.815 6 1.677 5.082 5.462 9.396 10.262 11.698 3.457 1.657 5.322 2.093 8.85 2.069 5.584-.038 9.829-1.823 13.809-5.806C38.3 31.016 40.2 26.541 40.2 21c0-5.459-1.91-10.024-5.843-13.96C30.136 2.815 24.484.647 18.9 1.113m7.482 8.315c.281.339.013 1.598-1.274 6L23.478 21h2.943c3.079 0 3.463.157 3.16 1.292-.214.804-13.746 10.509-14.694 10.538-1 .031-.925-1.048.397-5.645.658-2.291 1.235-4.194 1.281-4.228.047-.034 1.23-.455 2.629-.935l2.543-.872-5.137-.082c-5.419-.086-5.955-.227-5.494-1.443C11.346 18.993 25.061 9 25.688 9c.186 0 .498.193.694.428M152.1 14.602v3.203l-.721-.678c-.953-.895-2.544-1.226-4.202-.872-1.611.344-3.269 1.999-3.755 3.749-.419 1.509-.409 4.547.019 5.826 1.241 3.707 5.673 5.406 8.082 3.098l.877-.84v.806c0 .785.047.806 1.8.806h1.8V11.4h-3.9v3.202M49.2 20.661V29.7h4.2v-6.6h2.775c3.23-.001 4.331-.422 5.754-2.203.837-1.047.921-1.351.921-3.322 0-2.561-.723-3.912-2.684-5.014-1.065-.599-1.722-.686-6.08-.805l-4.886-.134v9.039m14.4.039v9h3.9v-18h-3.9v9m45.9 0v9h3.9v-4.598c0-4.418.027-4.623.694-5.25.868-.815 2.121-.837 2.906-.052.548.548.6 1 .6 5.25v4.65h3.9l-.001-5.325c-.001-4.812-.06-5.421-.607-6.318-1.356-2.225-5.856-2.549-7.262-.524-.122.174-.223-1.067-.225-2.758L113.4 11.7h-3.9v9m28.2 0v9h3.9v-18h-3.9v9m-78.871-4.538c.755.932.723 2.088-.081 2.944-.574.611-.934.694-3 .694H53.4v-4.564l2.429.111c2.115.096 2.504.201 3 .815m13.854.312c-2.002.512-3.383 2.11-3.383 3.916 0 .54.191.61 1.657.61 1.467 0 1.689-.082 1.927-.709.297-.779.872-1.091 2.01-1.091 1.053 0 1.906.525 1.906 1.174 0 .828-.541 1.116-2.819 1.506-3.853.658-5.151 1.822-5.109 4.583.019 1.234.175 1.622.971 2.418.849.849 1.168.961 3.046 1.067 1.735.098 2.284.009 3.172-.515 1.279-.754 1.339-.763 1.339-.183 0 .345.383.45 1.65.45h1.65l-.001-5.175c-.001-5.804-.229-6.608-2.158-7.606-1.108-.572-4.387-.822-5.858-.445m12.489.422c-1.775.935-2.712 2.637-2.898 5.266-.34 4.802 1.995 7.822 6.056 7.833 2.432.007 4.172-.861 5.304-2.647 1.364-2.151 1.232-2.448-1.084-2.448-1.433 0-1.95.107-1.95.404 0 .746-1.098 1.443-2.117 1.342-1.389-.137-2.168-1.31-2.301-3.467-.124-2.003.31-3.049 1.502-3.62 1.005-.483 2.301.018 2.762 1.067.262.595.516.674 2.175.674 1.694 0 1.879-.06 1.879-.615 0-1.473-1.787-3.548-3.57-4.144-1.739-.582-4.276-.425-5.758.355m14.025-.258c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286H108v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m27.783-.104c-1.571.454-3.246 2.282-3.797 4.145-.6 2.024-.604 2.805-.026 4.752.909 3.061 3.024 4.556 6.443 4.556 4.221 0 6.9-2.674 6.9-6.887 0-4.157-2.709-6.912-6.75-6.866-.99.011-2.237.146-2.77.3m34.317.104c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286h4.35v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m14.878.159c-.796.485-.975.512-.975.149 0-.345-.408-.446-1.8-.446h-1.8v13.2h3.9v-4.148c0-3.947.033-4.179.694-4.8.485-.455 1.074-.652 1.95-.652h1.256v-3.9l-1.125.001c-.619.001-1.564.269-2.1.596m-73.034 2.928c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m62.1 0c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m-33.518.55c.623.665.727 1.067.726 2.827-.001 1.757-.106 2.163-.727 2.825-.728.774-2.283 1.038-3.459.587-1.265-.486-1.829-4.043-.919-5.802.525-1.016.813-1.157 2.429-1.188.945-.019 1.387.152 1.95.751m19.641.019c.722.778.917 1.77.758 3.856-.149 1.955-1.781 3.188-3.356 2.536-1.932-.8-2.419-5.047-.745-6.487 1.102-.948 2.411-.911 3.343.095M77.1 24.436c0 1.836-1.233 2.983-3.023 2.812-.902-.086-1.038-.21-1.117-1.024-.109-1.113.229-1.426 2.19-2.024 1.984-.606 1.95-.61 1.95.236\u0022\u003e\u003c/path\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-2.png" alt="" class="wp-image-57"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":58,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 fill=\u0022currentColor\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 144.8 24.7\u0022\u003e\n  \u003cpath d=\u0022M12 23.7c-1.5-.3-2.8-.5-4.3-.7 1.2-3.1 2-6.2 3.6-9 .7 3.1.4 6.3.7 9.7zm-9.4-4.3c-.7-1.3-1.4-2.5-2.1-3.8 3.2-.9 6.1-2.2 9.4-2.6-2.1 2.4-4.8 4.2-7.3 6.4zM.3 9.5c.3-1.5.9-2.7 1.6-4 2.6 1.9 5.4 3.4 7.8 5.6-3.2 0-6.2-1-9.4-1.6zm12.7 4c2.9 1.4 5.2 3.6 7.9 5.4-.9 1.2-1.9 2.1-3.2 2.9-1.6-2.8-3.5-5.3-4.7-8.3zm.7-1.5c3-1.2 6.1-1.4 9.3-2.1.3 1.4.3 2.8 0 4.3-3.2-.8-6.3-1.1-9.3-2.2zm-.8-1.7c.9-3.1 2.7-5.7 4.1-8.5.9.2 2.6 1.6 3.4 2.6-2.5 2-4.7 4.3-7.5 5.9zm-6-9.1C8.3.9 9.7.6 11.1.2c0 3.4.5 6.5 0 9.7-1.8-2.6-2.7-5.6-4.2-8.7zm34.2 4c-.6-.4-1.3-.7-2.2-.9-.2 0-.4-.1-.6-.1h-6.8v15.1H34V14h4.3c.3 0 .4 0 .6-.1.9-.1 1.6-.4 2.2-.9.6-.4 1-1 1.3-1.7.3-.7.4-1.4.4-2.3 0-.8-.1-1.6-.4-2.3-.3-.5-.7-1-1.3-1.5zm-1 5c-.1.3-.3.6-.5.9-.2.3-.6.5-1 .6-.1 0-.3.1-.5.1H34V6.6h4.1c.2 0 .3 0 .5.1.4.1.8.3 1 .6.2.3.4.6.5.9.1.3.2.7.2 1 0 .3-.1.6-.2 1zm4-6.3h2.5v15.4h-2.5zm13.8 5.9c-.4-.7-.9-1.3-1.7-1.6-.8-.3-1.7-.5-2.7-.5-1.3 0-2.4.3-3.2.9-.8.6-1.3 1.4-1.6 2.3l2.3.7c.2-.6.5-1 1-1.2.5-.2 1-.4 1.5-.4.8 0 1.4.2 1.8.6.3.3.5.8.5 1.4-.4.1-.9.1-1.3.2-.7.1-1.4.2-2 .3s-1.1.3-1.6.4c-.6.2-1.1.5-1.5.8-.4.3-.7.7-.8 1.1-.2.4-.3.9-.3 1.5s.1 1.2.4 1.7c.3.5.7.9 1.3 1.2.6.3 1.3.5 2.1.5 1 0 1.9-.2 2.6-.6.5-.3 1-.7 1.4-1.3v1.5h2.2v-7c0-.5 0-.9-.1-1.4s-.1-.7-.3-1.1zm-2.3 6c-.1.3-.2.5-.5.8-.2.3-.6.5-1 .7-.4.2-.9.3-1.5.3-.4 0-.7-.1-1-.2s-.5-.3-.6-.5c-.1-.2-.2-.5-.2-.7 0-.2.1-.5.2-.6.1-.2.3-.3.5-.5.2-.1.5-.3.7-.4.3-.1.6-.2 1-.3.4-.1.9-.2 1.4-.3.3-.1.7-.1 1.2-.2v.7c0 .5-.1.9-.2 1.2zm8.2-5.2c.4-.3 1-.5 1.6-.5.6 0 1.1.2 1.6.5s.8.8 1 1.4l2.5-.7c-.3-1.1-.9-2-1.7-2.7-.9-.6-2-1-3.3-1-1.1 0-2.1.3-3 .8s-1.5 1.2-1.9 2.1c-.5.9-.7 1.9-.7 3.1 0 1.1.2 2.2.7 3.1.4.9 1.1 1.6 1.9 2.1.8.5 1.8.8 3 .8 1.3 0 2.3-.3 3.2-.9.9-.6 1.5-1.5 1.8-2.7l-2.6-.6c-.2.6-.5 1-.9 1.3-.4.3-.9.5-1.6.5-1 0-1.7-.3-2.2-1-.5-.7-.7-1.5-.7-2.6 0-.7.1-1.3.3-1.9.3-.4.6-.8 1-1.1zm16-2.1c-.8-.5-1.8-.8-3-.8-1.1 0-2.1.3-2.9.8-.8.5-1.5 1.2-2 2.1-.5.9-.7 2-.7 3.2 0 1.1.2 2.2.7 3 .5.9 1.2 1.6 2 2.1s1.9.7 3 .7 2.1-.3 3-.9c.9-.6 1.6-1.4 2-2.4l-2.5-.8c-.2.5-.6.9-1 1.2-.5.3-1 .4-1.6.4-1 0-1.7-.3-2.2-.9-.4-.5-.6-1.2-.7-2h8.2c.1-1.4-.1-2.5-.5-3.5-.4-.8-1-1.6-1.8-2.2zm-2.9 1.4c.9 0 1.6.3 2 .9.3.4.5 1 .6 1.7H74c.1-.6.3-1.2.6-1.6.5-.6 1.3-1 2.3-1zm16.9.7c-.2-.5-.4-1-.7-1.4s-.8-.8-1.3-1.1c-.5-.3-1.2-.4-2.1-.4-1.1 0-2 .2-2.7.7-.4.3-.7.6-1 .9v-5h-2.3v15.1h2.6v-5.8c0-.7.1-1.3.2-1.7.2-.4.4-.8.6-1.1.3-.3.5-.4.9-.5.3-.1.6-.2 1-.2.6 0 1.1.1 1.4.4.4.3.6.6.8 1 .2.4.3.8.3 1.3 0 .4.1.8.1 1.2v5.5h2.6V13c0-.3 0-.6-.1-1.1-.1-.4-.2-.8-.3-1.3zm10.5-2.1c-.8-.5-1.8-.8-3-.8-1.1 0-2.1.3-2.9.8-.8.5-1.5 1.2-2 2.1-.5.9-.7 1.9-.7 3.1 0 1.2.2 2.2.7 3.1s1.1 1.6 2 2.1c.8.5 1.8.8 3 .8s2.1-.3 3-.8c.8-.5 1.5-1.2 2-2.1.5-.9.7-1.9.7-3.1 0-1.2-.2-2.2-.7-3.1-.6-.9-1.3-1.6-2.1-2.1zm-.8 7.8c-.5.7-1.2 1-2.2 1-1 0-1.7-.3-2.2-1-.5-.7-.8-1.5-.8-2.6 0-.7.1-1.3.3-1.9.2-.5.5-1 1-1.3s1-.5 1.7-.5c1 0 1.7.3 2.2 1 .5.7.7 1.5.7 2.6.1 1.2-.2 2-.7 2.7zm5.2-12.4h2.5v15.4h-2.5zm12.4 4.7-.1-.1c-.7-.5-1.6-.8-2.7-.8s-2 .3-2.8.8-1.4 1.2-1.8 2.1c-.4.9-.6 1.9-.6 3.1 0 1.1.2 2.2.6 3.1.4.9 1 1.6 1.8 2.1s1.7.8 2.7.8c1.1 0 2-.3 2.8-.8.2-.1.3-.2.5-.4v.8h2.2v-15h-2.6v4.3zm.1 7c-.2.6-.5 1-.9 1.3-.4.3-1 .5-1.6.5-.7 0-1.2-.2-1.6-.5s-.7-.8-1-1.3-.3-1.2-.3-1.9.1-1.3.3-1.9c.2-.6.5-1 1-1.3.4-.3 1-.5 1.7-.5.6 0 1.2.2 1.6.5.4.3.7.7.9 1.3s.3 1.2.3 1.9c-.1.7-.2 1.4-.4 1.9zM134 8.5c-.8-.5-1.8-.8-3-.8-1.1 0-2.1.3-2.9.8-.8.5-1.5 1.2-2 2.1-.5.9-.7 2-.7 3.2 0 1.1.2 2.2.7 3 .5.9 1.2 1.6 2 2.1s1.9.7 3 .7 2.1-.3 3-.9c.9-.6 1.6-1.4 2-2.4l-2.5-.8c-.2.5-.6.9-1 1.2-.5.3-1 .4-1.6.4-1 0-1.7-.3-2.2-.9-.4-.5-.6-1.2-.7-2h8.2c.1-1.4-.1-2.5-.5-3.5-.4-.8-1-1.6-1.8-2.2zm-2.9 1.4c.9 0 1.6.3 2 .9.3.4.5 1 .6 1.7h-5.6c.1-.6.3-1.2.6-1.6.6-.6 1.4-1 2.4-1zM143.3 8c-.4 0-.7.1-1 .2-.3.1-.6.3-.9.4-.3.2-.6.5-.8.8-.1.1-.2.3-.3.4V8h-2.2v11.3h2.5v-5.8c0-.4.1-.8.2-1.2.1-.4.3-.7.5-1 .2-.3.5-.5.9-.7.3-.2.7-.3 1.2-.4.4 0 .8 0 1.2.1V8h-1.3z\u0022/\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-3.png" alt="" class="wp-image-58"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":59,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg fill=\u0022currentColor\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 style=\u0022enable-background:new 0 0 900 156\u0022 viewBox=\u00220 0 900 156\u0022 width=\u0022121\u0022\u003e\u003cpath d=\u0022M151.4 65c-.1-.4-.1-.8-.2-1-4.4-24.5-20.4-45.1-43-55.4C102.5 5.8 96.5 4 90.3 3c-2.6-.4-5.1-.3-7.7-.7H71.2c-.2.2-.6.1-.8.1-5 0-9.8.8-14.6 2.1-3.2 1-6.5 2.2-9.6 3.5-9.9 4.4-18.7 10.9-25.9 19-6.7 7.4-11.7 16.2-15 25.6-1.5 4.1-2.6 8.3-3 12.7.1 2.1 0 4.4-.3 6.7v10.6c.3.3.1.6.1 1 0 3.2.4 6.5.9 9.7 1 4.8 2.5 9.3 4.4 13.7 7.4 17.3 21.1 31.2 38.3 39 5.6 2.7 11.6 4.5 17.8 5.5.6.1 1 .1 1.5.2 6.3.6 12.6.8 19 .4 2 0 4-.2 6-.4 31-5.4 55.4-29.5 61.1-60.6.5-3.1.7-6.4.7-9.5.4-5.6.3-11.1-.4-16.6zm-24.6 30.8c-7.1 22.1-27.8 36.7-50.8 35.9-11.1-.9-21.8-5.2-30.2-12.6-2.6-2.1-3.8-1.8-5.8.4-2 1.9-4.1 3.8-6.2 5.5-.6-2.6-1-5.2-1.5-7.9l-5.7-33c-.3-1.4.5-1 1.2-.9 13 3.5 26 7 38.9 10.5.9.2 1.1.4.3 1-1.8 1.8-3.8 3.6-5.8 5.2-3.7 2.5-2.4 3.8.7 5.6 18.3 11.2 38.3 4.3 45.1-15.9.4-1.1 1-.8 1.6-.7 5.5 1.4 11 2.9 16.6 4.2 1.7.5 2 1.1 1.6 2.7zm-.7-20.7c-13.1-3.5-26.2-7-39.3-10.6-.9-.2-1-.4-.3-1 1.6-1.6 3.2-3.1 5-4.5 5-3.1 3-4.9-.9-7-18.4-10.2-37-3.3-44.1 16.6-.3.4-.9.7-1.3.6-5.2-1.2-10.4-2.9-15.6-3.8-3.1-.6-3.2-1.7-2.3-4.4 6.6-20.2 26-34.4 50.6-34.3 10.7.9 20.9 5 29 12 3.1 2.6 4.9 2.4 7.3-.4 1.7-1.7 3.6-3.4 5.5-5 .5 2.4 1 4.8 1.4 7.2 2 11.2 3.9 22.5 5.9 33.8.2 1.1-.1 1.1-.9.8z\u0022\u003e\u003c/path\u003e\u003cpath d=\u0022M245.8 99.9c-4.3 2.9-9.4 4.3-15.4 4.3-5.3 0-9.9-1.3-13.9-3.8s-7-6.1-9.2-10.7c-2.2-4.6-3.2-9.9-3.2-16 0-6.3 1.1-11.8 3.2-16.3s5.2-8.1 9.2-10.6c4-2.5 8.6-3.7 13.9-3.7 5.9 0 10.9 1.4 15.1 4.3 4.1 2.8 6.9 6.8 8.5 11.9h16.2c-1-6.3-3.2-11.8-6.8-16.4-3.6-4.6-8.2-8.2-13.7-10.7-5.5-2.6-11.8-3.8-18.7-3.8-8.5 0-16 1.9-22.4 5.6-6.5 3.8-11.5 9-15.1 15.8-3.6 6.8-5.3 14.8-5.3 23.9 0 9.2 1.7 17.2 5.2 23.9 3.5 6.8 8.4 12 14.6 15.7 6.3 3.7 13.7 5.6 22.3 5.6 7 0 13.3-1.3 18.9-3.8 5.6-2.6 10.3-6.2 14-10.8 3.7-4.6 6.1-10 7.3-16.1h-16c-1.6 4.9-4.5 8.8-8.7 11.7zM323.5 60.5c-4.8-2.6-10.2-4-16.4-4-6.1 0-11.5 1.3-16.3 4-4.8 2.6-8.6 6.3-11.3 11-2.7 4.7-4.1 10.1-4.1 16.3 0 6.2 1.4 11.6 4.1 16.3 2.7 4.7 6.5 8.3 11.3 11 4.8 2.6 10.2 4 16.3 4 6.2 0 11.6-1.3 16.4-4 4.8-2.6 8.5-6.3 11.2-11 2.7-4.7 4.1-10.1 4.1-16.3 0-6.2-1.4-11.6-4.1-16.3-2.7-4.7-6.4-8.4-11.2-11zM322 97.2c-1.4 2.7-3.4 4.8-6 6.4-2.6 1.5-5.5 2.3-8.9 2.3-3.4 0-6.3-.8-8.8-2.3-2.5-1.5-4.5-3.6-6-6.4-1.5-2.7-2.2-5.9-2.2-9.5 0-3.7.7-6.9 2.2-9.5 1.5-2.7 3.5-4.8 6-6.3s5.5-2.3 8.8-2.3c3.4 0 6.3.8 8.9 2.3 2.6 1.5 4.6 3.6 6 6.3 1.4 2.7 2.2 5.9 2.2 9.5 0 3.6-.7 6.8-2.2 9.5zM381.2 56.4c-4 0-7.7.8-11.1 2.5-3.4 1.7-6 4-7.9 7l-1.2-7.7h-13.6v59.3H362V85.6c0-4.8 1.3-8.6 3.8-11.5 2.6-2.9 6.1-4.3 10.7-4.3 3.8 0 6.9 1.2 9.1 3.7 2.2 2.4 3.4 6.1 3.4 11.1v33h14.6V81c0-7.6-1.9-13.6-5.7-18-3.7-4.4-9.3-6.6-16.7-6.6zM454.7 58.2l-10.8 27.2c-1.3 3.3-2.4 6.4-3.4 9.3-1 2.9-1.7 5.3-2.1 7.1-.4-1.6-1.1-3.9-2-6.8-.9-2.9-2-6.1-3.3-9.7l-10.3-27.2h-15.6l23.5 59.3h14.4l24.7-59.3h-15.1zM509.2 104.8c-2.6 1.5-5.9 2.3-9.9 2.3-5.4 0-9.5-1.6-12.3-4.9-2.2-2.6-3.5-6.2-4-10.8l44.6-.1v-4.4c0-6.2-1.2-11.6-3.5-16.1-2.4-4.5-5.7-8-10-10.5s-9.5-3.8-15.5-3.8c-5.8 0-10.9 1.3-15.4 4s-8 6.4-10.4 11.1c-2.5 4.7-3.7 10.2-3.7 16.3 0 6.1 1.3 11.5 3.8 16.1 2.6 4.7 6.1 8.4 10.6 11 4.5 2.7 9.7 4 15.5 4 7.8 0 14.2-1.8 19.3-5.5 5.1-3.7 8.3-8.8 9.5-15.2h-13.6c-.7 2.8-2.4 5-5 6.5zM490 70.6c2.4-1.4 5.3-2.2 8.7-2.2 4.4 0 7.9 1.2 10.5 3.7 2.6 2.5 3.9 5.8 3.9 9.8h-29.8c.3-1.8.8-3.4 1.4-4.9 1.1-2.8 2.9-5 5.3-6.4zM567.1 57.3c-4.7 0-8.6 1.2-11.5 3.7-2 1.7-3.5 3.7-4.5 6.1l-.9-8.7h-13.8v59.2H551V88.7c0-5.8 1.5-10.1 4.6-12.9 3-2.8 7.2-4.3 12.6-4.3h5.4V58c-1.2-.3-2.3-.5-3.4-.6-1.1-.1-2.1-.1-3.1-.1zM603.1 39.7h-14.7v18.5H577v12.3h11.4v47h14.7v-47h11.4V58.2h-11.4zM672.9 33.4c-4.3-2.4-9.4-3.6-15.4-3.6h-34.7v87.7h15.4V87.3h19.3c5.9 0 11-1.2 15.4-3.7 4.3-2.4 7.7-5.8 10.1-10.2 2.4-4.4 3.6-9.3 3.6-14.9 0-5.8-1.2-10.8-3.6-15.1-2.4-4.3-5.8-7.6-10.1-10zm-6.5 36.2c-2.8 2.7-6.8 4-12.1 4h-16.1V43.5h16.3c5.1 0 9.1 1.3 11.8 3.8 2.8 2.6 4.1 6.2 4.1 11 .1 4.8-1.3 8.6-4 11.3zM725.1 57.3c-4.7 0-8.6 1.2-11.5 3.7-2 1.7-3.5 3.7-4.5 6.1l-.9-8.7h-13.8v59.2H709V88.7c0-5.8 1.5-10.1 4.6-12.9 3-2.8 7.2-4.3 12.6-4.3h5.4V58c-1.2-.3-2.3-.5-3.4-.6-1-.1-2.1-.1-3.1-.1zM773.2 104.8c-2.6 1.5-5.9 2.3-9.9 2.3-5.4 0-9.5-1.6-12.3-4.9-2.2-2.6-3.5-6.2-4-10.8l44.6-.1v-4.4c0-6.2-1.2-11.6-3.5-16.1-2.4-4.5-5.7-8-10-10.5s-9.5-3.8-15.5-3.8c-5.8 0-10.9 1.3-15.4 4s-8 6.4-10.4 11.1c-2.5 4.7-3.7 10.2-3.7 16.3 0 6.1 1.3 11.5 3.8 16.1 2.6 4.7 6.1 8.4 10.6 11 4.5 2.7 9.7 4 15.5 4 7.8 0 14.2-1.8 19.3-5.5 5.1-3.7 8.3-8.8 9.5-15.2h-13.6c-.7 2.8-2.4 5-5 6.5zM754 70.6c2.4-1.4 5.3-2.2 8.7-2.2 4.4 0 7.9 1.2 10.5 3.7 2.6 2.5 3.9 5.8 3.9 9.8h-29.8c.3-1.8.8-3.4 1.4-4.9 1.1-2.8 2.9-5 5.3-6.4zM829.7 83.7 819 81.2c-5.1-1.2-7.7-3.4-7.7-6.7 0-2.2.8-3.9 2.4-5.2 1.6-1.3 3.8-1.9 6.7-1.9s5.1.7 6.7 2.2c1.6 1.5 2.4 3.5 2.4 6.1h13.9c-.1-3.8-1.1-7.2-2.9-10.1-1.9-2.9-4.5-5.1-7.9-6.7-3.4-1.6-7.2-2.4-11.6-2.4-4.6 0-8.6.7-12.1 2.2-3.5 1.5-6.3 3.6-8.3 6.4-2 2.8-3.1 6.1-3.1 10 0 4.7 1.3 8.4 3.9 11.1 2.6 2.7 6.6 4.6 11.9 5.8l10.7 2.5c2.6.6 4.4 1.4 5.4 2.5s1.4 2.4 1.4 3.8c0 2.2-.9 3.9-2.7 5.2-1.8 1.3-4.5 1.9-8 1.9-3.3 0-5.8-.8-7.7-2.3-1.8-1.5-2.8-3.6-2.9-6.1h-13.9c0 5.8 2.2 10.6 6.5 14.2 4.4 3.6 10.2 5.4 17.6 5.4 4.9 0 9.2-.8 13-2.3 3.8-1.6 6.7-3.8 8.8-6.7 2.1-2.9 3.1-6.4 3.1-10.4 0-4.6-1.3-8.1-3.8-10.6-2.4-2.5-6.1-4.3-11.1-5.4zM893.5 89.1c-2.5-2.5-6.3-4.3-11.2-5.4l-10.7-2.5c-5.1-1.2-7.7-3.4-7.7-6.7 0-2.2.8-3.9 2.4-5.2 1.6-1.3 3.8-1.9 6.7-1.9s5.1.7 6.7 2.2c1.6 1.5 2.4 3.5 2.4 6.1H896c-.1-3.8-1.1-7.2-2.9-10.1-1.9-2.9-4.5-5.1-7.9-6.7-3.4-1.6-7.2-2.4-11.6-2.4-4.6 0-8.6.7-12.1 2.2-3.5 1.5-6.3 3.6-8.3 6.4-2 2.8-3.1 6.1-3.1 10 0 4.7 1.3 8.4 3.9 11.1 2.6 2.7 6.6 4.6 11.9 5.8l10.7 2.5c2.6.6 4.4 1.4 5.4 2.5s1.4 2.4 1.4 3.8c0 2.2-.9 3.9-2.7 5.2-1.8 1.3-4.5 1.9-8 1.9-3.3 0-5.8-.8-7.7-2.3-1.8-1.5-2.8-3.6-2.9-6.1h-13.9c0 5.8 2.2 10.6 6.5 14.2 4.4 3.6 10.2 5.4 17.6 5.4 4.9 0 9.2-.8 13-2.3 3.8-1.6 6.7-3.8 8.8-6.7 2.1-2.9 3.1-6.4 3.1-10.4.1-4.6-1.2-8.2-3.7-10.6z\u0022\u003e\u003c/path\u003e\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-4.png" alt="" class="wp-image-59"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"margin":{"top":"0","right":"0","bottom":"0","left":"0"}}}} -->
<div class="wp-block-column is-vertically-aligned-center" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0"><!-- wp:columns {"verticalAlignment":"center","isStackedOnMobile":false,"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|lg","left":"var:preset|spacing|lg"}}}} -->
<div class="wp-block-columns alignwide are-vertically-aligned-center is-not-stacked-on-mobile"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":60,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg fill=\u0022currentColor\u0022 xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 style=\u0022enable-background:new 0 0 632 250\u0022 viewBox=\u00220 0 632 250\u0022 width=\u0022120\u0022\u003e\u003cpath d=\u0022M195.7 85.2c15.9 0 30.1 11.6 30.1 30.5 0 18.8-14.2 30.5-30.1 30.5-15.8 0-30-11.6-30-30.5-.1-18.9 14.1-30.5 30-30.5zm0 49.9c9.1 0 18.3-6.3 18.3-19.5s-9.2-19.5-18.3-19.5c-9 0-18.2 6.3-18.2 19.5s9.2 19.5 18.2 19.5zM233.5 160.6v-56.3h10.6v5c1.8-3.1 6.4-5.9 12.5-5.9 11.9 0 18.7 9.1 18.7 21.1 0 12.3-7.7 21.4-19.2 21.4-5.6 0-9.7-2.2-11.7-5v19.6h-10.9v.1zm21-47.3c-5.6 0-10.2 4.2-10.2 11.4s4.5 11.5 10.2 11.5c5.6 0 10.1-4.2 10.1-11.5-.1-7.2-4.5-11.4-10.1-11.4zM296.3 104.3h8.2v9.7h-8.2v17c0 3.6 1.7 4.7 4.8 4.7 1.3 0 2.8-.2 3.4-.3v9.1c-1 .4-3 1-6.2 1-7.9 0-12.9-4.7-12.9-12.5v-18.9H278v-9.7h2.1c4.3 0 6.3-2.8 6.3-6.4v-5.7h9.9v12zM316.8 84.2c3.8 0 6.8 3.1 6.8 6.9 0 3.6-3 6.7-6.8 6.7-3.7 0-6.8-3.1-6.8-6.7 0-3.8 3.1-6.9 6.8-6.9zm-5.5 60.8v-40.6h11V145h-11zM331.7 145v-40.6h10.5v5c2.2-4 7.4-6.1 11.9-6.1 5.5 0 10 2.4 12.1 6.8 3.2-5 7.5-6.8 12.9-6.8 7.5 0 14.7 4.5 14.7 15.4V145H383v-24.1c0-4.4-2.1-7.7-7.2-7.7-4.7 0-7.5 3.6-7.5 8V145h-10.9v-24.1c0-4.4-2.2-7.7-7.2-7.7-4.8 0-7.6 3.5-7.6 8V145h-10.9zM408.2 84.2c3.8 0 6.8 3.1 6.8 6.9 0 3.6-3 6.7-6.8 6.7-3.7 0-6.8-3.1-6.8-6.7 0-3.8 3-6.9 6.8-6.9zm-5.5 60.8v-40.6h11V145h-11zM420.4 145v-9.7l19.2-21.5h-18.7v-9.5h32.8v9.2l-19.8 21.9H454v9.6h-33.6zM497.2 133.3c-2.1 7-8.5 12.9-18.5 12.9-11.1 0-21-8-21-21.7 0-13 9.6-21.4 20-21.4 12.5 0 20.1 8 20.1 21.1 0 1.6-.2 3.2-.2 3.4h-29.1c.2 5.4 4.8 9.2 10.2 9.2 5.1 0 7.9-2.6 9.2-6.2l9.3 2.7zM486.9 120c-.2-4-2.8-8-9.1-8-5.7 0-8.8 4.3-9.1 8h18.2zM568.5 86.4h11.6L564 145h-11.7l-13.4-41.7-13.4 41.7h-11.9l-16.3-58.5h12.1l10.7 40.3 13-40.3h11.8l13 40.4 10.6-40.5zM597.2 122.9v22h-11.4V86.4h21.9c11.6 0 19.2 7.7 19.2 18.2 0 10.6-7.7 18.2-19.2 18.2l-10.5.1zm9.1-9.8c5.7 0 9.2-3.3 9.2-8.3 0-5.2-3.5-8.4-9.2-8.4h-9v16.8l9-.1zM69.7 57.3c-49.5 0-61.9 12.4-61.9 61.9s12.4 61.9 61.9 61.9 61.9-12.4 61.9-61.9-12.4-61.9-61.9-61.9zM109 158.5c-5.6 5.6-17.8 8.2-39.3 8.2s-33.7-2.5-39.3-8.2c-5.6-5.6-8.2-17.8-8.2-39.3 0-21.6 2.5-33.7 8.2-39.3 5.6-5.6 17.8-8.2 39.3-8.2 21.6 0 33.7 2.5 39.3 8.2 5.6 5.6 8.2 17.8 8.2 39.3s-2.6 33.7-8.2 39.3z\u0022\u003e\u003c/path\u003e\u003cpath d=\u0022m11.458 146.563 35.497-35.496 10.182 10.182-35.496 35.497zM57.154 141.61l59.255-59.255 10.182 10.183-59.255 59.255z\u0022\u003e\u003c/path\u003e\u003cpath d=\u0022m36.832 121.218 10.182-10.182 30.617 30.617-10.182 10.183z\u0022\u003e\u003c/path\u003e\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-5.png" alt="" class="wp-image-60"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":61,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 180 42\u0022\u003e\n  \u003cpath fill=\u0022currentColor\u0022 fill-rule=\u0022evenodd\u0022 d=\u0022M18.15 1.418c-1.432.204-1.47.551-.105.96.695.208 2.961 1.162 5.035 2.119 4.547 2.1 7.465 3 10.457 3.226 2.668.202 2.698.048.363-1.888C29.758 2.4 23.526.653 18.15 1.418M7.71 6.638 5.85 8.373l2.55.016c4.837.029 9.012 1.058 14.685 3.617 4.755 2.146 7.933 3.014 11.751 3.211 1.753.09 3.673.073 4.268-.039l1.081-.202-.487-1.263c-.269-.695-.599-1.387-.733-1.538-.135-.152-1.111-.244-2.169-.206-4.44.161-9.684-1.124-15.745-3.859-3.873-1.748-6.702-2.635-9.441-2.963l-2.041-.243L7.71 6.638m144.39 7.964v3.203l-.721-.678c-.953-.895-2.544-1.226-4.202-.872-1.611.344-3.269 1.999-3.755 3.749-.419 1.509-.409 4.547.019 5.826 1.241 3.707 5.673 5.406 8.082 3.098l.877-.84v.806c0 .785.047.806 1.8.806h1.8V11.4h-3.9v3.202M49.2 20.661V29.7h4.2v-6.6h2.775c3.23-.001 4.331-.422 5.754-2.203.837-1.047.921-1.351.921-3.322 0-2.561-.723-3.912-2.684-5.014-1.065-.599-1.722-.686-6.08-.805l-4.886-.134v9.039m14.4.039v9h3.9v-18h-3.9v9m45.9 0v9h3.9v-4.598c0-4.418.027-4.623.694-5.25.868-.815 2.121-.837 2.906-.052.548.548.6 1 .6 5.25v4.65h3.9l-.001-5.325c-.001-4.812-.06-5.421-.607-6.318-1.356-2.225-5.856-2.549-7.262-.524-.122.174-.223-1.067-.225-2.758L113.4 11.7h-3.9v9m28.2 0v9h3.9v-18h-3.9v9M4.684 12.596c-.806.146-1.565.376-1.686.51-.318.354-1.306 3.086-1.166 3.226.065.065.793-.011 1.618-.168.825-.158 2.939-.29 4.699-.294 5.236-.01 8.383.763 14.855 3.651 5.632 2.513 8.07 3.112 12.696 3.122 2.062.004 4.121-.097 4.575-.224.773-.216.825-.336.825-1.888v-1.658l-1.125.238c-.619.132-2.678.216-4.575.188-4.041-.061-7.895-.932-11.794-2.667-5.525-2.458-6.616-2.885-8.836-3.462-2.624-.681-7.857-.979-10.086-.574m54.145 3.566c.755.932.723 2.088-.081 2.944-.574.611-.934.694-3 .694H53.4v-4.564l2.429.111c2.115.096 2.504.201 3 .815m13.854.312c-2.002.512-3.383 2.11-3.383 3.916 0 .54.191.61 1.657.61 1.467 0 1.689-.082 1.927-.709.297-.779.872-1.091 2.01-1.091 1.053 0 1.906.525 1.906 1.174 0 .828-.541 1.116-2.819 1.506-3.853.658-5.151 1.822-5.109 4.583.019 1.234.175 1.622.971 2.418.849.849 1.168.961 3.046 1.067 1.735.098 2.284.009 3.172-.515 1.279-.754 1.339-.763 1.339-.183 0 .345.383.45 1.65.45h1.65l-.001-5.175c-.001-5.804-.229-6.608-2.158-7.606-1.108-.572-4.387-.822-5.858-.445m12.489.422c-1.775.935-2.712 2.637-2.898 5.266-.34 4.802 1.995 7.822 6.056 7.833 2.432.007 4.172-.861 5.304-2.647 1.364-2.151 1.232-2.448-1.084-2.448-1.433 0-1.95.107-1.95.404 0 .746-1.098 1.443-2.117 1.342-1.389-.137-2.168-1.31-2.301-3.467-.124-2.003.31-3.049 1.502-3.62 1.005-.483 2.301.018 2.762 1.067.262.595.516.674 2.175.674 1.694 0 1.879-.06 1.879-.615 0-1.473-1.787-3.548-3.57-4.144-1.739-.582-4.276-.425-5.758.355m14.025-.258c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286H108v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m27.783-.104c-1.571.454-3.246 2.282-3.797 4.145-.6 2.024-.604 2.805-.026 4.752.909 3.061 3.024 4.556 6.443 4.556 4.221 0 6.9-2.674 6.9-6.887 0-4.157-2.709-6.912-6.75-6.866-.99.011-2.237.146-2.77.3m34.317.104c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286h4.35v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m14.878.159c-.796.485-.975.512-.975.149 0-.345-.408-.446-1.8-.446h-1.8v13.2h3.9v-4.148c0-3.947.033-4.179.694-4.8.485-.455 1.074-.652 1.95-.652h1.256v-3.9l-1.125.001c-.619.001-1.564.269-2.1.596m-73.034 2.928c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m62.1 0c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m-33.518.55c.623.665.727 1.067.726 2.827-.001 1.757-.106 2.163-.727 2.825-.728.774-2.283 1.038-3.459.587-1.265-.486-1.829-4.043-.919-5.802.525-1.016.813-1.157 2.429-1.188.945-.019 1.387.152 1.95.751m19.641.019c.722.778.917 1.77.758 3.856-.149 1.955-1.781 3.188-3.356 2.536-1.932-.8-2.419-5.047-.745-6.487 1.102-.948 2.411-.911 3.343.095M4.95 19.921c-.165.062-1.076.272-2.025.467l-1.725.355.005 1.254c.021 5.086 3.324 11.495 7.645 14.835 3.786 2.927 6.713 3.997 11.485 4.2 6.25.266 10.495-1.349 14.801-5.633 2.112-2.1 2.807-3.037 3.796-5.11 1.972-4.133 2.29-3.737-3.011-3.751-4.007-.01-4.93-.111-7.481-.814-1.601-.441-4.571-1.558-6.6-2.482-5.609-2.554-8.035-3.188-12.69-3.322-2.145-.061-4.035-.061-4.2.001m72.15 4.515c0 1.836-1.233 2.983-3.023 2.812-.902-.086-1.038-.21-1.117-1.024-.109-1.113.229-1.426 2.19-2.024 1.984-.606 1.95-.61 1.95.236\u0022\u003e\u003c/path\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-6.png" alt="" class="wp-image-61"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":62,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 5690.4 1296.9\u0022 fill=\u0022currentColor\u0022 width=\u0022100\u0022 height=\u002233\u0022\u003e\n  \u003cpath d=\u0022M588.2 312.8c10 79.9 20 159.9 29.9 239.8 2.3 18.4 4.7 36.8 7 55.2.7 0 1.3 0 2 .1.4-1.8 1-3.5 1.2-5.3 5-40.3 9.9-80.6 14.9-121 16.1-128.7 32.4-257.4 48.3-386.1 3.5-28.3-6.6-51.3-30.8-66.7-22.1-14.1-45.5-14.2-67.8-.6-24.4 14.9-35.3 37.7-31.9 66.1 8.8 72.8 18.2 145.6 27.2 218.5zm-76.6 319.6c34.8-4.3 69.6-8.7 104.5-13.1v-2.5c-18.5-2.3-37-4.7-55.5-7-73.8-9.2-147.7-18.4-221.6-27.6-78.9-9.9-157.8-20-236.8-29.5-28-3.4-50.5 7.4-65.5 31.3-13.9 22.2-13.9 45.6-.1 67.8 14.9 24 37.4 34.8 65.3 31.5 62.4-7.3 124.7-15.5 187-23.3 74.3-9.2 148.5-18.4 222.7-27.6zm638.5-79.6c-72.9 8.7-145.7 18.1-218.5 27.2-79.9 10-159.9 20-239.8 29.9-18.4 2.3-36.8 4.7-55.2 7v2c1.8.4 3.5.9 5.3 1.2 40.3 5 80.6 9.9 121 14.9 128.7 16.1 257.4 32.4 386.1 48.3 28.3 3.5 51.3-6.6 66.7-30.8 14-22.1 14.2-45.5.6-67.8-15-24.5-37.8-35.3-66.2-31.9zM666.2 938.1c-9.2-73.8-18.4-147.7-27.6-221.6-3.7-29.4-7.4-58.8-11-88.2h-2.5c-2.3 18.5-4.7 37-7 55.5-9.2 73.8-18.4 147.7-27.6 221.5-9.9 78.9-20 157.8-29.5 236.8-3.4 28 7.4 50.5 31.3 65.5 22.2 13.9 45.6 13.9 67.8.1 24-14.9 34.8-37.4 31.5-65.3-8-68.1-16.9-136.2-25.4-204.3zm-47.3-313.9c-2.7 2-5.4 3.9-8 5.9-133.2 103.7-266.4 207.4-399.7 311.1-23 17.9-32.2 41.2-25.8 69.6 5.8 25.6 22.3 42.1 47.8 48 28.3 6.5 51.8-2.5 69.7-25.5 76.2-97.9 152.4-195.7 228.6-293.6 29.6-38 59.1-76 88.7-114-.4-.4-.8-1-1.3-1.5zm422.9 317.2C947.4 867.9 853 794.5 758.7 721c-41.5-32.3-83-64.6-124.6-96.9-.5.4-1 .7-1.5 1.1 1.7 2.5 3.4 5.1 5.2 7.5l311.7 400.5c17.9 23 41.2 32.2 69.6 25.9 25.6-5.8 42.2-22.3 48.1-47.8 6.6-28.4-2.4-51.9-25.4-69.9zM211.2 294.8C317.9 378 424.7 461.1 531.5 544.2c29.1 22.6 58.1 45.2 87.2 67.8l1.5-1.5c-1.8-2.4-3.5-4.9-5.4-7.3C510.9 469.7 407 336.3 303.1 202.8c-17.9-23-41.3-32.2-69.7-25.6-25.6 5.9-42.1 22.4-47.9 48-6.5 28.3 2.7 51.7 25.7 69.6zm421.5 315.9c.3.4.6.7 1 1.1 1.3-.8 2.7-1.5 4-2.5 135.9-105.8 271.9-211.5 407.6-317.5 15.4-12 22.9-28.7 24-48.1 1.6-28.7-15.3-54.5-41.5-64.4-27.9-10.5-58.4-1.8-77.1 22.2-104.3 134-208.7 268-313 402.1-1.9 2.3-3.4 4.8-5 7.1zm1450.2-16.2c20.4-11.9 37.7-28.1 51.7-48.5 21.5-31.2 32.2-68.6 32.2-112.2 0-35.9-8.6-70.1-25.9-102.6s-42.9-59-77-79.5-76.3-30.8-126.5-30.8h-311.3v792h341c50.2 0 93-9.6 128.4-28.9 35.4-19.2 62.3-46.1 80.8-80.6s27.8-75 27.8-121.5c0-48-13.6-90.1-40.7-126.2-20.2-27-47.1-47.4-80.5-61.2zm-340.2-265.2h193.1c34.5 0 62 9.9 82.5 29.7 20.5 19.8 30.8 45.1 30.8 75.9 0 23.1-5 42.8-15.1 59.1-10.1 16.3-23.7 28.8-40.7 37.4-17.1 8.6-36.2 12.9-57.5 12.9h-193.1v-215zM2068.6 846c-11.9 18.5-28.2 32.7-49 42.6s-44.1 14.8-70.1 14.8h-206.8V652.7h214c26.4 0 49.4 5.6 69 16.8 19.6 11.2 34.6 26.4 45.1 45.6 10.4 19.2 15.7 40.8 15.7 64.6 0 25.7-6 47.8-17.9 66.3zm478-430.1c-19.4 1.3-38.4 5-56.9 11s-35.3 14.6-50.3 25.6c-15.4 10.3-29 23.4-40.7 39.3-5.2 7.1-10 14.5-14.3 22.2v-95h-102.3v594h116V713.2c0-23.5 2.4-45.7 7.1-66.8 4.8-21.1 12.6-40.2 23.4-57.5s25.6-31.9 44.3-44c19.8-12.8 41.5-20.3 65.2-22.5s45.2-.7 64.6 4.4V419c-17.9-3.3-36.6-4.3-56.1-3.1zm567.2 98.8c-18.3-39.2-47.2-67.9-86.6-86.1-39.4-18.2-85.7-27.2-138.9-27.2-68.6 0-123.5 15-164.7 45.1-41.2 30.1-69.2 70.6-83.9 121.5l107.2 33c10.2-33.4 28.4-57.3 54.4-71.8s54.6-21.7 85.8-21.7c49.5 0 84.4 11.3 104.8 33.8 17.8 19.7 27.5 48.5 29.2 86.5-22.5 3.2-45 6.3-67.7 9.5-36.8 5.1-72 10.6-105.3 16.5-33.4 5.9-63.2 12.7-89.6 20.3-30.4 9.9-56.1 22.8-77 38.8-20.9 16-36.7 35.3-47.3 58-10.6 22.7-16 49.1-16 79.2 0 32.3 7.6 61.9 22.8 88.8 15.2 27 37.7 48.6 67.4 64.9 29.7 16.3 66.5 24.5 110.5 24.5 55.4 0 102-11.1 140-33.3 28.4-16.6 53.1-39.7 74-69.4v86.2h101.8V646.2c0-24.9-1.1-48.2-3.3-69.8s-8.1-42.2-17.6-61.7zm-94.9 242.6c-.9 22-4.5 41.8-10.7 59.4-4.4 19.4-13.8 38.1-28.1 56.1s-33.2 32.7-56.6 44.3c-23.5 11.6-51.5 17.3-84.2 17.3-24.6 0-44.7-3.8-60.5-11.5s-27.5-18.1-35.2-31.1-11.5-27.2-11.5-42.6c0-15.8 3.6-29.2 10.7-40.2s16.9-20.3 29.2-28c12.3-7.7 26.3-14.3 42.1-19.8 18.7-5.9 40-10.9 64.1-15.1 24-4.2 50.9-8.5 80.6-12.9 19.1-2.8 39.5-5.9 61.3-9.2-.3 9.6-.7 20.7-1.2 33.3zm736-212.4c-9.2-25.3-22.5-48.7-39.9-70.1-17.4-21.4-40.1-38.8-67.9-52-27.9-13.2-62.3-19.8-103.4-19.8-53.5 0-99.2 11.6-137 34.7-23.1 14.1-42.9 31.7-59.4 52.6V419h-102.8v594h116.6V703.9c0-35.2 3.9-65.1 11.8-89.7 7.9-24.6 18.7-44.4 32.5-59.4s29.8-26 48.1-32.7c18.3-6.8 37.8-10.2 58.3-10.2 31.5 0 57.1 6.4 76.7 19.2 19.6 12.8 34.8 29.7 45.7 50.6s18.1 43.5 22 67.9c3.8 24.4 5.8 48.1 5.8 71.2v292h116.6V683c0-18.3-1.7-39.6-5-63.8-3.3-24.2-9.5-49-18.7-74.3zm535-85.5c-6.4-5.7-13.1-11-20.1-16-38.3-27.3-85.5-41-141.6-41-55.8 0-103.9 13.7-144.4 41S3912 508 3890 555.1c-22 47.1-33 100.6-33 160.3 0 59.4 10.9 112.8 32.7 160.3s52.8 85 93 112.5 87.9 41.3 143.3 41.3c56.8 0 104.5-13.8 143-41.5 12.3-8.9 23.7-18.7 34.1-29.6v54.6h102.3V221h-115.5v238.4zm-3.3 364.9c-11 31.5-28.4 56.3-52.2 74.2-23.8 18-54.6 26.9-92.4 26.9-36.7 0-67-9.3-91-28s-42-43.9-53.9-75.6c-11.9-31.7-17.9-67.2-17.9-106.4 0-38.9 6-74.1 17.9-105.6 11.9-31.5 30.2-56.7 54.7-75.4 24.6-18.7 55.9-28 94.1-28 35.9 0 65.5 8.8 88.8 26.4s40.5 42.2 51.7 73.7c11.2 31.5 16.8 67.8 16.8 108.9s-5.6 77.4-16.6 108.9zm240-405.3h115v594h-115zm0-209h115v111.7h-115zm426.6-4.9c-17.8 1.1-35.7 5.1-53.6 12.1s-34.5 18.7-49.5 35.2c-12.5 13.9-21.4 29.2-26.7 45.9s-8.5 33.6-9.6 50.6-1.6 33.1-1.6 48.1v21h-98.5v92.4h98.5V1012h115V510.4h150.1V418h-150.1v-43c0-24.6 6.7-43.5 20.1-56.9 13.4-13.4 33.6-20.1 60.8-20.1h69.3v-94.6h-74.8c-15.2.1-31.6.6-49.4 1.7zM5565.8 419l-167.6 446.4L5222.6 419h-119.9l240.4 591.4-97.9 266.6h109.4l327.8-858z\u0022\u003e\u003c/path\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-1.png" alt="" class="wp-image-62"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":63,"sizeSlug":"full","linkDestination":"none","style":{"svgString":"\u003csvg xmlns=\u0022http://www.w3.org/2000/svg\u0022 xml:space=\u0022preserve\u0022 viewBox=\u00220 0 180 42\u0022\u003e\n  \u003cpath fill=\u0022currentColor\u0022 fill-rule=\u0022evenodd\u0022 d=\u0022M17.161 1.235C11.058 2.25 5.336 6.637 2.55 12.437 1.007 15.647.557 17.649.557 21.3c0 3.676.451 5.654 2.042 8.964 1.114 2.318 1.783 3.247 3.802 5.274 2.724 2.738 4.633 3.944 8.058 5.092 8.5 2.85 18.253-.502 23.225-7.981 2.987-4.493 4.13-10.511 2.979-15.683-.641-2.882-2.703-7.025-4.526-9.095-4.593-5.215-11.985-7.8-18.976-6.636m8.201 1.018C32.348 4.023 37.91 9.518 39.783 16.5c.847 3.156.719 7.356-.322 10.605C35.756 38.67 22.99 44.042 12 38.663c-3.264-1.598-6.804-5.041-8.445-8.213-1.497-2.894-1.76-4.107-.31-1.43 2.705 4.997 6.622 8.131 11.905 9.527 2.143.567 6.909.64 9.014.138 5.183-1.234 10.133-5.199 12.368-9.908.66-1.39 1.359-3.195 1.553-4.013.494-2.071.429-6.872-.12-8.941C36.14 8.948 30.047 3.255 23.31 2.131c-1.072-.179-1.275-.272-.648-.296.502-.019 1.717.169 2.7.418m-4.143.328c-.1.1-.359.111-.575.024-.24-.096-.168-.167.181-.181.316-.013.493.058.394.157m4.448.968C33.347 6.223 38.2 13.502 37.703 21.6c-.69 11.236-11.329 18.994-22.224 16.207-3.417-.874-5.691-2.193-8.323-4.828-1.699-1.701-2.574-2.879-3.375-4.544-.595-1.237-1.073-2.436-1.064-2.666.01-.231.328.256.707 1.081 2.071 4.505 6.615 8.257 11.419 9.429 1.929.47 6.206.467 8.114-.007a17.024 17.024 0 0 0 12.59-13.022c.557-2.641.56-4.547.011-7.136-1.3-6.136-6.5-11.519-12.54-12.983-1.198-.29-1.355-.385-.668-.401.495-.012 1.988.357 3.317.819m-5.348-.068c-.1.1-.359.111-.575.024-.24-.096-.168-.167.181-.181.316-.013.493.058.394.157m3.102.598c4.96 1.457 9.067 5.319 10.827 10.183.794 2.192 1.066 6.512.563 8.934-.787 3.79-3.551 7.812-6.91 10.056-2.83 1.889-5.263 2.59-9.001 2.59-2.513 0-3.56-.141-5.18-.697-2.567-.882-5.224-2.648-6.98-4.642-1.41-1.6-3.285-5.066-3.6-6.653-.099-.495.157-.112.567.851 1.916 4.492 5.74 7.864 10.253 9.039 9.763 2.543 19.34-4.806 19.34-14.84 0-6.89-4.672-13.026-11.306-14.849-.794-.219-1.165-.409-.823-.424.341-.015 1.353.188 2.25.452m-5.502.302c-.1.1-.359.111-.575.024-.24-.096-.168-.167.181-.181.316-.013.493.058.394.157m4.431.628c6.006 1.837 10.089 7.361 10.157 13.741.125 11.755-12.653 18.86-22.489 12.503-.983-.636-2.306-1.752-2.938-2.48-1.164-1.338-3.18-5.121-3.18-5.965 0-.252.404.395.898 1.438 1.862 3.937 6.06 6.995 10.304 7.506 4.601.554 8.545-.759 11.682-3.89 5.355-5.347 5.386-13.876.069-19.322-1.585-1.623-5.252-3.715-6.595-3.761a3.838 3.838 0 0 1-1.208-.293c-.906-.41 1.49-.031 3.3.523m-2.79.425c4.028.848 7.334 3.403 9.146 7.07.967 1.957 1.128 2.592 1.237 4.877.207 4.328-.957 7.321-3.947 10.149-4.189 3.962-9.829 4.75-15.033 2.099-1.78-.906-4.463-3.621-5.338-5.402-1.11-2.257-1.314-3.403-.248-1.39 1.215 2.292 3.242 4.238 5.651 5.424 1.888.929 2.201.989 5.172.989 2.951 0 3.293-.064 5.109-.958a12.856 12.856 0 0 0 5.783-5.783c.893-1.815.958-2.159.958-5.103 0-2.801-.091-3.35-.809-4.882-1.005-2.145-3.349-4.661-5.364-5.758-.841-.457-2.497-1.008-3.678-1.222-1.27-.23-1.756-.401-1.189-.417.528-.015 1.676.123 2.55.307m-1.2.903c4.664.99 8.013 4.431 8.951 9.198.796 4.046-1.166 8.76-4.641 11.151-5.593 3.849-13.172 2.069-16.317-3.832-.524-.983-.953-1.972-.953-2.196 0-.224.283.162.628.859.934 1.888 2.79 3.63 4.94 4.635 1.627.762 2.274.895 4.332.895s2.705-.133 4.332-.895c2.298-1.075 4.057-2.807 5.183-5.104.71-1.45.832-2.071.833-4.248.002-2.179-.124-2.822-.862-4.42-.904-1.957-2.907-4.11-4.674-5.024-.541-.28-1.811-.688-2.823-.908-1.011-.22-1.542-.411-1.179-.424.363-.013 1.376.128 2.25.313m.854 1.522a9.866 9.866 0 0 1 4.752 4.741c1.146 2.412 1.123 5.76-.056 8.161-2.861 5.826-10.367 7.282-15.285 2.965-1.085-.953-2.931-4.178-2.918-5.099.003-.262.255.072.56.743 1.845 4.062 6.43 6.098 10.723 4.759 2.471-.77 4.869-3.168 5.639-5.639 1.571-5.039-1.561-10.366-6.646-11.301l-1.433-.264 1.514.088c.833.048 2.25.429 3.15.846m-2.038.539c3.973 1.487 6 6.031 4.566 10.24-1.813 5.321-8.992 6.966-12.982 2.976-1.014-1.014-2.17-2.995-2.147-3.677.008-.213.274.107.593.71 2.084 3.944 7.772 4.801 11.045 1.663 1.542-1.478 2.194-2.994 2.199-5.117.003-1.014-.152-2.247-.343-2.742a7.046 7.046 0 0 0-5.162-4.33c-1.171-.231-1.202-.258-.331-.288.53-.018 1.683.236 2.562.565m-1.761.671c2.439.729 4.385 3.517 4.385 6.282 0 2.619-2.664 5.637-5.382 6.096-2.915.492-6.479-1.776-7.065-4.497l-.194-.9.523 1.005c1.064 2.047 3.989 3.197 6.241 2.454 2.371-.783 3.804-2.693 3.823-5.097.021-2.675-1.594-4.784-4.115-5.375-1.04-.244-1.078-.28-.316-.307.476-.016 1.421.136 2.1.339m-.719 1.213c4.139 2.189 2.595 8.618-2.07 8.618-1.884 0-3.31-.827-4.144-2.404-1.033-1.954-.822-3.796.613-5.359 1.476-1.608 3.573-1.927 5.601-.855m137.404 4.32v3.203l-.721-.678c-.953-.895-2.544-1.226-4.202-.872-1.611.344-3.269 1.999-3.755 3.749-.419 1.509-.409 4.547.019 5.826 1.241 3.707 5.673 5.406 8.082 3.098l.877-.84v.806c0 .785.047.806 1.8.806h1.8V11.4h-3.9v3.202M49.2 20.661V29.7h4.2v-6.6h2.775c3.23-.001 4.331-.422 5.754-2.203.837-1.047.921-1.351.921-3.322 0-2.561-.723-3.912-2.684-5.014-1.065-.599-1.722-.686-6.08-.805l-4.886-.134v9.039m14.4.039v9h3.9v-18h-3.9v9m45.9 0v9h3.9v-4.598c0-4.418.027-4.623.694-5.25.868-.815 2.121-.837 2.906-.052.548.548.6 1 .6 5.25v4.65h3.9l-.001-5.325c-.001-4.812-.06-5.421-.607-6.318-1.356-2.225-5.856-2.549-7.262-.524-.122.174-.223-1.067-.225-2.758L113.4 11.7h-3.9v9m28.2 0v9h3.9v-18h-3.9v9m-78.871-4.538c.755.932.723 2.088-.081 2.944-.574.611-.934.694-3 .694H53.4v-4.564l2.429.111c2.115.096 2.504.201 3 .815m13.854.312c-2.002.512-3.383 2.11-3.383 3.916 0 .54.191.61 1.657.61 1.467 0 1.689-.082 1.927-.709.297-.779.872-1.091 2.01-1.091 1.053 0 1.906.525 1.906 1.174 0 .828-.541 1.116-2.819 1.506-3.853.658-5.151 1.822-5.109 4.583.019 1.234.175 1.622.971 2.418.849.849 1.168.961 3.046 1.067 1.735.098 2.284.009 3.172-.515 1.279-.754 1.339-.763 1.339-.183 0 .345.383.45 1.65.45h1.65l-.001-5.175c-.001-5.804-.229-6.608-2.158-7.606-1.108-.572-4.387-.822-5.858-.445m12.489.422c-1.775.935-2.712 2.637-2.898 5.266-.34 4.802 1.995 7.822 6.056 7.833 2.432.007 4.172-.861 5.304-2.647 1.364-2.151 1.232-2.448-1.084-2.448-1.433 0-1.95.107-1.95.404 0 .746-1.098 1.443-2.117 1.342-1.389-.137-2.168-1.31-2.301-3.467-.124-2.003.31-3.049 1.502-3.62 1.005-.483 2.301.018 2.762 1.067.262.595.516.674 2.175.674 1.694 0 1.879-.06 1.879-.615 0-1.473-1.787-3.548-3.57-4.144-1.739-.582-4.276-.425-5.758.355m14.025-.258c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286H108v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m27.783-.104c-1.571.454-3.246 2.282-3.797 4.145-.6 2.024-.604 2.805-.026 4.752.909 3.061 3.024 4.556 6.443 4.556 4.221 0 6.9-2.674 6.9-6.887 0-4.157-2.709-6.912-6.75-6.866-.99.011-2.237.146-2.77.3m34.317.104c-2.529.901-3.78 2.995-3.79 6.342-.015 4.706 2.039 7.02 6.232 7.02 2.462 0 4.108-.694 5.192-2.19 1.289-1.78 1.18-2.01-.959-2.01-1.373 0-2.017.149-2.59.6-.864.68-1.528.748-2.585.267-.67-.306-1.397-1.388-1.397-2.081 0-.168 1.793-.286 4.35-.286h4.35v-1.447c0-2.061-.775-4.081-1.967-5.128-1.693-1.486-4.476-1.929-6.836-1.087m14.878.159c-.796.485-.975.512-.975.149 0-.345-.408-.446-1.8-.446h-1.8v13.2h3.9v-4.148c0-3.947.033-4.179.694-4.8.485-.455 1.074-.652 1.95-.652h1.256v-3.9l-1.125.001c-.619.001-1.564.269-2.1.596m-73.034 2.928c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m62.1 0c.334.289.695.829.803 1.2.192.66.144.675-2.224.675-1.331 0-2.42-.074-2.42-.165 0-.411.926-1.896 1.269-2.034.811-.327 1.991-.178 2.572.324m-33.518.55c.623.665.727 1.067.726 2.827-.001 1.757-.106 2.163-.727 2.825-.728.774-2.283 1.038-3.459.587-1.265-.486-1.829-4.043-.919-5.802.525-1.016.813-1.157 2.429-1.188.945-.019 1.387.152 1.95.751m19.641.019c.722.778.917 1.77.758 3.856-.149 1.955-1.781 3.188-3.356 2.536-1.932-.8-2.419-5.047-.745-6.487 1.102-.948 2.411-.911 3.343.095M77.1 24.436c0 1.836-1.233 2.983-3.023 2.812-.902-.086-1.038-.21-1.117-1.024-.109-1.113.229-1.426 2.19-2.024 1.984-.606 1.95-.61 1.95.236\u0022\u003e\u003c/path\u003e\n\u003c/svg\u003e","maskSvg":true},"className":"is-style-svg"} -->
<figure class="wp-block-image size-full is-style-svg"><img src="<?php echo esc_url( get_template_directory_uri() );?>/images/brand-2.png" alt="" class="wp-image-63"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->